;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;     CSE 473: AI -- Project 2:
;;     Prodigy Domain:
;;                     Chinese-Seafood-Cooking
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




(setq *OPERATORS* '(


(WASH-KITCHENWARE
;
;    Wash the kitchen-wares with water and detergent,
;        using the water-tap exclusively.	
;
 (params (<kware>))
  (preconds
    (and
     (is-kitchen-ware <kware>)
     (or 
      (contains <kware> grease)
      (contains <kware> food-residue))
     (avail DETERGENT 1-sqz)
     (last-scheduled <kware> <prev-time>)
     (later <time-1> <prev-time>)
     (idle WATER-TAP <time-1>)))
  (effects 
   ((if (contains <kware> grease) (del (contains <kware> grease)))
    (if (contains <kware> food-residue) (del (contains <kware> food-residue)))
    (add (is-wet <kware>))
    (del (last-scheduled <kware> <prev-time>))
    (add (last-scheduled <kware> <time-1>))
    (add (scheduled <kware> WATER-TAP <time-1>)))))



(CUT-FOOD
;
;   Cut non-frozen food, using exclusively the knife and the cutting board.
;
 (params (<food>))
 (preconds
  (and
   (is-food <food>)
   (~(is-frozen <food>))
   (clean KNIFE)
   (clean CUTTING-BOARD)
   (last-scheduled <food> <prev-time>)
   (later <time-1> <prev-time>)
   (idle KNIFE <time-1>)
   (idle CUTTING-BOARD <time-1>)))
 (effects
  ((add (is-cut <food>))
   (del (last-scheduled <food> <prev-time>))
   (add (last-scheduled <food> <time-1>))
   (add (scheduled <food> KNIFE <time-1>))
   (add (scheduled <food> CUTTING-BOARD <time-1>)))))



(WASH-FOOD
;
;   Food is not necessarily clean when bought home, so WASH it,
;       water-tap is being used exclusively.
;
 (params (<food>))
 (preconds
  (and 
   (is-food <food>)
   (~(contains <food> scales))
   (~(contains <food> shell))
   (is-raw <food>)
   (contains <food> unedible-stuff)
   (last-scheduled <food> <prev-time>)
   (later <time-1> <prev-time>)
   (idle WATER-TAP <time-1>)))
 (effects
  ((del (contains <food> unedible-stuff))
   (add (is-wet <food>))
   (del (last-scheduled <food> <prev-time>))
   (add (last-scheduled <food> <time-1>))
   (add (scheduled <food> WATER-TAP <time-1>)))))



(WASH-SCALED-FOOD
;
;   Food such as fish often has scales which are not eatable,
;        thus use nylon-mesh to scratch them away.
;
 (params (<food>))
 (preconds
  (and
   (is-food <food>)
   (contains <food> scales)
   (is-raw <food>)
   (contains <food> unedible-stuff)
   (last-scheduled <food> <prev-time>)
   (later <time-1> <prev-time>)
   (idle WATER-TAP <time-1>)
   (avail NYLON-MESH 1-pc)))
 (effects
  ((del (contains <food> unedible-stuff))
   (del (contains <food> scales))
   (add (is-wet <food>))
   (del (last-scheduled <food> <prev-time>))
   (add (last-scheduled <food> <time-1>))
   (add (scheduled <food> WATER-TAP <time-1>)))))


(REMOVE-SHELL-FROM-FOOD
;
;   A lot of seafood have shells that cannot be eaten, e.g. shrimps, 
;       prawns, crabs, clams, oysters, etc. Need to have shell removed
;       before cooking.
;
 (params (<food>))
 (preconds
  (and
   (is-seafood <food>)
   (contains <food> shell)
   (is-raw <food>)
   (last-scheduled <food> <prev-time>)
   (later <time-1> <prev-time>)
   (idle SHELL-CRACKER <time-1>)))
 (effects
  ((del (contains <food> shell))
   (add (contains <food> unedible-stuff))  ;; remains of shell residue
   (del (last-scheduled <food> <prev-time>))
   (add (last-scheduled <food> <time-1>))
   (add (scheduled <food> SHELL-CRACKER <time-1>)))))



(PUT-IN-DECORATIVE-1
;
;   Chinese food is famous for its rich variety of colors within a dish,
;        very often, decoratives made of matching colored food are also 
;        put into the dish for visual pleasure of the gourmet.
;
 (params (<decor> <c3>))
 (preconds 
  (and
   (is-food <decor>)
   (is-plate <plate>)   
   (on-plate F-PLATE <m-s-food>)
   (on-plate F-PLATE <vegi>)
   (or 
    (is-meat <m-s-food>)
    (is-seafood  <m-s-food>))
   (is-vegetable <vegi>)
   (color-combn <c1> <c2> <c3>)
   (color <m-s-food> <c1>)
   (color <vegi> <c2>)
   (color <decor> <c3>)
   (is-decor-cut <decor>)))
 (effects
  ((add (decor-2-on-plate <m-s-food> <vegi>)))))

(PUT-IN-DECORATIVE-2
;
;   Chinese food is famous for its rich variety of colors within a dish,
;        very often, decoratives made of matching colored food are also
;        put into the dish for visual pleasure of the gourmet. Of course,
;        different style of cooking requires different way of manipulating 
;        the decoratives.					
;
 (params (<decor> <c3>))
 (preconds
  (and
   (is-food <decor>)
   (is-plate <plate>)
   (on-plate S-PLATE <m-s-food>)
   (is-seafood  <m-s-food>)
   (color-combn <c1> <c2> <c3>)
   (color2 <decor> <c2> <c3>)
   (color <m-s-food> <c1>)
   (is-decor-cut <decor>)))
 (effects
  ((add (decor-on-plate <m-s-food>)))))

(PUT-IN-DECORATIVE-3
;
;   Chinese food is famous for its rich variety of colors within a dish,
;        very often, decoratives made of matching colored food are also
;        put into the dish for visual pleasure of the gourmet. Yes, this 
;        is yet another way of arranging decoratives on plates.
;
 (params (<decor1> <c2> <decor2> <c3>))
 (preconds
  (and
   (is-food <decor1>)
   (is-food <decor2>)
   (is-plate <plate>)
   (on-plate D-PLATE <m-s-food>)
   (is-seafood  <m-s-food>)
   (color-combn <c1> <c2> <c3>)
   (color <decor1> <c2>)
   (color <decor2> <c3>)
   (color <m-s-food> <c1>)
   (is-decor-cut <decor>)))
 (effects
  ((add (decor-on-plate <m-s-food>)))))


(DECOR-CUT
;
;    This operator cuts the decorative food into various shapes and volume.
;
 (params (<decor>))
 (preconds
  (and
   (is-food <decor>)
   (avail DECOR-KNIFE 1-pc)))
 (effects
  ((add (is-decor-cut <decor>)))))



(DEFROST
;
;     Frozen food is difficult to cut. It is better to defrost it beforehand.
;
  (params (<food>))
  (preconds
   (and
    (is-food <food>)
    (is-frozen <food>)
    (last-scheduled <food> <prev-time>)
    (later <time-1> <prev-time>)
    (idle HEAT-SRC <time-1>)))
  (effects
   ((del (is-frozen <food>))
    (del (last-scheduled <food> <prev-time>))
    (add (last-scheduled <food> <time-1>))
    (add (scheduled <food> HEAT-SRC <time-1>)))))



(DRY-WITH-TOWEL
;
;    Food that are wet can not be put into boiling oil, or oil may spurt
;         out and burn the cook. So we need to dry them beforehand. Also,
;         after food are deepfried, excess oil should be dried to make
;         the food crispy.
;    Similarly, utentils being used to fry food should be dried before use.
;
 (params (<kware-or-food>))
 (preconds
  (and
   (or (is-food <kware-or-food>) (is-kitchen-ware <kware-or-food>))
   (or (is-wet <kware-or-food>) (is-very-oily <kware-or-food>))
   (avail TOWEL 1-pc)))
 (effects
  ((if (is-wet <kware-or-food>) (del (is-wet <kware-or-food>)))
   (if (is-very-oily <kware-or-food>) (del (is-very-oily <kware-or-food>))))))

(DEEPFRY-SEAFOOD
;
;    A lot of people like crispy seafood, so we can have it by deepfrying,
;          however, it is very oily and some people may not prefer this.
;
 (params (<seafood>))
 (preconds
  (and
   (is-seafood <seafood>)
   (is-raw <seafood>)
   (prepared-deepfry-seafood-sauce)
   (is-kitchen-ware WOK)
   (dry WOK)
   (clean WOK)
   (clean <seafood>)
   (is-cut <seafood>)
   (dry <seafood>)
   (last-scheduled <seafood> <prev-time1>)
   (later <time-1> <prev-time1>)
   (last-scheduled WOK <prev-time2>)
   (later <time-1> <prev-time2>)
   (idle STOVE <time-1>)))
 (effects
  ((del (last-scheduled <seafood> <prev-time1>))
   (add (last-scheduled <seafood> <time-1>))
   (add (scheduled <seafood> STOVE <time-1>))
   (del (last-scheduled WOK <prev-time2>))
   (add (last-scheduled WOK <time-1>))
   (add (scheduled WOK STOVE <time-1>))
   (add (is-filled-with-oil WOK))
   (add (deepfried <seafood>))
   (add (is-very-oily <seafood>))
   (del (is-raw <seafood>))
   (add (contains WOK <seafood>))
   (add (contains WOK grease)))))

(MOVE-DEEPFRY-FROM-WOK-TO-PLATE
;
;    Before serving the very oily deepfried food onto the plate, we need 
;         to dry the excess oil on the food surface to preserve its 
;         cripsiness.
;
 (params (<food>))
 (preconds
  (and
   (is-food <food>)
   (deepfried <food>)
   (contains WOK <food>)
   (dry <food>)
   (last-scheduled <food> <prev-time>)
   (later <time-1> <prev-time>)
   (idle D-PLATE <time-1>)))
 (effects
  ((del (last-scheduled <food> <prev-time>))
   (add (last-scheduled <food> <time-1>))
   (add (scheduled <food> D-PLATE <time-1>))
   (add (contains WOK food-residue))
   (add (on-plate D-PLATE <food>))
   (if (is-very-oily <food>) (del (is-very-oily <food>)))
   (add (is-oily <food>))
   (add (is-crispy <food>))
   (del (contains WOK <food>)))))


   




(STEAM-SEAFOOD
;    Steam food is a favourite Chinese cooking style, as they believe that
;         steaming requires less oil and also less spices, thus preserving
;         most of the original taste of the food while allowing gourmets
;         consumer fewer oil.
; 
 (params (<seafood>))
 (preconds
  (and
   (is-seafood <seafood>)
   (prepared-steam-seafood-sauce)
   (is-kitchen-ware WOK)
   (is-filled-with-water WOK)
   (raw-on-plate <seafood>)
   (last-scheduled <seafood> <prev-time1>)
   (later <time-1> <prev-time1>)
   (last-scheduled WOK <prev-time2>)
   (later <time-1> <prev-time2>)
   (idle STOVE <time-1>)))
 (effects
  ((del (last-scheduled <seafood> <prev-time1>))
   (add (last-scheduled <seafood> <time-1>))
   (del (last-scheduled WOK <prev-time2>))
   (add (last-scheduled WOK <time-1>))
   (add (scheduled <seafood> STOVE <time-1>))
   (add (scheduled WOK STOVE <time-1>))
   (add (steamed <seafood>))
   (add (is-soft-texture <seafood>))
   (del (raw-on-plate <seafood>))
   (add (on-plate S-PLATE <seafood>))
   (add (contains WOK S-PLATE))
   (add (contains WOK <seafood>))
   (del (is-raw <seafood>)))))



(EMPTY-UNTENTIL
;
;     This is equivalent to pouring out the water from the utentil.
;
 (params (<kware>))
 (preconds
  (and
   (is-kitchen-ware <kware>)
   (~(contains <kware> S-PLATE))))
 (effects
  ((if (is-filled-with-water <kware>) (del (is-filled-with-water <kware>)))
   (if (is-filled-with-oil <kware>) (del (is-filled-with-oil <kware>)))
   (add (is-empty <kware>)))))



(TAKE-OUT-STEAMED-FOOD-FROM-WOK-TO-SERVE
;
;     Steam food is done, take it out to serve people.
;
 (params (<food>))
 (preconds
  (and
   (is-kitchen-ware WOK)
   (is-food <food>)
   (contains WOK <food>)
   (contains WOK S-PLATE)))
 (effects
  ((add (serving-steamed-food <food>))
   (del (contains WOK S-PLATE))
   (del (contains WOK <food>)))))



(PUT-RAW-FOOD-ON-PLATE
;
;     For puttng the plate with food into steaming WOK for steaming.
;
 (params (<food>))
 (preconds
  (and
   (is-food <food>)
   (is-raw <food>)
   (clean <food>)
   (last-scheduled <food> <prev-time>)
   (later <time-1> <prev-time>)
   (idle S-PLATE <time-1>)))
 (effects
  ((add (raw-on-plate <food>))
   (del (last-scheduled <food> <prev-time>))
   (add (last-scheduled <food> <time-1>))
   (add (scheduled <food> S-PLATE <time-1>)))))




(FILL-WATER-IN-WOK-FOR-STEAMING
;
;     We use a WOK of water for steaming food.
;
 (preconds
  (and
   (clean WOK)
   (~(contains WOK S-PLATE))
   (last-scheduled WOK <prev-time>)
   (later <time-1> <prev-time>)
   (idle WATER-TAP <time-1>)))
 (effects 
  ((add (is-filled-with-water WOK))
   (del (last-scheduled WOK <prev-time>))
   (add (last-scheduled WOK <time-1>))
   (add (scheduled WOK WATER-TAP <time-1>)))))
   


(STIRFRY-SEAFOOD
;
;      Besides steaming, seafood also tastes good when stirfried in the
;          traditional Chinese style: using ginger, etc.
;
 (params (<seafood>))
 (preconds
  (and
   (is-seafood <seafood>)
   (is-cut <seafood>)
   (dry <seafood>)
   (is-raw <seafood>)
   (dry WOK)
   (clean WOK)
   (clean <seafood>)
   (last-scheduled <seafood> <prev-time1>)
   (later <time-1> <prev-time1>)
   (last-scheduled WOK <prev-time2>)
   (later <time-1> <prev-time2>)
   (idle STOVE <time-1>)
   (prepared-stirfry-seafood-sauce)))
 (effects
  ((del (last-scheduled <seafood> <prev-time1>))
   (add (last-scheduled <seafood> <time-1>))
   (add (scheduled <seafood> STOVE <time-1>))
   (del (last-scheduled WOK <prev-time2>))
   (add (last-scheduled WOK <time-1>))
   (add (scheduled WOK STOVE <time-1>))
   (add (stirfried <seafood>))
   (add (is-slightly-oily <seafood>))
   (del (is-raw <seafood>))
   (add (contains WOK grease))
   (add (contains WOK <seafood>)))))




(STIRFRY-VEGETABLE
;
;       A good Chinese dish should contains both vegetable and meat/fish.
;           A stirfrying is no exception.
;
 (params (<vegi>))
 (preconds
  (and
   (is-vegetable <vegi>)
   (is-raw <vegi>)
   (clean <vegi>)
   (is-cut <vegi>)
   (dry WOK)
   (clean WOK)
   (last-scheduled <vegi> <prev-time1>)
   (later <time-1> <prev-time1>)
   (last-scheduled WOK <prev-time2>)
   (later <time-1> <prev-time2>)
   (idle STOVE <time-1>)
   (prepared-stirfry-vegi-sauce)))
 (effects
  ((del (last-scheduled <vegi> <prev-time1>))
   (add (last-scheduled <vegi> <time-1>))
   (add (scheduled <vegi> STOVE <time-1>))
   (del (last-scheduled WOK <prev-time2>))
   (add (last-scheduled WOK <time-1>))
   (add (scheduled WOK STOVE <time-1>))
   (add (stirfried <vegi>))
   (add (is-slightly-oily <vegi>))
   (del (is-raw <vegi>))
   (add (contains WOK grease))
   (add (contains WOK <vegi>)))))




(MOVE-STIRFRY-FROM-WOK-TO-F-PLATE
;
;      After being stirfried, food is placed on plate ready to serve.
;
 (params (<food> <time-1>))
 (preconds
  (and
   (is-food <food>)
   (stirfried <food>)
   (contains WOK <food>)
   (last-scheduled <food> <prev-time>)
   (later <time-1> <prev-time>)
   (idle F-PLATE <time-1>)))
 (effects
  ((del (last-scheduled <food> <prev-time>))
   (add (last-scheduled <food> <time-1>))
   (add (scheduled <food> F-PLATE <time-1>))
   (add (contains WOK food-residue))
   (add (on-plate F-PLATE <food>))
   (del (contains WOK <food>)))))

))






(setq *INFERENCE-RULES* '(

(INFER-IDLE
;
; This is copied from Schedworld for inferring whether the
;     kitchenware is being used or not.
;
 (params (<k-ware>))
 (preconds
  (forall (<obj2> <kware>)
   (scheduled <obj2> <kware> <time-t>)
   (not-equal <kware> <k-ware>)))
 (effects
  ((add (idle <k-ware> <time-t>)))))


(INFER-PREPARED-STIRFRY-SEAFOOD-SAUCE
 (preconds
  (and
   (avail BROTH 1-cup)
   (avail SESAME-OIL 1-tsp)))
 (effects
  ((add (prepared-stirfry-seafood-sauce)))))

(INFER-PREPARED-STIRFRY-VEGI-SAUCE
 (preconds
  (and
   (avail CORN-OIL 2-tsp)
   (avail GINGER 1-slice)
   (avail SALT 1-pinch)))
 (effects
  ((add (prepared-stirfry-vegi-sauce)))))

(INFER-PREPARED-STEAM-SEAFOOD-SAUCE
 (preconds
  (and
   (avail CORN-OIL 2-tsp)
   (avail GINGER 1-slice)
   (avail SALT 1-pinch)
   (avail GREEN-PEPPER 5-pc)
   (avail SOY-SAUCE 2-tsp)))
 (effects
  ((add (prepared-steam-seafood-sauce)))))

(INFER-PREPARED-DEEPFRY-SEAFOOD-SAUCE
 (preconds
  (and
   (avail CORN-OIL 3-cups)
   (avail SALT 2-tsp)))
 (effects
  ((add (prepared-deepfry-seafood-sauce)))))


(INFER-DRY
										;
										;    Used for both kitchenware and food.
										;
 (params (<kware-or-food>))
 (preconds 
  (and 
   (or (is-food <kware-or-food>) (is-kitchen-ware <kware-or-food>))
   (~ (is-very-oily <kware-or-food>))
   (~ (is-wet <kware-or-food>))))
 (effects
  ((add (dry <kware-or-food>)))))


(INFER-CLEAN
;
;    Used for both kitchenware and food.
;
 (params (<x>))
 (preconds
  (or
   (and
    (is-food <x>)
    (~ (contains <x> unedible-stuff)))
   (and 
    (is-kitchen-ware <x>)
	(~ (contains <x> grease))
	(~ (contains <x> food-residue)))))
 (effects
  ((add (clean <x>)))))


(INFER-SERVING-STIRFRIED-FOOD
;
;     StirFried food is ready to serve.
;
 (params (<food1> <food2>))
 (preconds
  (and
   (is-food <food1>)
   (is-food <food2>)
   (is-plate F-PLATE)
   (on-plate F-PLATE <food1>)
   (on-plate F-PLATE <food2>)))
 (effects
  ((add (serving-stirfried-food <food1> <food2>)))))

(INFER-SERVING-DEEPFRIED-FOOD
;
;     Deepfried food is ready to serve.
;
 (params (<food>))
 (preconds
  (and
   (is-food <food>)
   (is-plate D-PLATE)
   (on-plate D-PLATE <food>)))
 (effects
  ((add (serving-deepfried-food <food>)))))

(INFER-COOKED-FOOD
;
;     To have the food cooked, the food can be steamed, stirfried, 
;           deepfried, boiled, broiled, etc. Given the desired 
;           outcome of the dish, Prodigy will figure out how to have 
;           the food cooked.
;
 (params (<food>))
 (preconds
  (or
   (stirfried <food>)
   (deepfried <food>)
   (steamed <food>)
   (boiled <food>)
   (broiled <food>)))
 (effects
  ((add (cooked <food>)))))


(INFER-GOOD-LOOKING-DISH
;
;      A good looking dish is simply a dish with decoratives.
;
 (params (<food>))
 (preconds
  (and 
   (is-food <food>)
   (or
    (on-plate D-PLATE <food>)
    (on-plate S-PLATE <food>))
   (decor-on-plate <food>)))
 (effects
  ((add (good-looking-dish <food>)))))

(INFER-GOOD-LOOKING-DISH-2
;
;      Another way of decorating the dish, i.e. when one plate contains 
;          more than one kind of food.
;
 (params (<food1> <food2>))
 (preconds
  (and
   (is-food <food1>)
   (is-food <food2>)
   (decor-2-on-plate <food1> <food2>)))
 (effects
  ((add (good-looking-dish-2 <food1> <food2>)))))

(INFER-HEALTHY-DISH
;
;      It is a healthy dish if it does not contains much oil, i.e.
;           steamed food is a healthy dish.
;
 (params (<food>))
 (preconds
  (and
   (is-food <food>)
   (or
    (steamed <food>)
    (boiled <food>))))
 (effects
  ((add (healthy-dish <food>)))))


))




