(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 

;;  Cleaning a car removes dirt and smudges as well as dust.
      '((SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
                    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
          (rhs (select goal <goal>)))

       ))

(setq *SCR-OP-SELECT-RULES*

;;  If only removing dust is needed, then BLOW-OFF-DUST
;; is cheaper so select it.
      '((BLOW-OFF-DUST-TO-REMOVE-DUST
  	  (lhs (and (current-node <node>)
		    (current-goal <node> (dust-free <car>))
                    (candidate-op <node> CHEMICAL-WASH)
                    (candidate-op <node> BLOW-OFF-DUST)))
          (rhs (select operator BLOW-OFF-DUST)))

       ))

(setq *SCR-BINDINGS-SELECT-RULES* nil)

(setq *SCR-NODE-REJECT-RULES* nil)

(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* nil)

;;  All operators dirty the car, so the last thing to 
;; do is either clean or dust it.
;      '((ANYTHING-BEFORE-CLEAN
;          (priority 0)
;  	  (lhs (and (current-node <node>)
;                    (candidate-goal <node> <goal>)
;                    (candidate-goal <node> (clean <car>))
;                    (not-equal <goal> (clean <car>))))
;          (rhs (prefer goal <goal> (clean <car>))))
;       
;        (ANYTHING-BEFORE-DUST-FREE
;          (priority 0)
;  	  (lhs (and (current-node <node>)
;                    (candidate-goal <node> <goal>)
;                    (candidate-goal <node> (dust-free <car>))
;                    (not-equal <goal> (dust-free <car>))))
;          (rhs (prefer goal <goal> (dust-free <car>))))
;
;
;;  HAS-SCRATCHES accomplishes many of the other preconditions
;; that it is with and also destroys some of them, such as clean.
;; Therefore, it should precede all other operators.
;        (HAS-SCRATCHES-BEFORE-ANYTHING
;          (priority 0)
;  	  (lhs (and (current-node <node>)
;                    (candidate-goal <node> (has-scratches <car> <*1-r>))
;                    (candidate-goal <node> <goal>)
;                    (not-equal (has-scratches <car> <*1-r>) <goal>)))
;          (rhs (prefer goal (has-scratches <car> <*1-r>) <goal>)))
;
;;  The surface finish must be ready for painting before
;; the edges can be sanded.
;        (SURFACE-FINISH-BEFORE-SANDED-EDGES
;          (priority 0)
;  	  (lhs (and (current-node <node>)
;                    (candidate-goal <node> (surface-finish <car> <*1-r>))
;                    (candidate-goal <node> (sanded-edges <car>))))
;          (rhs (prefer goal (surface-finish <car> <*1-r>) (sanded-edges <car>))))
;
;;  Priming the surface of the car removes all previous surface
;; conditions.  Therefore, perform it before applying the guidecoat.
;        (SURFACE-FINISH-PRIMED-BEFORE-GUIDECOATED
;          (priority 0)
;  	  (lhs (and (current-node <node>)
;                    (candidate-goal <node> (surface-finish <car> PRIMED))
;                    (candidate-goal <node> (surface-finish <car> GUIDECOATED))))
;          (rhs (prefer goal (surface-finish <car> PRIMED) (surface-finish <car> GUIDECOATED))))
;
;;  It is difficult to disassemble a car when it is all wrapped up 
;; in tape and paper, so mask only after disassembly.
;        (DISASSEMBLE-BEFORE-MASKED
;          (priority 0)
;  	  (lhs (and (current-node <node>)
;                    (candidate-goal <node> (disassembled <car>))
;                    (candidate-goal <node> (masked <car>))))
;          (rhs (prefer goal (disassembled <car>) (masked <car>))))
;
;;  To ensure that the entire surface of the car is etched, this
;; must be done before the car can be masked.
;        (ETCHED-BEFORE-MASKED
;          (priority 0)
;  	  (lhs (and (current-node <node>)
;                    (candidate-goal <node> (etched <car>))
;                    (candidate-goal <node> (masked <car>))))
;          (rhs (prefer goal (etched <car>) (masked <car>))))
;
;;  To sand edges, the car must not be masked.  So applying
;; these operators in the reverse order leads to goal
;; clobbering.
;        (SANDED-EDGES-BEFORE-MASKED
;          (priority 0)
;  	  (lhs (and (current-node <node>)
;                    (candidate-goal <node> (sanded-edges <car>))
;                    (candidate-goal <node> (masked <car>))))
;          (rhs (prefer goal (sanded-edges <car>) (masked <car>))))
;
;       ))


(setq *SCR-OP-PREFERENCE-RULES*

;;  There are four painting techniques in this domain.
;; According to price they can be ordered as SIKKENS, 
;; LACQUER, ACRYLIC and SYNTHETIC.  These rules reflect
;; this ordering.
      '((FIRST-CHOICE-SIKKENS
          (priority 0)
  	  (lhs (and (current-node <node>)
		    (current-goal <node> (surface-finish <car> SHINY))
                    (candidate-op <node> PAINT-CLEAR-SIKKENS)
                    (candidate-op <node> <op>)
                    (not-equal PAINT-CLEAR-SIKKENS <op>)))
          (rhs (prefer operator PAINT-CLEAR-SIKKENS <op>)))

        (SECOND-CHOICE-LACQUER
          (priority 0)
  	  (lhs (and (current-node <node>)
		    (current-goal <node> (surface-finish <car> SHINY))
                    (candidate-op <node> RUB-OUT)
                    (candidate-op <node> <op>)
                    (not-equal PAINT-CLEAR-SIKKENS <op>)
                    (not-equal RUB-OUT <op>)))
          (rhs (prefer operator RUB-OUT <op>)))


        (THIRD-CHOICE-ACRYLIC
          (priority 0)
  	  (lhs (and (current-node <node>)
		    (current-goal <node> (surface-finish <car> SHINY))
                    (candidate-op <node> PAINT-CLEAR-ACRYLIC)
                    (candidate-op <node> <op>)
                    (not-equal PAINT-CLEAR-SIKKENS <op>)
                    (not-equal RUB-OUT <op>)
                    (not-equal PAINT-CLEAR-ACRYLIC <op>)))
          (rhs (prefer operator PAINT-CLEAR-ACRYLIC <op>)))

       ))

(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)
