(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES*
      '(
	(SELECT-FIRST-GOAL                                   ; generic control rule, taken from
	 (lhs (and (current-node <node>)                     ; frozen blocks world.
	           (not-top-level-node <node>)
	           (primary-candidate-goal <node> <goal>)))
	 (rhs (select goal <goal>)))
	))

(setq *SCR-OP-SELECT-RULES* 
      '(

	;;;;;;;;;;;;;;;;;;;;;;;;
	;; These control rules are intended to make sure that only operators that increase
        ;; funds are chosen if funds are needed.
	;;

	(SELECT-OP-IF-MONEY-NEEDED
	 (lhs (and (current-node <node>)
	           (primary-candidate-goal <node> (FUNDS <money>))))
	 (rhs (select op SPEAK-WITH-BUISNESS)))

	(SELECT-OP-IF-MONEY-NEEDED
	 (lhs (and (current-node <node>)
	           (primary-candidate-goal <node> (FUNDS <money>))))
	 (rhs (select op SPEAK-WITH-SPECIAL-INTEREST)))

	(SELECT-OP-IF-MONEY-NEEDED
	 (lhs (and (current-node <node>)
	           (primary-candidate-goal <node (FUNDS <money>))))
	 (rhs (select op SPEAK-WITH-SPECIAL-INTEREST)))
	))
(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES*
      '(
	;;;;;;;;;;;;;;;;;;;;;
	;;  These control rules are intended to make sure that AT-LOC isn't subgoaled on for any
	;; of the transportation operators.
	;;

	(DONT-CHANGE-AT-LOC-FOR-FLY                                ;; credit goes to the class
	 (lhs (and (current-node <node>)                           ;; notes for these rules.
	           (parent-op <node> FLY)
	           (primary-candidate-goal <node> (AT-LOC <loc>))))
	 (rhs (reject goal (AT-LOC <loc>))))

	(DONT-CHANGE-AT-LOC-FOR-DRIVE
	 (lhs (and (current-node <node>)
	           (parent-op <node> DRIVE)
	           (primary-candidate-goal <node> (AT-LOC <loc>))))
	 (rhs (reject goal (AT-LOC <loc>))))
	))

(defun parent-op (node op)
  (and (not-top-level-node node)
       (current-op (node-parent node) op)))
(add-meta-fn 'parent-op)
(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* nil)
(setq *SCR-OP-PREFERENCE-RULES* 
      '(
	;;;;;;;;;;;;;;;;;;;;;
	;;  These control rules establish a preference heirarchy for attaining money from sources.
	;;

	(PREFER-BUISNESS-OVER-SI
	 (lhs (and (current-node <node>)
	           (primary-candidate-goal <node> (FUNDS <money>))))
	 (rhs (prefer op SPEAK-WITH-BUISNESS SPEAK-WITH-SPECIAL-INTEREST)))

	(PREFER-SI-OVER-BANQUET
	 (lhs (and (current-node <node>)
	           (primary-candidate-goal <node> (FUNDS <money>))))
	 (rhs (prefer op SPEAK-WITH-SPECIAL-INTEREST SPONSOR-BANQUET)))
	))
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)



