
;;;SEARCH CONTROL RULES                                  John Carlson
;;;                                                      7932722   
;;;                                                      5/29/91
;;;                                                      Prodigy part III
;;;                                                      brew-domain


;;;The following comprise the search control rules for the brew domain.
;;;Some rules have very little effect while others are quite significant,
;;;in fact some may not be worth the extra time it takes to write and
;;;use them.  Essentially there is very little operator interactivity
;;;and so most of the rules are goal and bindings preference, reject
;;;and select rules.



(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
      '(
;;;This is Prodigy's default scr.
        (SELECT-FIRST-GOAL
          (lhs (and (current-node <node>)
                    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))

;;;IF the goal is to place an item is in inventory then it must be sanitized
;;;first so move it to the sink
	(SELECT-SINK-FROM-INVENTORY-ALWAYS
	 (LHS (AND (CURRENT-NODE <node>)
	           (CURRENT-OP <node> MOVE-OBJ)
	           (CANDIDATE-GOAL <node> (at <ob> <place>))
	           (KNOWN <node> (at <ob> inventory))))
	 (RHS (SELECT GOAL (at <ob> in-sink))))
	))

(setq *SCR-OP-SELECT-RULES* nil)
(setq *SCR-BINDINGS-SELECT-RULES* 
      '(
;;;All stirring in this primitive brewing process will involve a spoon.  This
;;;prevents equipment such as vat, wort-pot, ... from used as a stirring
;;;instrument.
       (STIR-WITH-A-SPOON
	(LHS (AND (CURRENT-NODE <node>)
	          (CURRENT-OP <node> STIRRING)))
	(RHS (SELECT BINDINGS (<ob> spoon))))

;;;Try to ensure that equipment of all types will be moved from inventory
;;;to the sink only
       (MOVE-FROM-INVENTORY-TO-SINK
	(LHS (AND (CURRENT-NODE <node>)
	          (CURRENT-OP <node> MOVE-OBJ)
	          (KNOWN <node> (at <ob> inventory))))
	(RHS (SELECT BINDINGS (<ob> inventory in-sink))))
	))
(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* nil)





(setq *SCR-BINDINGS-REJECT-RULES* 
      '(
;;;This rule prevents an object from being moved to where it currently resides.
       (DONT-MOVE-OBJECT-TO-PLACE-IT-IS-CURRENTLY-AT
	(LHS (AND (CURRENT-NODE <node>)
	          (CURRENT-OP <node> MOVE-OBJ)

;;;Move from current location to current location
	          (CANDIDATE-BINDINGS <node> (<ob> <place1> <place1>))))

;;;Do not make this move
	(RHS (REJECT BINDINGS (<ob> <place1> <place1>))))
	))
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* 
      '(

;;;The sink must be used when washing
	(PREFER-SINK-WHEN-PURIFYING
	 (LHS (AND (CURRENT-NODE <node>)
	           (CURRENT-OP <node> MOVE-OBJ)
	           (IS-TOP-LEVEL-GOAL <node> WASH-EQUIP)
	           (CANDIDATE-GOAL <node> (at <ob> in-sink))
	           (CANDIDATE-GOAL <node> (at <ob> <place>))))
	 (RHS (PREFER GOAL (at <ob> in-sink) (at <ob> <place>))))
	))
(setq *SCR-OP-PREFERENCE-RULES* 
      '(
;;;IF more than one operator with boiling in effects, then pick boil operator.
;;;This would be the case in the expanded version of the program 
;;;(wort processing, for example)
	(IF-NEED-HOT-THEN-CHOOSE-BOIL
	 (LHS (AND (CURRENT-NODE <node>)
	           (CURRENT-GOAL <node> (BOILING <ob> <liquid>))
	           (CANDIDATE-OP <node> <op>)

;;;must first have some fluid in the container before boil
	           (KNOWN <node> (HAS <ob> <liquid>))))
	 (RHS (PREFER OPERATOR BOIL <op>)))
	))






(setq *SCR-BINDINGS-PREFERENCE-RULES* 
      '(

;;;preference of bindings so that attempt to move to the sink first if
;;;begin in inventory (already covered to some extent in rules above)
       (MOVE-FROM-INVENTORY-TO-SINK-BINDINGS
	(LHS (AND (CURRENT-NODE <node>)
	          (CURRENT-OP <node> MOVE-OBJ)
	          (CANDIDATE-BINDINGS <node> (<ob> inventory <place2>))

;;;If nowhere then must be in inventory.  Cannot ask if inventory since
;;;an inference rule determines this fact
	          (KNOWN <node> (AND (~ (at <ob> in-sink))
				     (~ (at <ob> in-dry-rack))
				     (~ (at <ob> in-vat1))
				     (~ (at <ob> on-stove))))))
	(RHS (PREFER BINDINGS (<ob> inventory in-sink)
	                      (<ob> inventory <place2>))))

;;;When beginning the sanitizing process, be sure to do the cleaning
;;;in the sink and not attempt to clean equipment on the stove or in
;;;inventory or ...etc
	(PREFER-SINK
	 (LHS (AND (CURRENT-NODE <node>)
	           (CURRENT-OP <node> SANITIZE-EQUIP)

;;;This is the binding that is likely
	           (CANDIDATE-BINDINGS <node> (<ob> in-sink))

;;;The remainder of the bindings is unlikely at this stage
	           (CANDIDATE-BINDINGS <node> (<ob> <place1>))))

;;;so order the likely candidate first
	 (RHS (PREFER BINDINGS (<ob> in-sink)
	                       (<ob> <place1>))))
;;;When beginning the cleaning process, be sure to do the cleaning
;;;in the sink and not attempt to clean equipment on the stove or in
;;;inventory or ...etc
	(PREFER-SINK-WHEN-CLEANING
	 (LHS (AND (CURRENT-NODE <node>)
	           (CURRENT-OP <node> CLEAN-EQUIP)

;;;This is the binding that is likely
	           (CANDIDATE-BINDINGS <node> (<ob> in-sink))

;;;The remainder of the bindings is unlikely at this stage
	           (CANDIDATE-BINDINGS <node> (<ob> <place1>))))

;;;so order the likely candidate first
	 (RHS (PREFER BINDINGS (<ob> in-sink)
	                       (<ob> <place1>))))

	))
	