

;;;Brew-domain                                             John Carlson
;;;-----------                                             7932722
;;;                                                        c473 project part II
;;;                                                        5/20/91


;;;see README file for a general description and explanation.




;;; Operators

(setq *OPERATORS* '(



;;;*************SANITIZE**************


;;;this operator is the basis operator for the various steps to 
;;;purifying the equipment

(SANITIZE-EQUIP
 (params (<ob> <from-loc>))
 (preconds (and (equip <ob>)
	        (place <from-loc>)
	        (at <ob> <from-loc>)
	        (clean <ob>)	       
	        (rinse <ob>)
                (chlorine <ob>)))
 (effects ((add (purify <ob>))
	   (add (at <ob> in-dry-rack))
	   (del (chlorine <ob>))
	   (del (at <ob> <from-loc>)))))



;;;this operator will ensure that equipment is rinsed and soaped

(CLEAN-EQUIP
 (params (<ob> <from-loc>))
 (preconds
          (and (equip <ob>)
	       (place <from-loc>)
	       (rinse <ob>)
	       (at <ob> <from-loc>)
	       (soap <ob>)))
 (effects ((add (clean <ob>))
	   (del (at <ob> <from-loc>))
	   (add (at <ob> dry-rack))
	   (del (soap <ob>)))))



;;;here the equipment is scheduled to use the sink and then rinsed

(WASH-EQUIP
 (params (<ob-s> <time-s> <prev-time-s>))
 (preconds (and (equip <ob-s>)
	        (at <ob-s> in-sink)
		(dirty <ob-s>)
	        (rinse <ob-s>)
	        (last-scheduled <ob-s> <prev-time-s>)
	        (later <time-s> <prev-time-s>)
	        (idle sink <time-s>)))
 (effects ((add (soap <ob-s>))
	   (del (last-scheduled <ob-s> <prev-time-s>))
	   (add (last-scheduled <ob-s> <time-s>))
	   (add (scheduled <ob-s> sink <time-s>))
	   (del (rinse <ob-s>)))))


;;;schedule to use the sink for the chlorining process which is 
;;;essential to purity

(CHLORINE-EQUIP
 (params (<ob-c> <time-c> <prev-time-c>))
 (preconds (and (equip <ob-c>)
		(at <ob-c> in-sink)
	        (last-scheduled <ob-c> <prev-time-c>)
		(rinse <ob-c>)
		(clean <ob-c>)
	        (later <time-c> <prev-time-c>)
	        (idle sink <time-c>)))
 (effects ((add (chlorine <ob-c>))
	   (del (last-scheduled <ob-c> <prev-time-c>))
	   (add (last-scheduled <ob-c> <time-c>))
	   (add (scheduled <ob-c> <sink> <time-c>))
	   (del (rinse <ob-c>)))))   



;;;basic rinse operator which is used numerous times at various
;;;stages of the purifying process.  Again schedule use of the sink.
;;;the if statement in the effects forces the equipment to be put in
;;;the proper place


(RINSE-EQUIP
 (params (<ob-r> <time-r> <prev-time-r>))
 (preconds (and (equip <ob-r>)
	        (at <ob-r> in-sink)
	        (water-running)
	        (last-scheduled <ob-r> <prev-time-r>)
	        (later <time-r> <prev-time-r>)
	        (idle sink <time-r>)))
 (effects ((add (rinse <ob-r>))
	   (del (last-scheduled <ob-r> <prev-time-r>))
	   (add (last-scheduled <ob-r> <time-r>))
	   (add (scheduled <ob-r> sink <time-r>))
	   (del (water-running))
	   (IF  (soap <ob-r>)
	        (add (at <ob-r> in-dry-rack))
	        (del (at <ob-r> in-sink)))
	        (add (at <ob-r> in-dry-rack))
	        (del (at <ob-r> in-sink)))))




(TURN-WATER-ON
 (preconds (water-off))
 (effects ((add (water-running)))))


;;;basic move operator as in the tower of hanoi

(MOVE-OBJ
 (params (<ob> <loc-from> <loc-to>))
 (preconds
          (and (equip <ob>)
	       (place <loc-from>)
	       (place <loc-to>)
	       (at <ob> <loc-from>)))
 (effects ((add (at <ob> <loc-to>))
	   (del (at <ob> <loc-from>)))))





;;;*************WORT PROCESS************************

;;;the beer is brewed in this operator.  it contains the ability
;;;to keg the beer as well, but it is not fully debugged at present


(BREW-BEER
 (params (<beer> <vat> <yeast>))
 (preconds
          (and (beer-type <beer>)
	       (vequip <vat>)
;	       (equip <keg>)
	       (yeast-type <yeast>)
	       (wort-process <beer>)
	       (vat-ferment-first-stage <beer> <vat>)
	       (add-ingred <yeast> <vat>)))
;	       (has keg <beer>)))
 (effects ((add (brew-beer <beer>)))))


;;;this operator would place the beer in the keg, but kegging is not
;;;functional at present

(KEG-IT
 (params (<beer> <vat>))
 (preconds
          (and (beer-type <beer>)
	       (vequip <vat>)
	       (transfer <beer> keg)))
 (effects ((add (syphon <beer> keg))
	   (del (has <vat> <beer>)))))



;;;vequip is used to distinguish the vat from other equipment as it is
;;;special and is not processed as other equipment.  The vat is where
;;;fermentation takes place.  Usually two vats are used but not always, in
;;;this case only one is used.  the wort must thus be moved from the
;;;wort-pot to the vat and the vat must be scheduled since there is
;;;generally heavy rotation of batches.

(VAT-FERMENTATION
 (params (<vat-v> <w-pot> <time-v> <prev-time-v>))
 (preconds
          (and 
	       (equip <w-pot>)
	       (vequip <vat-v>)
	       (transfer wort <vat-v>)
	       (last-scheduled <w-pot> <prev-time-v>)
	       (later <time-v> <prev-time-v>)
	       (idle <vat-v> <time-v>)))
(effects ((add (vat-ferment-first-stage <beer> <vat-v>))
	  (del (last-scheduled <w-pot> <prev-time-v>))
	  (add (last-scheduled <w-pot> <time-v>))
	  (add (scheduled <w-pot> <vat-v> <time-v>)))))





;;;perfom wort transfer and filling of keg (not used for tranfer to keg at
;;;present).  the container being filled must be empty and the other 
;;;container should contain the appropriate solution (unified through
;;;some other operator).

(TRANSFER-FLUID
 (params (<liquid> <container1> <container2>))
 (preconds
          (and (fluid <liquid>)
	       (equip <container1>)
	       (vequip <container2>)
	       (place <container2-place>)
	       (has <container1> <liquid>)
	       (empty <container2>)
	       (at <container1> <container2-place>)))
 (effects ((add (transfer <liquid> <container2>))
	   (add (has <container2> <liquid>))
	   (del (has <container1> <liquid>)))))




;;;here is where the wort is created and brewed.  the various ingredients
;;;are added and the wort-pot is automatically purified.  the wort-pot is
;;;no longer clean and so is deleted as purified.

(WORT-PROCESS
 (params (<beer> <malt> <toast-barley> <hops>))
 (preconds (and
	        (beer-type <beer>)
	        (malt-type <malt>)
		(tbar-type <toast-barley>)
	        (hop-type <hops>)
	        (purify wort-pot)	       
	        (boiling wort-pot water)
	        (add-ingred <malt> wort-pot)
		(add-ingred <toast-barley> wort-pot)
	        (add-ingred <hops> wort-pot)))
 (effects ((add (wort-process <beer>))
	   (del (add-ingred <malt> wort-pot))
	   (del (add-ingred <hops> wort-pot))
	   (del (add-ingred <toast-barley> wort-pot))
	   (del (purify wort-pot))
	   (add (has wort-pot wort))
	   (del (has wort-pot water)))))




;;;this operator performs the adding of various ingredients to whatever
;;;piece of equipment is required

(ADDING-INGREDIENT
 (params (<ingred> <ob1>))
 (preconds 
          (and (or (equip <ob1>)
		   (vequip <ob1>))
	       (equip <ob2>)
	       (or (malt-type <ingred>)
		   (hop-type <ingred>)
		   (yeast-type <ingred>)
		   (tbar-type <ingred>))
	       (stir <ob1> <ob2>)))
 (effects ((add (add-ingred <ingred> <ob1>))
	   (del (stir <ob1> <ob2>)))))


  
;;;simple stir operator (not an inference rule since stir is deleted
;;;in other operator(s).  

(STIRRING
 (params (<ob>))
 (preconds (or (equip <ob>)
	       (vequip <ob>)))
 (effects ((add (stir <ob> spoon)))))

	       




;;;here whatever needs to be boiled (water and the wort) can be
;;;scheduled on an element on the stove (presently only one element
;;;is availible)

(BOIL
 (params (<liquid> <ob-b> <element-b> <time-b> <prev-time-b>))
 (preconds
          (and (equip <ob-b>)
	       (fluid <liquid>)
	       (fixed-feature <element-b>)
	       (hot <element-b>)
	       (has <ob-b> <liquid>)
	       (last-scheduled <ob-b> <prev-time-b>)
	       (at <ob-b> on-stove)
	       (later <time-b> <prev-time-b>)
	       (idle <element-b> <time-b>)))
 (effects ((add (boiling <ob-b> <liquid>))
	   (del (last-scheduled <ob-b> <prev-time-b>))
	   (add (last-scheduled <ob-b> <time-b>))
	   (add (scheduled <ob-b> <element-b> <time-b>)))))



;;;the stove element is turned on with this operator
;;;fixed-feature is a type used to distinguish the element of the 
;;;stove from a general piece of equipment

(STOVE-ON
 (params (<element-s>))
 (preconds
          (and (fixed-feature <element-s>)
	       (cold <element-s>)))
 (effects ((add (hot <element-s>)))))



;;;this operator specifically adds water.  No amount is specifiable at this
;;;time, it is assumed that the correct amount would be stated in the state.

(ADD-WATER
 (params (<ob-a> <time-a> <prev-time-a>))
 (preconds
          (and (equip <ob-a>)
	       (empty <ob-a>)
	       (water-running)
	       (last-scheduled <ob-a> <prev-time-a>)
	       (later <time-a> <prev-time-a>)
	       (idle sink <time-a>)))
 (effects ((add (has <ob-a> water))
	   (del (last-scheduled <ob-a> <prev-time-a>))
	   (add (last-scheduled <ob-a> <time-a>))
	   (add (scheduled <ob-a> sink <time-a>))
	   (del (water-running)))))

	       





;;;*************INFERENCE RULES**********************

(INFER-WATER-RUNNING
 (preconds
  (~ (water-running)))
 (effects ((add (water-off)))))
  

;;;if not in any of these places then must be in inventory

(INFER-AT-INVENTORY
 (params (<ob>))
 (preconds (and
  (~ (exists (<ob>) (at <ob> in-vat1)))
  (~ (exists (<ob>) (at <ob> in-sink)))
  (~ (exists (<ob>) (at <ob> on-stove)))
  (~ (exists (<ob>) (at <ob> in-dry-rack)))))
 (effects ((add (at <ob> inventory)))))


;;;must be dirty if not entirely purified


(INFER-DIRTY
 (params (<ob>))
 (preconds
  (and (~ (exists (<ob>) (equip <ob>) (clean <ob>)))
       (~ (exists (<ob>) (equip <ob>) (soap <ob>)))
       (~ (exists (<ob>) (equip <ob>) (chlorine <ob>)))))
 (effects ((add (dirty <ob>)))))
  


;;;if no one has turned on the element then it must be off

(INFER-COLD-ELEMENT
 (params (<element>))
 (preconds
  (~ (exists (<element>) (fixed-feature <element>) (hot <element>))))
 (effects ((add (cold <element>)))))
  

;;;if nothing has been explicitly add to a pot or vat then it is 
;;;presumed empty

(INFER-EMPTY
 (params (<ob> <liquid>))
 (preconds
  (~ (exists (<ob> <liquid>) (equip <ob>) (has <ob> <liquid>))))
 (effects ((add (empty <ob>)))))
  


;;;Taken from Schedworld domain

(INFER-IDLE 
 (params (<mach> <time-t>))
 (preconds
          (FORALL (<obj2> <m>)
		  (scheduled <obj2> <m> <time-t>)
		  (not-equal <m> <mach>)))
 (effects ((add (idle <mach> <time-t>)))))





))

