
;; Assuming that snow and rainstorm could be mixed this problem flies from Seattle
;; to Portland handling both of these conditions

(load-goal '(
	     and
	     (current-position PORTLAND)
;	     (on-ground)
;	     (tank 2000)
;	     (tank FULL)
	     ))



(load-start-state
 '(

   (angle 10)
   (weather-type RAINSTORM)
   (weather-type HI-WIND)
   (weather-type LOW-WIND)
   (weather-type TURBULENCE)
   (weather-type LOW-PRESSURE)
   (weather-type SUNNY)
   (weather-type SNOW)
   (weather-type HAIL)

   (flap-position UP)
   (flap-position NEUTRAL)            ;; take-off
   (flap-position DOWN)               ;; landing

   (stick-position FRONT)             ;; landing  (descend)
   (stick-position BACK)              ;; take-off (ascend)
   (stick-position LEFT)              ;; turning
   (stick-position RIGHT)             ;; turning
   (stick-position NEUTRAL)           
   
   (gear-position  UP)                ;; after take-off
   (gear-position  DOWN)              ;; before landing

   (rudder-position NEUTRAL)          
   (rudder-position LEFT)
   (rudder-position RIGHT)

   (throttle-level  FULL)
   (throttle-level  MEDIUM)
   (throttle-level  LOW)
   (throttle-level  OFF)

   (runway-state CLEAR)
   (runway-state BUSY)

   (full-tank    2000)
   (tank-level   FULL)
   (tank-level   MEDIUM)
   (tank-level   LOW)
   (tank-level   EMPTY)

   (direction    NORTH)
   (direction    SOUTH)
   (direction    EAST)
   (direction    WEST)

   (switch-type       AIR-CONDITIONING)
   (switch-type       CABIN-PRESSURE-HI)
   (switch-type       CABIN-PRESSURE-LOW)
   (switch-type       WIND-SCREEN-WIPER)

   (on-off      ON)
   (on-off      OFF)
   
   (gas-truck-position  NEAR)
   (gas-truck-position  FAR)
	
;;;  cities 

   (city  VANCOUVER)
   (city  SEATTLE  )
   (city  PORTLAND )
   (city  SANFRANCISCO )
   (city  SANJOSE      )
   (city  LOSANGELES   )
   (city  SANDIEGO     )
   (city  TORONTO      )
   (city  CHICAGO      )
   (city  RHINO        )

;;; available flight paths

   (path SEATTLE PORTLAND)
   (path LOSANGELES SANDIEGO)
   (path PORTLAND SANFRANCISCO)
   (path SANFRANCISCO LOSANGELES)
   (path PORTLAND CHICAGO)
   (path CHICAGO  RHINO)
   
   (path RHINO   SANDIEGO)
   (path SEATTLE VANCOUVER)
   (path VANCOUVER TORONTO)
   (path TORONTO CHICAGO)
   (path CHICAGO SANJOSE)
   (path SANJOSE LOSANGELES)

;;; Current weather forcast 
;;; you can get to the destination only if the weather is sunny or stable
;;; (weather SEATTLE  PORTLAND        STABLE)
;;; it's conceivable that the auto-pilot cannot find any way to handle
;;; the current weather condition so the planner should return the plane
;;; the to the originating airplane

   (weather SEATTLE  PORTLAND        RAINSTORM)
   (weather SEATTLE  PORTLAND        SNOW)
;   (weather SEATTLE  PORTLAND        HI-WIND)
;   (weather SEATTLE  PORTLAND        TURBULENCE)
   (weather LOSANGELES SANDIEGO      LOW-WIND)
   (weather PORTLAND SANFRANCISCO    LOW-PRESSURE)
   (weather SANFRANCISCO LOSANGELES  HI-WIND)
   (weather PORTLAND CHICAGO         SUNNY)
   
   (weather SEATTLE VANCOUVER        RAINSTORM)
   (weather VANCOUVER TORONTO        SNOW)
   (weather TORONTO CHICAGO          HI-WIND)
   (weather CHICAGO SANJOSE          HI-WIND)
   (weather SANJOSE LOSANGELES       SUNNY)

;;;
;;; Current States
;;;

   (current-position   SEATTLE)             ;; current position
   (route       SEATTLE SANDIEGO)
   (distance    SEATTLE SANDIEGO 1000)      ;; (miles)  just a wild guess

   (on-ground)
   (gas-truck   NEAR)
   (runway      CLEAR)

;;   (tank        EMPTY)                      ;; (gallons)
   (tank        30)                      ;; (gallons)
   (stick       BACK)
   (flap        NEUTRAL)
   (gear        DOWN)
   (rudder      NEUTRAL)
   (throttle    FULL)

   (switch     AIR-CONDITIONING   OFF)
   (switch     CABIN-PRESSURE-HI  OFF)
   (switch     CABIN-PRESSURE-LOW OFF)
   (switch     WIND-SCREEN-WIPER  OFF)
   
   
   ))








