

(defun less-than (a b)
  (cond ((is-variable a) 'no-match-attempted)
	((is-variable b) 'no-match-attempted)
	((< a b) t)))


(defun difference (x y)
  (cond ((is-variable a) 'no-match-attempted)
	((is-variable b) 'no-match-attempted)
	(t (- x y))))

  

(defun binding-list (var val-list)
  (cond ((null val-list) nil)
        ((null (car val-list)) (binding-list var (cdr val-list)))
        (t (append (list (list (list var (car val-list))))
                   (binding-list var (cdr val-list))))))


(defun Generate (old new cred)
  (cond ((and (is-variable old) (is-variable new) (is-variable cred))
	  'no-match-attempted)
	((and (is-variable old) (is-variable new))
	 (append
	  (binding-list old        (generate-old-new-angle cred))
	  (binding-list new  (rest (generate-old-new-angle cred)))))

	((and (is-variable old) (is-variable cred))
	 (append
	  (binding-list cred '(3 4 5))
	  (binding-list old  (Generate-old new '(3 4 5)))))

	((and (is-variable new) (is-variable cred))
	 (append
	  (binding-list cred '(3 4 5))
	  (binding-list new  (generate-new-angle old '(3 4 5)))))

	((is-variable old)
	 (binding-list old  (list (- new cred))))

	((is-variable new)
	 (binding-list new  (list (+ old cred))))

	((is-variable cred)
	 (binding-list cred (list (- new old))))

	(t (= new (+ old cred)))))

;;
;; GENERATE-OLD-NEW-ANGLE:  Used by Generate when ONLY
;;   angle is known and possible bindings for OLD and NEW
;;   must be generated.  Generates numbers from 0 to *MAX-ANGLE*
;;   stepping by CRED.
;;
;; For *MAX-ANGLE* = 20:
;;   (generate-old-new-angle 3)  returns: (3 6 9 12 15 18 21)
;;   (generate-old-new-angle 4)  returns: (4 8 12 16 20)
;;   (generate-old-new-angle 5)  returns: (5 10 15 20)

(defun generate-old-new-angle (cred &optional (n 0))
  (cond
    ((>= n *MAX-ANGLE*) nil)
    ((cons (+ cred n) (generate-old-new-angle cred (+ n cred))))))

;;
;; GENERATE-NEW-ANGLE:  Used by Generate when we have
;;   ONLY OLD bound and we must generate possible bindings
;;   for NEW.  Generates numbers by adding each CRED candidate
;;   to OLD.
;;
;; For cred = '(3 4 5):
;;   (generate-new-angle 9 '(3 4 5))  returns: (12 13 14)
;;   (generate-new-angle 0 '(3 4 5))  returns: (3 4 5)
;;

(defun generate-new-angle (old cred)
  (cond
    ((null cred) nil)
    (t (cons (+ (first cred) old) (generate-new-angle old (rest cred))))))


;;
;; Generate-old:  Used by Generate when we have
;;   ONLY NEW bound and we must generate possible bindings
;;   for OLD.  Generates numbers by subtracting each CRED candidate
;;   from NEW.
;;
;; For cred = '(3 4 5):
;;   (Generate-old 9 '(3 4 5))  returns: (6 5 4)
;;   (Generate-old 5 '(3 4 5))  returns: (2 1 0)
;;   (Generate-old 4 '(3 4 5))  returns: (1 0)
;;

(defun Generate-old (new cred)
  (cond
    ((null cred) nil)
    ((OR (plusp (- new (first cred))) (zerop (- new (first cred))))
     (cons (- new (first cred)) (Generate-old new (rest cred))))
    (t nil)))





  


(defun Decrement (old new cred)
  (cond ((and (is-variable old) (is-variable new) (is-variable cred))
	  'no-match-attempted)

	((and (is-variable old) (is-variable new))
	 (append
	  (binding-list old        (generate-old-new-angle cred))
	  (binding-list new  (rest (generate-old-new-angle cred)))))

	((and (is-variable old) (is-variable cred))
	 (append
	  (binding-list cred '(3 4 5))
	  (binding-list old  (Generate-old new '(3 4 5)))))

	((and (is-variable new) (is-variable cred))
	 (append
	  (binding-list cred '(3 4 5))
	  (binding-list new  (generate-new-angle old '(3 4 5)))))

	((is-variable old)
	 (binding-list old  (list (- new cred))))

	((is-variable new)
	 (binding-list new  (list (+ old cred))))

	((is-variable cred)
	 (binding-list cred (list (- new old))))

	(t (= new (+ old cred)))))

