(setq *OPERATORS* '(

;; chooose-flight try to find a flight that depart from the
;; current city where you are at and at anytime which is no
;; earlier than the current time.  
;;
;; preconds: must be in the current city.
;;           there is a flight depart from this city
;;                                    later than current time.
;;           the arrival time to city <to> fulfills 
;;               some time constraints(a list) which is
;;               optional to the lisp function 
;;               check-time-constraint.
;;           to check if the total cost so far exceeds the 
;;               budget.
;; effects : update the total-cost-so-far
;;           update that we have just chosen a flight.
;;
(CHOOSE-FLIGHT
    (params (<at> <to> <aAirLine> <ticket-price> <time-depart> <time-arrival>))
    (preconds
       (exists (<to>) (flight <aAirLine> <at> <to> <f-num>)
        (and (current-city <at>)
	     (flight-info <f-num> <time-depart> <time-arrival> <ticket-price>)
	     (current-time <curTime>)
	     (later-time  <time-depart>  <curTime>)
	     (check-time-constraint <to> <time-arrival>)
	     (total-cost-so-far <this-amount>)
	     (sum <this-amount> <ticket-price> <new-amount>)
	     (~ (over-budget <new-amount>))
   )))

   (effects (
     (del (total-cost-so-far <this-amount>))
     (del (flight-chosen <*at> <*to> <*time-depart> <*time-arrival>))
     (add (total-cost-so-far <new-amount>))
     (add (flight-chosen <at> <to> <time-depart> <time-arrival>))
    )))



;; depart-from basically makes the output more infomative.
;; After we have chosen which flight has been chosen,
;; we tell the user about where the flight depart from,
;; and where it arrivals, and at what time.
;; precond: flight has already been chosen
;;          the chosen flight which depart from CURRENT city.
;;          calculate how long the customer has to stay in 
;;          the current city.
;; 
;; effects: not at CURRENT city.
;;          current time changed to be time of arrival.
;;          update the time-stay at the CURRENT city
;;          customer is at city <to>
;;          customer has visited city <to>
;;          update current time to be time of arrival.
(DEPART-FROM
    (params (<at> <to> <time-depart>))
    (preconds
        (and (flight-chosen <at> <to> <time-depart> <time-arrival>)
	     (current-city <at>)
	     (current-time <curTime>)
	     (subtract <time-depart> <curTime> <time-stay>)
   ))

   (effects (
      (del (current-city <at>))
      (del (current-time <curTime>))
      (del (time-stay-at <at> <*anytime>))
      (add (current-time <time-depart>))
      (add (time-stay-at <at> <time-stay>))
      (add (current-city <to>))
      (add (city-visited <to>))
      (add (city-visited-at <to> <time-arrival>))
      (add (current-time <time-arrival>))
    )))

;; arrive-at make the output more informative so that the customer
;; can easily know it arrive at the city at what time.
;;
;; preconds: customer is on the flight.
;;
;; effects:  customer is no longer on the flight.



;; arrival-last-city tells this is the final stop and the goal has
;; accomplished.
;;
;; preconds: check the last city(destination) and compare with the
;;           current city where he is at.
;;
;; effects:  last-city has been accomplished.

(ARRIVAL-LAST-CITY
   (params (<aCity>))
   (preconds
     (and
       (flight <aAirLine> <from> <aCity> <f-num>)
       (current-city <aCity>)
   ))

   (effects (
      (add (last-city <aCity>))
   )))

	     
;; check-time-stay checks if the customer has stayed in a city 
;; at least the time he wants to.
;; 
;; preconds: checks if he has visited that city
;;           and how long he stayed
;;           and make sure he stayed long enough
;;
;; effects:  tells the minimum time of staying at specific city
;;           has been met.
(CHECK-TIME-STAY
      (params ( <city> <time-wanted> <time-stayed>))
      (preconds
         (and (city-visited <city>)
	      (time-stay-at <city> <time-stayed>)
	      (~ (less-than <time-stayed> <time-wanted>))
      ))

      (effects (
	 (add (time-stay <city> <time-wanted>))
   )))

))  ; end of setq *OPERATORS*

	
(setq *INFERENCE-RULES* '(


		       ))