;;; -------------------------------------------------------------------------
;;; -------------------------------------------------------------------------
;;;  functions.lisp for WarWorldII
;;; -------------------------------------------------------------------------
;;; -------------------------------------------------------------------------


(defun less-than (number1 number2)
   (cond ( (is-variable number1) 'no-match-attempted)
         ( (is-variable number2) 'no-match-attempted)
         ( (< number1 number2)   t		    ) ))


(defun gtr-or-eql (number1 number2)
   (cond ( (is-variable number1) 'no-match-attempted)
         ( (is-variable number2) 'no-match-attempted)
         ( (>= number1 number2)  t		    ) ))


(defun equals (number1 number2)
   (cond ( (is-variable number1) 'no-match-attempted)
         ( (is-variable number2) 'no-match-attempted)
         ( (= number1 number2)   t		    ) ))



;;; -------------------------------------------------------------------------
;;;  This is modified from extended-blocksworld:  It uses the same basic
;;;  idea, with cases 3 and 4 added (also fixed error in case 1).  The
;;;  function can generate values for any argument, if the other two
;;;  are known.
;;; -------------------------------------------------------------------------
	  
(defun add-numb (x y z)
    (cond ((and (not (is-variable z))		; case:  x + y = z ??
		(not (is-variable x))
		(not (is-variable y)))
	   (= z (+ x y)))

	  ((and (is-variable x)			; case:  ? + y = z
		(not (is-variable y))
		(not (is-variable z)))
	   (list (list (list x (- z y)))))

	  ((and (not (is-variable x))		; case:  x + ? = z
		(is-variable y)
		(not (is-variable z)))
	   (list (list (list y (- z x)))))

	  ((and (is-variable z)			; case:  x + y = ?
		(not (is-variable x))
		(not (is-variable y)))
	   (list (list (list z (+ x y)))))

	  (t 'no-match-attempted)))



;;; -------------------------------------------------------------------------
;;;  Mul-numb is another variation on the previous function.  This one only
;;;  does cases all known and product unknown.
;;; -------------------------------------------------------------------------
	  
(defun mul-numb (x y z)
    (cond ((and (not (is-variable z))		; case:  x * y = z ??
		(not (is-variable x))
		(not (is-variable y)))
	   (= z (* x y)))

	  ((and (is-variable z)			; case:  x * y = ?
		(not (is-variable x))
		(not (is-variable y)))
	   (list (list (list z (* x y)))))

	  (t 'no-match-attempted)))



;;; -------------------------------------------------------------------------
;;;  This function is *only* used to generate bindings for <new-mod>.
;;;  The function contains the following information:
;;;
;;;				      Defender:
;;;			     ARMOR	  AT	    INF
;;;			  +----------+----------+----------+
;;;		ARMOR	  |    -     | 0.5 * A  |   2 * A  |
;;;  Attacker:	INF	  | 0.5 * A  |    -     |    -     |
;;;		COMBINED  |    -     |    -     |   2 * A  |
;;;			  +----------+----------+----------+
;;;
;;;  Notes:  Any defender is considered to contain part infantry.
;;;	     Case "combined" means ARMOR+INF, and is handled by taking
;;;	     the greater value from above.
;;;	     0.5 * A  ==>  Attacker strength halved.
;;;	     2 * A    ==>  Attacker strength doubled.
;;;	     -        ==>  Attacker face value.
;;; -------------------------------------------------------------------------

(defun find-modifier (unit-class objective-class old-mod new-mod)
   (cond ( (and (not (is-variable unit-class)     )
		(not (is-variable objective-class))
		(not (is-variable old-mod)        )
		(is-variable new-mod)		   )

	   (cond ( (and (equal unit-class      'ARMOR)
			(equal objective-class 'ARMOR)
			(<     old-mod       100)     )
		   (list (list (list new-mod 100))) )

		 ( (and (equal unit-class      'INF  )
			(equal objective-class 'ARMOR)
			(<     old-mod        50)     )
		   (list (list (list new-mod  50))) )

		 ( (and (equal unit-class      'ARMOR)
			(equal objective-class 'AT   )
			(<     old-mod        50)     )
		   (list (list (list new-mod  50))) )

		 ( (and (equal unit-class      'INF  )
			(equal objective-class 'AT   )
			(<     old-mod       100)     )
		   (list (list (list new-mod 100))) )

		 ( (and (equal unit-class      'ARMOR)
			(equal objective-class 'INF  )
			(<     old-mod       200)     )
		   (list (list (list new-mod 200))) )

		 ( (and (equal unit-class      'INF  )
			(equal objective-class 'INF  )
			(<     old-mod       100)     )
		   (list (list (list new-mod 100))) )

		 (t (list (list (list new-mod old-mod))) ) ))

	 (t 'no-match-attempted) ))

