


; Operators

(setq *OPERATORS* '(

(GLOAT
  (params (<dater>))
  (preconds (and (human <dater>)
	(human <victim>)
	(nolongerneedsdate <dater>)
	(not-equal <dater> <victim>)
	(hasdatewith <dater> <victim>)))
  (effects ((del (nodate <dater>))
 	   (add (hasdate <dater>)))))

(WATCH-MARX-BROS
  (params (<dater>))
  (preconds (and (human <dater>)
	 (~(exists (<victim>) (human <victim>) (or (near <victim> <dater>)
						(near <dater> <victim>))))))
  (effects (
	(if (~(isfunny <dater>)) (add (isfunny <dater>))))))

(HIT-ON
 (params (<dater> <victim>))
 (preconds (and (human <dater>)
		(human <victim>)
		(oppsex <dater> <victim>)
		(~(sickly <dater>))
		(worthwhile <victim>)
		(near <dater> <victim>)
		(~(exists (<victim2>) (human <victim2>) 
		    (and
			(not-equal <victim> <victim2>)
			(near <dater> <victim2>))))
		(near <dater> <victim>)
	        (likealot <victim> <dater>)))
  (effects ((add (askedfordate <dater> <victim>)))))

(ACCEPT-DATE
  (params (<victim> <dater>))
  (preconds (and (human <dater>)
		 (human <victim>)
		 (alive <victim>)
		 (or
		 (objlike <victim> <dater>)
		 (and
			(object <ob>)
		 	(acceptedfrom <victim> <dater> <ob>)
			(flattered <dater> <victim>)
			(laughedatjoke <victim> <dater>)
			(sharedstory <victim> <dater>)))
		 (unmarried <victim>)
		 (~(sickly <victim>))
		 (askedfordate <dater> <victim>)
		 ))
  (effects ((del (askedfordate <dater> <victim>))
	(add (accepteddate <victim>))
	(add (nolongerneedsdate <dater>))
	(add (hasdatewith <dater> <victim>)))))

(SEND-IT-PACKING
  (params (<victim> <dater>))
  (preconds (and (human <dater>)
		 (human <victim>)
		 (askedfordate <dater> <victim>)
		 (objdislike <victim> <dater>)))
  (effects (
	(add (toldtoshoveoff <dater>))
	(del (likealot <victim> <dater>))
	(del (askedfordate <dater> <victim>)))))

(SYMPATHIZE
  (params (<victim>))
  (preconds (and (human <dater>)
	      (or
		(sickly <dater>)
	 	(toldtoshoveoff <dater>)
		(depressed <dater>))
	    (human <victim>)
	    (nice <victim>)	
	    (eavesdrop <victim> <dater>)))
  (effects (
	    (add (near <dater> <victim>)) 
	    (if (toldtoshoveoff <dater>) 
		(del (toldtoshoveoff <dater>)))
	    (if (sickly <dater>) 
		(del (sickly <dater>)))
	    (if (depressed <dater>) 
		(del (depressed <dater>)))
	    (add (likealot <victim> <dater>)))))

(ACQUIRE 
  (params (<dater> <ob>))
  (preconds (and
		(object <ob>)
		(dispenser <ob>)))
  (effects (
	(add (has <dater> <ob>)))))


(GET-TO-KNOW
  (params (<dater> <victim>))
  (preconds (and 
 		 (oppsex <dater> <victim>)
		 (havetalked <dater> <victim>)))
  (effects ((add (sharedstory <victim> <dater>)))))

(TELL-A-JOKE
  (params (<dater> <victim>))
  (preconds (and 
		(isfunny <dater>)
		(human <victim>)
		(near <dater> <victim>)
		))
  (effects (
	    (add (wait <dater>))
	    (add (joketold <dater>)))))

(LAUGH
  (params (<victim>))
  (preconds (and 
	    (human <dater>)
	    (joketold <dater>)
	    (hasattrib <victim> haveasenseofhumor)	
	    (wait <dater>)
	    (or 
	    (near <dater> <victim>)
	    (eavesdrop <victim> <dater>))))
  (effects (
	    (del (wait <dater>))
	    (add (laughedatjoke <victim> <dater>))
	    (add (likealot <victim> <dater>)))))



(WALKAWAY
  (params (<dater> <victim>))
  (preconds (and
	    (human <dater>)
	    (human <victim>)
	    (near <dater> <victim>)))
  (effects (
	    (add (can-hear <victim> <dater>))
	    (del (near <dater> <victim>)))))
	    


(OFFER
  (params (<dater> <victim> <ob>))
  (preconds
	(and
	(has <dater> <ob>)
	(worthwhile <victim>)
	(or
	(typicalpresent <ob>)
	(hasneed <victim> <ob>))
	(near <dater> <victim>)
	))
 (effects
	((add (proffer <dater> <victim> <ob>)))))


(ACCEPT
  (params (<victim> <ob>))
  (preconds ( and
	(object <ob>)
	(human <victim>)
	(human <dater>)
	(near <dater> <victim>)
	(or 
		(~(expensive <ob>))
		(greedy <victim>))
	(~(allergicto <victim> <ob>))
	(proffer <dater> <victim> <ob>)))
  (effects
  	((add (has <victim> <ob>))
	(if (hasneed <victim> <ob>) (del (lookingfor <victim> <ob>)))
	(del (has <dater> <ob>))
	(add (likealot <victim> <dater>))
	(add (acceptedfrom <victim> <dater> <ob>))
	(if (nopref <victim> <dater>) 
			(del (nopref <victim> <dater>))
			(add (objlike <victim> <dater>)))
	(del (proffer <dater> <victim> <ob>)))))
	


(CONVERSE 
  (params (<dater> <victim>))
  (preconds (and 
		 (oppsex <dater> <victim>)
		 (near <dater> <victim>)))
  (effects ((add (havetalked <dater> <victim>)))))

(OGLE
  (params (<dater> <victim>))
  (preconds  (and 
		(human <victim>)
		(human <dater>)
		(oppsex <dater> <victim>)
		(worthwhile <victim>)
		(or
		     	(near <dater> <victim>)
			(can-see <dater> <victim>))))
  (effects (
	(add (isdrooling <dater> <victim>))
	(add (can-see <victim> <dater>)))))

(PREEN
  (params (<victim> <dater>))
  (preconds  (and 
		(human <victim>)
		(human <dater>)
		(oppsex <dater> <victim>)
		(or
			(vain <victim>)
			(objlike <victim> <dater>))
		(can-see <victim> <dater>)))
  (effects (
	(if (and (objdislike <victim> <dater>) (isdrooling <dater> <victim>)) 
		(del (objdislike <victim> <dater>))
		(add (nopref <victim> <dater>)))
	(add (can-see <dater> <victim>)))))

(COMPLIMENT
  (params (<dater> <victim>))
  (preconds  (and 
		(human <victim>)
		(human <dater>)
		(near <dater> <victim>)))
  (effects (
	(add (flattered <dater> <victim>))
	(if (nopref <victim> <dater>) 
		(del (nopref <victim> <dater>))
		(add (objlike <victim> <dater>)))
	(add (likealot <victim> <dater>)))))
		

(WALKOVERTO 
  (params (<dater> <victim>))
  (preconds (and
		(can-see <dater> <victim>)
		(oppsex <dater> <victim>)))
  (effects (
	    (add (near <dater> <victim>))
	    (add (near <victim> <dater>)))))


(GET-A-DIVORCE
  (params (<victim> <spouse>))
  (preconds (and
		(human <victim>)
		(human <spouse>)
		(married <victim> <spouse>)
		(~(vindictive <victim>))
		(~(vindictive <spouse>))))
  (effects (
	(add (unmarried <victim>))
	(add (unmarried <spouse>))
	(del (married <spouse> <victim>))
	(del (married <victim> <spouse>)))))

(RUN-OVER
  (params (<dater> <victim>))
  (preconds (and
		(human <dater>)
		(unethical <dater>)
		(human <victim>)
		(human <spouse>)
		(married <victim> <spouse>)
		(alive <victim>)
		(hascar <dater>)
		))
  (effects (
		(add (unmarried <victim>))
		(add (unmarried <spouse>))
		(if (and (human <spouse>) (married <victim> <spouse>)) 
			(del (married <victim> <spouse>))) 
		(if (and (human <spouse>) (married <spouse> <victim>)) 
			(del (married <spouse> <victim>)))
	(del (alive <victim>))
	(add (depressed <spouse>))
	(add (dead <victim>)))))
		

(MOURN-DEATH-OF-SPOUSE
  (params (<person>))
  (preconds (and (human <person>)
		 (depressed <person>)))
  (effects (
	(del (depressed <person>)))))

(BECOME-MALE
  (params (<dater>))
  (preconds (and
		(human <dater>)
		(female <dater>)
		(human <victim>)
		(female <victim>)
		(not-equal <dater> <victim>)))
  (effects (
	    (add (changedsex <dater>))
	    (add (male <dater>))
	    (add (sickly <dater>))
	    (del (female <dater>)))))

(PRETEND-TO
  (params (<person> <attrib>))
  (preconds (and (human <person>)
		 (human <person2>)
		 (attribute <attrib>)
		 (desiredattr <person2> <attrib>)))
  (effects (
	(add (hasattrib <person> <attrib>)))))
  

;;; (RECOVER-FROM-OPERATION
;;;   (params (<dater>))
;;;   (preconds (and
;;;		(human <dater>)
;;;		(sickly <dater>)))
;;;  (effects (
;;;	(del (sickly <dater>)))))




(BECOME-FEMALE
  (params (<dater>))
  (preconds (and
		(human <dater>)
		(male <dater>)
		(human <victim>)
		(male <victim>)
		(not-equal <dater> <victim>)))
  (effects (
	    (add (changedsex <dater>))
	    (add (female <dater>))
	    (add (sickly <dater>))
	    (del (male <dater>)))))
 ))

(setq *INFERENCE-RULES* '(


(INFER-OVERHEARD
  (params (<victim> <dater>))
  (preconds (and
	(human <victim>)
	(human <dater>)
	(or
	(near <victim> <dater>)
	(can-hear <victim> <dater>))))
  (effects (
	(add (eavesdrop <victim> <dater>)))))

	

(INFER-NEED
  (params (<victim> <ob>))
  (preconds
    (and
	(human <victim>)
	(obect <ob>)
	(~(has <victim> <ob>))
	(lookingfor <victim> <ob>)))
  (effects
	((add (hasneed <victim> <ob>)))))

(GET-IN-CAR
  (params (<dater>))
  (preconds
    (and
	(human <dater>)
	(hascar <dater>)))
  (effects (
	(add (driving <dater>))))) 


(INFER-GENDER
  (params (<dater> <victim>))
  (preconds
	(or
	(and
		(male <dater>)
		(female <victim>))
	(and
		(female <dater>)
		(male <victim>))))
   (effects ((add (oppsex <dater> <victim>)))))

(INFER-LIKE
  (params (<dater> <victim>))
  (preconds
	(or
	(sharedstory <victim> <dater>)
	(and
     	(havetalked <dater> <victim>)	
	(~(hateoppsex <victim>)))))
  (effects
        ((add (like <victim> <dater>)))))


(SCOPEOUT
  (params (<dater> <victim>))
  (preconds  (and 
	(human <dater>)
     (or
	(and
		(attribute <attr>)
		(desiredattr <dater> <attr>)
		(hasattrib <victim> <attr>))
	(haswhatilike <dater> <victim>))))
  (effects ((add (worthwhile <victim>)))))
	
		       ))


