;;
;; problem - sw4
;;
;; similar to problem 3, except we wish to liberate the area 0 3
;;
(setq *MAXVAL* 4)  ;; Grid size for this problem

(load-goal '(AND (~ (ENEMY BRIDGE 2 3)) 
                 (~ (ENEMY SCUD 0 2)) 
                 (~ (ENEMY SCUD 1 3)) 
                 (~ (ENEMY SCUD 1 4)) 
                 (~ (ENEMY AMMO-STOCKPILE 0 4))
                 (no-enemy-ground-forces-present 0 0)
                 (liberated 0 3)))

(load-start-state
     '(
;;
;; Physical terrain 
;;
;;
;;                  type     x y
;; -------------------------------------
       (terrain     DESERT   2 0)
       (terrain     DESERT   2 1)
       (terrain     DESERT   3 0)
       (terrain     DESERT   3 1)
       (terrain     DESERT   4 0)
       (terrain     DESERT   4 1)
       (terrain     DESERT   4 2)
       (terrain     DESERT   4 3)
       (terrain     DESERT   4 4)
       (terrain     DESERT   0 4)
       (terrain     DESERT   1 4)
       (terrain     DESERT   2 4)

       (terrain     HILLS    0 2)
       (terrain     HILLS    0 3)
       (terrain     HILLS    1 2)
       (terrain     HILLS    3 2)

       (terrain     WATER    0 0)
       (terrain     WATER    0 1)
       (terrain     WATER    1 0)
       (terrain     WATER    1 1)

       (terrain     MOUNTAIN 2 2)
       (terrain     MOUNTAIN 3 2)
       (terrain     MOUNTAIN 3 3)
       (terrain     MOUNTAIN 3 4)

;;
;;
;; Obstacles
;;
       (obstacle 1 2)
       (obstacle 1 3)
       (obstacle 1 4)
       (obstacle 2 4)
       (obstacle 4 2)
       (obstacle 4 3)
       (obstacle 4 4)

;;
;; Enemy target classes
;;
       (heavy-target       BRIDGE)
       (heavy-target       SCUD)
       (heavy-target       AMMO-STOCKPILE)

       (light-target       TROOP)
       (light-target       LEAKY-RAFT)
       
       (aerial-target      AIRCRAFT)

;;
;; Enemy locations
;;
;;                   type           x-pos     y-pos
;;     --------------------------------------------------------
       (enemy       TROOP             0         3)

       (enemy       SCUD              0         2)
       (enemy       SCUD              1         3)
       (enemy       SCUD              1         4)
      
       (enemy       BRIDGE            2         3)

       (enemy       AIRCRAFT          0         1)
       (enemy       AIRCRAFT          2         3)

       (enemy       AMMO-STOCKPILE    0         4)
       (enemy       LEAKY-RAFT        0         0)

;;
;; US FORCES HERE
;;

  (class ARMY) 
  (army-type A0)

  (class AIRFORCE) 
  (air-type AF0) (air-type AF1) (air-type AF2)

  (class MARINES)
  (marine-type M0)   (marine-type M1)

  (removes-light-targets M0)
  (removes-light-targets AF2)
  (removes-heavy-targets AF1)
  (removes-aerial-targets AF1)

  (may-establish-US-presence DIVISION)

  (can-remove-barricade MINE-UNIT)

;;
;;              class         ITEM        id 
;;---------------------------------------------------------------
     (register  AIRFORCE      AWACS       AF0)
     (register  AIRFORCE      F-16        AF1)
     (register  AIRFORCE      B-52        AF2)

     (register  ARMY          MINE-UNIT   A0)

     (register  MARINES       DIVISION    M0)
     (register  MARINES       DIVISION    M1)

;;
;; Starting locations of US assets - these will change as needed
;;
;;               id     x-pos  y-pos
;; -----------------------------------------------
     (location   AF0     4      0)
     (location   AF1     4      0)
     (location   AF2     4      0)
     (location   A0      3      0)
     (location   M0      4      1)
     (location   M1      4      1)

;;
;; Original locations of US assets - these change when a piece of US equipment
;;                                   destroys a target
;;
;;                id    x y
;; ----------------------------
  (start-location AF0   4 0)
  (start-location AF1   4 0)
  (start-location AF2   4 0)
  (start-location A0    3 0)
  (start-location M0    4 1)
  (start-location M1    4 1)
))




