(setq *MAXVAL* 3)  ;; Grid size for this problem

(load-goal '(and (liberated 2 0)
                 (US-forces-present 3 0)))

(load-start-state
     '(
;;
;;  uses a 4x4 grid for this problem
;;

;;
;; Physical terrain 
;;
;;
;;                  type          x y
;;--------------------------------------------
       (terrain     WATER         3 0)
       (terrain     WATER         3 1)
       (terrain     WATER         3 2)
       (terrain     WATER         3 3)

       (terrain     DESERT        0 0)
       (terrain     DESERT        1 0)
       (terrain     DESERT        2 0)
       (terrain     DESERT        0 3)
       (terrain     DESERT        1 3)
       (terrain     DESERT        2 3)
   
       (terrain     HILLS         0 1)
       (terrain     HILLS         0 2)
       (terrain     HILLS         1 1)
       (terrain     HILLS         1 2)
       (terrain     HILLS         2 1)
       (terrain     HILLS         2 2)

;;
;;
;; Obstacles
;;
;;          x y
;;--------------
  (obstacle 0 1)
  (obstacle 1 1)
  (obstacle 2 1)
  (obstacle 3 0)
  (obstacle 3 1)

;;
;; Enemy target classes
;;
       (heavy-target       TANK)
       (heavy-target       BRIDGE)
       (heavy-target       SCUD)

       (light-target       TROOP)

       (aerial-target      AIRCRAFT)
;;
;; Enemy locations
;;
;;                   type           x-pos     y-pos
;;     --------------------------------------------------------
       (enemy       TROOP             0         0)
       (enemy       SADAAMS-HOUSE     0         0)
       (enemy       AIRCRAFT          1         0)
       (enemy       TANK              2         0)
       (enemy       SCUD              2         1)
       (enemy       BRIDGE            0         1)
;;
;; US FORCES HERE
;;
  (class ARMY) 
  (army-type A0) (army-type A1) (army-type A2) 

  (class NAVY) 
  (navy-type N0) (navy-type N1) (navy-type N2) 

  (class AIRFORCE) 
  (air-type AF0) (air-type AF1) (air-type AF2) (air-type AF3) 

  (class MARINES)
  (marine-type M0)

  (removes-light-targets AF2)
  (removes-light-targets A0)
  (removes-light-targets M0)
  (removes-heavy-targets AF1)
  (removes-heavy-targets AF3)
  (removes-heavy-targets A2)
  (removes-aerial-targets AF1)
  (removes-aerial-targets AF3)

  (may-establish-US-presence CRUISER)      
  (may-establish-US-presence BATTLESHIP)  
  (may-establish-US-presence PLATOON)   
  (may-establish-US-presence DIVISION)  

  (can-remove-barricade MINESWEEPER)
  (can-remove-barricade MINE-UNIT)

;;
;;              class         ITEM        id 
;;---------------------------------------------------------------
     (register  AIRFORCE      AWACS       AF0)
     (register  AIRFORCE      F-16        AF1)
     (register  AIRFORCE      B-52        AF2)
     (register  AIRFORCE      F-14        AF3)

     (register  ARMY          PLATOON     A0)
     (register  ARMY          MINE-UNIT   A1)
     (register  ARMY          TANK        A2)

     (register  MARINES       DIVISION    M0)

     (register  NAVY          CRUISER     N0)
     (register  NAVY          MINESWEEPER N1)
     (register  NAVY          BATTLESHIP  N2)

;;
;; Starting locations of US assets - these will change as needed
;;
;;               id     x-pos  y-pos
;; -----------------------------------------------
     (location   AF0     0      3)
     (location   AF1     0      3)
     (location   AF2     0      3)
     (location   AF3     0      3)
     (location   A0      1      3)
     (location   A1      1      3)
     (location   A2      1      3)
     (location   M0      2      3)
     (location   N0      3      3)
     (location   N1      3      3)
     (location   N2      3      3)

;;
;; Original locations of US assets - these change only when a target is
;;                                   destroyed by the equipment
;;
;;                id    x y
;; ----------------------------
  (start-location AF0   0 3)
  (start-location AF1   0 3)
  (start-location AF2   0 3)
  (start-location AF3   0 3)
  (start-location A0    1 3)
  (start-location A1    1 3)
  (start-location A2    1 3)
  (start-location M0    2 3)
  (start-location N0    3 3)
  (start-location N1    3 3)
  (start-location N2    3 3)
))



