(setq *MAXVAL* 3)  ;; Grid size for this problem

(load-goal '(liberated 0 0))

(load-start-state
     '(
;;
;;  uses a 4x4 grid for this problem
;;

;;
;; Physical terrain 
;;
;;
;;                  type          x y
;;--------------------------------------------
       (terrain     DESERT         1 0)
       (terrain     DESERT         2 0)
       (terrain     DESERT         3 0)
       (terrain     DESERT         0 1)
       (terrain     DESERT         1 1)
       (terrain     DESERT         2 1)
       (terrain     DESERT         3 1)
       (terrain     DESERT         0 2)
       (terrain     DESERT         1 2)
       (terrain     DESERT         2 2)
       (terrain     DESERT         3 2)
       (terrain     DESERT         0 3)
       (terrain     DESERT         1 3)
       (terrain     DESERT         2 3)
       (terrain     DESERT        0 0)
       (terrain     DESERT        3 3)

;;
;;
;; Obstacles
;;
;;          x y
;;--------------
  (obstacle 0 1)
  (obstacle 1 1)
  (obstacle 1 0)

;;
;; Enemy target classes
;;
       (heavy-target       TANK)

       (light-target       TROOP)

       (aerial-target      AIRCRAFT)
;;
;; Enemy locations
;;
;;                   type           x-pos     y-pos
;;     --------------------------------------------------------
       (enemy       AIRCRAFT          0         0)
       (enemy       TANK              0         0)
       (enemy       TROOP             0         0)
;;
;; US FORCES HERE
;;
  (class AIRFORCE) 
  (air-type AF0) (air-type AF1)

  (class ARMY)
  (army-type A0) (army-type A1)

  (removes-light-targets A0)
  (removes-heavy-targets AF0)
  (removes-aerial-targets AF0)

  (may-establish-US-presence PLATOON)

  (can-remove-barricade MINE-UNIT)


;;
;;              class         ITEM        id 
;;---------------------------------------------------------------
     (register  AIRFORCE      F-16       AF0)
     (register  AIRFORCE      AWACS      AF1)

     (register  ARMY          PLATOON     A0)
     (register  ARMY          MINE-UNIT   A1)

;;
;; Starting locations of US assets - these will change as needed
;;
;;               id     x-pos  y-pos
;; -----------------------------------------------
     (location   AF0     3      3)
     (location   AF1     3      3)
     (location   A0      3      3)
     (location   A1      3      3)

;;
;; Original locations of US assets - these change only when a target is
;;                                   destroyed by the equipment
;;
;;                id    x y
;; ----------------------------
  (start-location AF0   3 3)
  (start-location AF1   3 3)
  (start-location A0    3 3)
  (start-location A1    3 3)
))



