(eval-when (load compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map"))

(defun within (x y  x1 y1 x2 y2)
;;
;; returns TRUE if (x y) is within the area (x1 y1) - (x2 y2)
;;
  (cond
   ((OR (is-variable x) (is-variable y) (is-variable x1) (is-variable y1)
        (is-variable x2) (is-variable y2))
      'no-match-attempted)
   (t (AND (AND (>= x x1) (<= x x2))
           (AND (>= y y1) (<= y y2))))))

(defun is-next-to (x1 y1 x2 y2 gx gy)
;;
;; returns true if (x1,y1) is within one square of (x2,y2)
;;
;; generates values for (x1 y1) giving preference to the squares closest 
;; to (gx gy) if no values for (x1 y1) are given
;;
  (cond
    ((and (is-variable x2) (is-variable y2) (is-variable x1) (is-variable y1))
       'no-match-attempted)
    ((and (is-variable x2) (is-variable y2))
       'no-match-attempted)
    ((and (is-variable x1) (is-variable y1))
       (direct-routes-first (mult-binding-list
                              (list x1 y1)
                              (list (generate-values x2)
                                    (generate-values y2)))
                            gx gy))
    (t (within x1 y1 (- x2 1) (- y2 1) (+ x2 1) (+ y2 1)))))

(defun direct-routes-first (xylist gx gy)
;;
;; sorts xylist, moving squares that are closest to (gx, gy) to the
;; head of the list
;;
;; 0: Outer mapcar strips out modifications made at 2:
   (mapcar #'(lambda (element0)
                 (first (rest element0)))

;; 1: Sorts bindings, giving preference to closest square
            (sort 

;; 2: This mapcar examines the binding list, and creates a new list
;;    that is preceeded by a priority number which is the distance from
;;    (gx gy) to the generated (x y).

                   (mapcar #'(lambda (element1)
;;
;; Ooohhhh look!  The distance formula!  And who would have thought that
;; I would ever be using calculus again!
;;
              (list (sqrt (+ (expt (- gx (second (first element1))) 2)
                             (expt (- gy (second (second element1))) 2)))
                    element1))
                           xylist)

;;
;; Move the bindings of highest priority to the end of the list, because
;; Prodigy starts from the end of the list...
;;
                   #'(lambda (x y)                   ;; this defines how to
                       (> (first x) (first y))))))   ;; sort the list

(defun same-type (x y)
;;
;; returns true if x and y are EQUAL
;;
  (EQUAL x y))

(defun generate-values (value)
;;
;; generates a list composed of legal values that are one square away
;; from value
;;
  (cond 
    ((zerop value)       (list value (+ value 1)))
    ((= value *MAXVAL*)  (list value (- value 1)))
    (t (list value (+ value 1) (- value 1)))))

(defun mult-binding-list (vars val-lists)
;;
;; From Schedworld
;;
   (and vars
        (g-loop (init ret-val nil vals (car val-lists) var (car vars)
                    rst-bindings (mult-binding-list (cdr vars)
                                     (cdr val-lists)))
              (while vals)
              (do (cond (rst-bindings
                            (setq ret-val
                                  (append 
                                         (g-map (b in rst-bindings)
                                              (save (cons (list var
                                                                (car vals)) b)))
                                         ret-val)))
                        (t (push (list (list var (car vals))) ret-val))))
                        (next vals (cdr vals))
                        (result ret-val))))


