;; 
;; SCUDworld
;;
;; Ken McCaw (8923426)
;;

;; Operators

(setq *OPERATORS* 
  '(

 (LIBERATE-LOCATION
;;
;;  Due to the 2-dimensional nature of my domain, and the actual
;; use of coordinates by the military, I found it both necessary and
;; useful to use non-static generators in many places. 
    (params (<x-pos> <y-pos>))
    (preconds 
     (and
       (no-enemy-air-activity <x-pos> <y-pos>)
       (no-enemy-ground-forces-present <x-pos> <y-pos>)
       (US-forces-present <x-pos> <y-pos>)))
    (effects (
       (add (liberated <x-pos> <y-pos>)))))
 
 (DECREASE-ENEMY-AIR-TRAFFIC
    (params (<e-type> <x-pos> <y-pos>))
    (preconds 
       (and
         (aerial-target <e-type>)
         (class <us-class>)
         (enemy <e-type> <x-pos> <y-pos>)
         ;; which of our equipment removes enemy aircraft
         (removes-aerial-targets <id>)

         ;; get an id # for that equipment and bring it into position
         (location <id> <x-pos> <y-pos>)))
    (effects (
       (del (enemy <e-type> <x-pos> <y-pos>)))))
 
  (DECREASE-LIGHT-GROUND-TARGETS
    (params (<e-type> <x-pos> <y-pos>))
    (preconds
       (and
           (class <us-class>)
           (light-target <e-type>)
           ;; is there any US equipment in position to destroy target?
           (EXISTS (<id>) (removes-light-targets <id>)
                      (location  <id> <x-pos> <y-pos>))
           (start-location <id> <sx> <sy>)))
    (effects (
        (del (start-location <id> <sx> <sy>))
        (add (start-location <id> <x-pos> <y-pos>))
        (del (enemy <e-type> <x-pos> <y-pos>)))))

  (DECREASE-HEAVY-GROUND-TARGETS
    (params (<e-type> <x-pos> <y-pos>))
    (preconds
       (and
           (class <us-class>)
           (heavy-target <e-type>)
           ;; any US equipment in position to destroy a heavy target?
           (EXISTS (<id>) (removes-heavy-targets <id>)                      
                 (location <id> <x-pos> <y-pos>))
           (start-location <id> <sx> <sy>)))
    (effects (
        (del (start-location <id> <sx> <sy>))
        (add (start-location <id> <x-pos> <y-pos>))
        (del (enemy <e-type> <x-pos> <y-pos>)))))

 (MOVE-ARMY
    (params (<us-type> <id> <x-pos> <y-pos>))
    (preconds
      (and
;; NOTE:  
;;
;;  In movement phases, we need to generate a next position, which due to
;; Prodigy's use of backtracking, is actually trying to move the equipment
;; to where it was originally located.  Thus, knowing the starting positions
;; for all of our equipment is useful in generating a next move.
;;
          ;; type of equipment we are planning to move
          (army-type  <id>)

          ;; check legal terrain
          (or (terrain DESERT <x-pos> <y-pos>)
              (terrain HILLS <x-pos> <y-pos>))

          ;; get the goal location, which is start location due to backtracking
          (start-location <id> <start-x> <start-y>)

          ;; generate all possible next moves, giving binding preference
          ;; to the position closest to the original location
          (is-next-to <from-x> <from-y> <x-pos> <y-pos> <start-x> <start-y>)

          ;; Need to be sure there was actually ARMY equipment at the old
          ;; position
          (location <id> <from-x> <from-y>)

          ;; get equipment type
          (register ARMY <us-type> <id>)

          ;; Don't move into barricaded area unless you can remove them
          (or (can-remove-barricade <us-type>)
	      (~ (obstacle <x-pos> <y-pos>)))

          ;; if any heavy targets, don't enter the area unless 
          ;; you can destroy it
          (OR (removes-heavy-targets <id>)
              (FORALL (<e-type>) (heavy-target <e-type>)
                    (~ (enemy <e-type> <x-pos> <y-pos>))))))
    (effects (
        (if (US-forces-present <from-x> <from-y>)
            (del (US-forces-present <from-x> <from-y>)))
        (del (location <id> <from-x> <from-y>))
        (add (location <id> <x-pos> <y-pos>)))))

(MOVE-NAVY
;;
;; see MOVE-ARMY for helpful comments
;;
    (params (<id> <x-pos> <y-pos>))
    (preconds
      (and
          (navy-type  <id>)
          ;; check legal terrain
          (terrain WATER <x-pos> <y-pos>)
          (start-location <id> <start-x> <start-y>)
          (is-next-to <from-x> <from-y> <x-pos> <y-pos> <start-x> <start-y>)
          (location <id> <from-x> <from-y>)
          (register NAVY <us-type> <id>)
          (or (can-remove-barricade <us-type>)
	      (~ (obstacle <x-pos> <y-pos>)))
          (or (removes-heavy-targets <id>)
              (FORALL (<e-type>) (heavy-target <e-type>)
                    (~ (enemy <e-type> <x-pos> <y-pos>))))))
      (effects (
         (if (US-forces-present <from-x> <from-y>)
             (del (US-forces-present <from-x> <from-y>)))
         (del (location <id> <from-x> <from-y>))
         (add (location <id> <x-pos> <y-pos>)))))
  
(MOVE-MARINES
;;
;; see MOVE-ARMY for helpful comments
;;
    (params (<id> <x-pos> <y-pos>))
    (preconds 
      (and
          (marine-type  <id>)
          ;; check legal terrain
          (or (terrain DESERT <x-pos> <y-pos>)
              (terrain HILLS <x-pos> <y-pos>))
          (start-location <id> <start-x> <start-y>)
          (is-next-to <from-x> <from-y> <x-pos> <y-pos> <start-x> <start-y>)
          (location <id> <from-x> <from-y>)
          (register MARINES <us-type> <id>)
          (or (can-remove-barricade <us-type>)
	      (~ (obstacle <x-pos> <y-pos>)))
          (or (removes-heavy-targets <id>)
              (FORALL (<e-type>) (heavy-target <e-type>)
                    (~ (enemy <e-type> <x-pos> <y-pos>))))))
    (effects (
      (if (US-forces-present <from-x> <from-y>)
          (del (US-forces-present <from-x> <from-y>)))
      (del (location <id> <from-x> <from-y>))
      (add (location <id> <x-pos> <y-pos>)))))
 
  (MOVE-AWACS
     (params (<id> <x-pos> <y-pos>))
     (preconds
       (AND
          (air-type <id>)
          (register AIRFORCE AWACS <id>)
          ;; check legal terrain
          (~ (terrain MOUNTAIN <x-pos> <y-pos>))
          (start-location <id> <start-x> <start-y>)
          (is-next-to <from-x> <from-y> <x-pos> <y-pos> <start-x> <start-y>)
          (location <id> <from-x> <from-y>)

          ;; AWACS will not move into enemy airspace
          (no-enemy-air-activity <from-x> <from-y>)))

     (effects (
          (add (location <id> <x-pos> <y-pos>))
          (del (location <id> <from-x> <from-y>)))))

  (MOVE-AIRPLANE
     (params (<id> <x-pos> <y-pos>))
     (preconds 
        (and
            (air-type <id>)
            (~ (same-type <us-type> AWACS))
            (~ (terrain MOUNTAIN <x-pos> <y-pos>))
            (register AIRFORCE <us-type> <id>)
            (start-location <id> <start-x> <start-y>)
            (is-next-to <from-x> <from-y> <x-pos> <y-pos> <start-x> <start-y>)
            (location <id> <from-x> <from-y>)))
     (effects (
          (add (location <id> <x-pos> <y-pos>))
          (del (location <id> <from-x> <from-y>)))))
 
  (REMOVE-BARRICADE
    (params (<x-pos> <y-pos>))
    (preconds
      (and
          (class <us-class>)
          (obstacle <x-pos> <y-pos>)
          (EXISTS (<us-type>) (can-remove-barricade <us-type>)
                   (and (register <us-class> <us-type> <id>)
                        (location <id> <x-pos> <y-pos>)))))
    (effects (
        (del (obstacle <x-pos> <y-pos>)))))

  (AWACS-FINDS-NO-ENEMY-AIR-ACTIVITY 
      (params (<x-pos> <y-pos>))
      (preconds
        (AND
             (register AIRFORCE AWACS <id>)
             (location <id> <x-pos> <y-pos>)
             (start-location <id> <sx> <sy>)
             (~ (EXISTS (<e-type>) (aerial-target <e-type>)
                 (AND (enemy <e-type> <x1> <y1>)
                      (is-next-to <x-pos> <y-pos> <x1> <y1> nil nil))))))
      (effects (
        (del (start-location <id> <sx> <sy>))
        (add (start-location <id> <x-pos> <y-pos>))
        (add (no-enemy-air-activity <x-pos> <y-pos>)))))

))

(setq *INFERENCE-RULES* 
;;
;; Inference rules only past this point
;; 
'(

  (INFER-NO-ENEMY-GROUND-FORCES-PRESENT
      (params (<x-pos> <y-pos>))
      (preconds
             (and (~ (EXISTS (<e-type>) (heavy-target <e-type>)
                   (enemy <e-type> <x-pos> <y-pos>)))
                  (~ (EXISTS (<type>) (light-target <e-type>)
                   (enemy <e-type> <x-pos> <y-pos>)))))
      (effects (
        (add (no-enemy-ground-forces-present <x-pos> <y-pos>)))))

  (INFER-US-FORCES-PRESENT
      (params (<x-pos> <y-pos>))
      (preconds
        (and
           (class <us-class>)
           (EXISTS (<us-type>) (may-establish-US-presence <us-type>)
                     (and (register <us-class> <us-type> <id>)
                          (location <id> <x-pos> <y-pos>)))))
      (effects (
         (add (US-forces-present <x-pos> <y-pos>)))))

  ))
