;; ********************************************************
;; This domain does a fairly good job at causing Prodigy to
;; select the correct operators by the orderings of the preconds.
;; However a few Search control rules due help quite a bit.
;; For example one problem went from 1455 nodes to 54 nodes
;; when sc rules were used!
;; Version 1 May 29, 1991
;; ********************************************************

(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
;; Prodigy's default rule
      '((SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))
       ))

(setq *SCR-OP-SELECT-RULES*  '(
;; Select operator unlock if the door is locked
;; If rob is trying to enter a room and the door
;; is locked, then go straight to the unlock operator
        (SELECT-UNLOCK-FOR-LOCKED-DOOR
	 (lhs (and (current-node <node>)
		   (current-op <node> ROBOT-ENTER-ROOM)
		   (current-goal <node> (in-room rob <roomx>))
		   (known <node> (in-room rob <roomy>))
		   (known <node> (or (connect <door> <roomx> <roomy>)
				     (connect <door> <roomy> <roomx>)))
                   (known <node> (status <door> locked))))
	 (rhs (select op UNLOCK-DOOR)))
	
	))


(setq *SCR-BINDINGS-SELECT-RULES* '(
;; This rule ensures that the correct door and room are selected
;; if the goal is to be in a room then bindings for room and
;; door are selected for that purpose
;; partially borrowed from Extended-strips

      (SELECT-CORRECT-ROOM
	 (lhs (and (current-node <node>)
		   (current-op <node> ROBOT-ENTER-ROOM)
		   (current-goal <node> (in-room rob <roomx>))
		   (known <node> (in-room rob <roomy>))
		   (known <node> (or (connect <door> <roomx> <roomy>)
				     (connect <door> <roomy> <roomx>)))))
	 (rhs (select bindings ( <door> <roomy> <roomx>))))
	
	))

(setq *SCR-NODE-REJECT-RULES* '(
;; This keeps Prodigy from trying to go into a room that it is already in
;; Its pretty stupid to try to get into a room that you are in!
        (DONT-ENTER-ROOM-YOU-ARE-ALREADY-IN
          (lhs (and  (primary-candidate-node <node>)
                     (known <node> (in-room rob <x>))
                     (candidate-goal <node> (in-room rob <x>))))
          (rhs  (reject node <node>)))
))
(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* '(
;; Keep Prodigy from subgoaling on a goal that is in the state
;; but not explicitly checked for in preconds.

         (DONT-ENTER-ROOM-ALREADY-VISITED
 	   (lhs (and (current-node <node>)
		   (current-goal <node> (visited <room>))
		   (known <node> (visited <room>))
		   (candidate-op <node> ROBOT-ENTER-ROOM)))
	 (rhs (reject op ROBOT-ENTER-ROOM)))))

(setq *SCR-BINDINGS-REJECT-RULES* '(

;; IDEA  TAKEN from multirobot domain
;;This rule avoids that the robot attempts to go to a room that he has already
;;visited, i.e. is in the stack goal, when trying to find a path from one room
;;to other one.

      (REJECT-GOING-BACK-TO-SAME-ROOM
	 (lhs (and (current-node <node>)
		   (current-goal <node> (in-room <robot> <roomy>))
		   (current-op <node> robot-enter-room)
	           (candidate-bindings <node> ( <door> <roomx> <roomy>))
		   (on-goal-stack <node> (in-room <robot> <roomx>))))
	 (rhs (reject bindings ( <door> <roomx> <roomy>))))


))
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*  nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)




