;***************************  HOTEL  WORLD  ***********************
;                       Robotic  Room  Cleanning
;
;********************
; OPERATORS
;********************

(setq *OPERATORS* '(


(clean-room
 (params  (<rm>))
 (preconds
         (and
	    (is-type <rm> room)
	    (in-room rob <rm>)
	    (drapes-pulled <rm>)
	    (lamp-on <rm>)
	    (pillow-fluffed <rm>)
	  ))
 (effects ((add (cleaned <rm>))
              )))




(move-robot-near-to
  (params	(<obj> <rm>))
  (preconds
	(and
		(or
		   (is-type <obj> object)
		   (is-type <obj> door))
		(is-type <rm> room)
		(current-room <rm>)
		(in-room <obj> <rm>)
		(in-room rob <rm>)	;NOT needed since rob is in 
		))				;current-room by definition

  (effects	((del (near-to rob <*>))	;remove all objs near-to rel
		(add (near-to rob <obj>))
		)))





(robot-enter-room
  (params	( <aDoor> <rm1> <rm2>))
  (preconds
	(and
		(is-type <aDoor> door)
                (is-type <rm1> room)
                (is-type <rm2> room)
                (in-room rob <rm1>)
		(or (connects <aDoor> <rm1> <rm2>)
                    (connects <aDoor> <rm2> <rm1>))
		(status <aDoor> open)
		))
  (effects	((del (current-room <rm1>))
                (del (in-room rob <rm1>))
		(add (current-room <rm2>))
		(add (in-room rob <rm2>))
                (add (visited <rm2>))
                )))


(pick-up
 (params (<ob1>))
 (preconds (and (is-type <ob1> object)
		(near-to rob <ob1>)
 		(arm-empty)))
 (effects ((add (holding <ob1>)))))
           


(put-down                   
  (params	(<obj>))
  (preconds
		(holding <obj>)
		)
  (effects	((del (holding <obj>))
		)))



(open-door
  (params	(<door>))
  (preconds
	(and
		(arm-empty)
		(is-type <door> door)
		(status <door> closed)
		(near-to rob <door>)
		(status <door> unlocked)
		))
  (effects	((del (status <door> closed))
		(add (status <door> open))
		)))







(unlock-door
  (params	(<door>))
  (preconds
	(and
		(is-type <door> door)
		(near-to rob <door>)
		(knocked <door>)
		(shouted-message <door>)
		(holding key)
		))
  (effects	((del (status <door> locked))
		(add (status <door> unlocked))
		)))



(knock-on-door
  (params	(<door>))
  (preconds
	(and
		(is-type <door> door)
		(arm-empty)
		(near-to rob <door>)
		))
  (effects	((add (knocked <door>))
		)))



(shout-house-cleanning
  (params	(<door>))
  (preconds
	(and
		(is-type <door> door)
		(near-to rob <door>)
		))
  (effects	((add (shouted-message <door>))
		)))
))

;**********************************
;INFERENCE  RULES
;**********************************

(setq *INFERENCE-RULES* '(

(infer-arm-empty
  (params nil)
  (preconds
	(~ (exists (<obj>) (holding <obj>))))
  (effects ((add (arm-empty)))))
))
