;***************************************************************
;*                                                             *
;*                       FishWorld                             *
;*                                                             *
;***************************************************************
;*  Andrew Biddle        *
;*  CSE473               *
;*                       *
;*  Project - Part 2     *
;*  May 19, 1991         *
;*************************


;******** OPERATORS **********
;NOTE:
;       I was having some trouble using some of these as inference rules
;       so I made many of them operators even though all they do is add
;       to the current state.

(setq *OPERATORS* '(                    


;** COMPLETE_SETUP **
;     This is basically the top level node.  The variable size, type, and place determine
;     the setup trying to be constructed.  
(COMPLETE_SETUP
	(params (<size> <type> <place>))
	(preconds
		(and 	(Tank_Size <size>)
			(Tank_Type <type>)
			(Location <place>)
                        (Selected <type>)                 ; Force it to check tank_type requirements.
			(Empty_Setup <size> <place>)      ; Place the tank at a location.
			(Stocked <type>)))                ; Add the "stuff".
	(effects (
		(add 	(Complete_Setup <size> <type> <place>)))))



;** PLACE_TANK **
;     Decides on what size tank and where to install it.
;     The size and place variable nicely match up with those for COMPLETE_SETUP.
(PLACE_TANK
	(params (<size> <place>))
	(preconds
		(and	(Tank_Size <size>)
			(Location <place>)
		        (Wants_Placed <place>)           ; This must be the place we WANT the tank placed.
			(Has_Tank <size>)))              ; Force us to choose on the size.
	(effects (
		(del    (Wants_Placed <place>))
		(del    (Has_Tank <Size>))
		(add	(Empty_Setup <size> <place>))
		(add	(Is_Ready)))))                   ; The Empty_Setup Is_Ready for the equipment.


;** CHOOSE_TANK **
;     Actually say : "This is the Tank I'll use"
(CHOOSE_TANK
	(params (<size>))
	(preconds
		(and	(Tank_Size <size>)
		        (Wants_Size <size>)))            ; Make sure this is the size we wish.
	(effects (
		(add	(Has_Tank <size>))
		(del 	(Wants_Size <size>)))))          ;                or WANT it.




;** STOCK_TANK **
;     Top level node for the adding of equipment to a tank.
(STOCK_TANK
	(params (<type>))
	(preconds
	 (and	(Tank_Type <type>)
		(Selected <type>)                        ; Make sure we have the correct requirements.
		(Is_Ready)                               ;    and the tank is placed.

                                                         ; Eliminate all NEEDS.
		(~(EXISTS (<req>) (Required <req>) (Need <req>)))

	                                                 ; Eliminate all WANTS.
		(~(EXISTS (<fish1>) (Aggressive <fish1>) (Wants_Fish <fish1>)))
		(~(EXISTS (<fish2>) (Community <fish2>) (Wants_Fish <fish2>)))
		(~(EXISTS (<fish3>) (GoldFish <fish3>) (Wants_Fish <fish3>)))
		(~(EXISTS (<plant1>) (Floating <plant1>) (Wants_Plant <plant1>)))
		(~(EXISTS (<plant2>) (Rooted <plant2>) (Wants_Plant <plant2>)))
                (~(EXISTS (<type>) (Filter <type>) (Wants_Filter <type>)))
	        (~(EXISTS (<color>) (Gravel <color>) (Wants_Gravel <color>)))
	        (~(EXISTS (<place>) (Location <place>) (Wants_Placed <place>)))))
	(effects (
		(add 	(Stocked <type>)))))             ; Done adding stuff.




;** ADD_FISH **
;     Add a fish to the tank.
;     It is possible to have many fish in one tank.
(ADD_FISH
	(params (<fish>))
	(preconds
		(and	(or	(Aggressive <fish>)      ; Check to see that it is a fish.
				(Community <fish>)
				(GoldFish <fish>))
		        (Is_Ready)
			(Wants_Fish <fish>)
			(Safe_To_Add <fish>)))           ; Make sure we CAN add it safely.
	(effects (
		(del 	(Wants_Fish <fish>))             ; No longer want it.
		(add 	(Swimming <fish>)))))



;** ADD_PLANT **
;     Add a plant to the tank.
;     It is possible to have many plants in a tank.
(ADD_PLANT
	(params (<plant>))
	(preconds
		(and	(or	(Rooted <plant>)         ; Verify it is a plant.
				(Floating <plant>))
		        (Is_Ready)
			(Wants_Plant <plant>)
			(Safe_To_Add <plant>)))
	(effects (
		(del 	(Wants_Plant <plant>))
		(add 	(Planted <plant>)))))            ; Drop it in.



;** ADD_FILTER **
;     Add some sort of filter to keep large particles from floating around.
;         Sponge filters and Undergravel filters use an air pump to suck the
;               waste out of the way.
;         Box filters are self contained and just plug in.
;     Only one filter per tank.
(ADD_FILTER
	(params (<type>))
	(preconds
		(and	(Filter <type>)
			(Is_Ready)
			(Wants_Filter <type>)             ; Make certain this is the type we want.
			(Connected <type> Wall_Outlet)    ; Connect it to the wall.

                                                          ; Undergravel MUST be installed before gravel.
			(or	(~(EQUIV <type> UnderGravel_Filter))
				(~(EXISTS (<color>) (Gravel <color>) (Has_Gravel <color>))))))
	(effects (
		(del 	(Wants_Filter <type>))
		(add	(Has_Filter <type>)))))



;** ADD_GRAVEL **
;     Put some gravel down on the bottom of the tank.
;     Mostly a decoration, but I made it a requirement for all types of setups since
;          only breeding tanks commonly don't have gravel.
;     Multiple colors of gravel are allowed.
(ADD_GRAVEL
	(params (<color>))
	(preconds
		(and	(Gravel <color>)
			(Wants_Gravel <color>)
			(Is_Ready)))
	(effects (
		(del	(Wants_Gravel <color>))
		(add	(Has_Gravel <color>)))))



;** ADD_HEATER **
;     Very unspecific with regards to heaters.  Most heaters cover a range of tank sizes,
;           but for simplicity, I just decided it was one size fits all.
;                       ex.  200watts covers  30 gallons - 80 gallons.
;     Also only one heater per tank.
(ADD_HEATER
	(params nil)
	(preconds
		(and	(Has_Water)                       ; Note:  a heater must not be added to a tank
		                                          ;        that does not have water. It will break.
			(Connected Heater Wall_Outlet)))
	(effects (
		(add    (Has_Heater))
		(if (Need Heater) (del (Need Heater))))))



;** ADD_LIGHT **
;     Most tanks have an indepenant light source.  They always come with the tank, so
;              I chose to disregard size here also.
;     One Light per tank also.
(ADD_LIGHT
	(params nil)
	(preconds
		(and	(Is_Ready)
			(Connected Light Wall_Outlet)))
	(effects (
		(add    (Has_Light))  
		(if (Need Light)  (del 	(Need Light))))))



;** ADD_THERMOMETER **
;      Add a thermometer.
(ADD_THERMOMETER
	(params nil)
	(preconds
		(Is_Ready))
	(effects (
		(add    (Has_Thermometer))  
		(if (Need Thermometer)  (del (Need Thermometer))))))



;** CONNECT **
;    This will directly connect two items. (ex. Light to Power_Strip)
(CONNECT
	(params (<item1> <item2>))
	(preconds
		(Connectable <item1> <item2>))
	(effects (
		(add	(Connected <item1> <item2>)))))



;** FILL **
;     Put water into the tank.  This is a pre-requisite for many other operators.
(FILL
	(params nil)
	(preconds
		(and	(Is_Ready)                      ; Must be placed first.
			(~(Has_Water))))
	(effects (
		(add	(Has_Water)))))



;** SELECT_GRAVEL **
;     If the problem does not specify the color of gravel, but requires gravel, this
;            will 'randomly' choose a color.  It does not add it, it just chooses the 
;            color.
;     If unspecified, one color is the default.
(SELECT_GRAVEL
        (params (<color>))
	(preconds
	 (Gravel <color>))
	(effects (
		(if (Need Gravel) (del (Need Gravel)))  
		(add 	(Wants_Gravel <color>)))))


;** SELECT_FILTER **
;     If the problem does not specify the type of filterbut requires one, this will choose one.
(SELECT_FILTER
        (params (<type>))
	(preconds
	 (Filter <type>))
	(effects (
		(if (Need Filter) (del (Need Filter)))
		(add	(Wants_Filter <type>)))))



;** SELECT_FISH **
;     If the problem requires fish but does not specify which kind, this will choose one.
(SELECT_FISH
        (params (<fish>))
	(preconds
	 (or	(Aggressive <fish>)                 ; One of three types of fish.
	        (Community <fish>)
	        (GoldFish <fish>)))
	(effects (
		(if (Need Fish) (del (Need Fish)))   
		(add	(Wants_Fish <fish>)))))



;** SELECT_PLANT **
;     If the problem requires plants, but does not say which type, this will choose.
(SELECT_PLANT
        (params (<plant>))
	(preconds
	 (or	(Floating <plant>)
	        (Rooted <plant>)))
	(effects (
		(if (Need Plant) (del (Need Plant)))  
		(add	(Wants_Plant <plant>)))))


;** SELECT_TANK_TYPE **
;     If the problem does not specify the type of tank, this will choose one.
(SELECT_TANK_TYPE
        (params (<type>))
	(preconds
	 (and (Tank_Type <type>)
	      (~(EXISTS (<obj>) (Tank_Type <obj>) (Selected <obj>)))))
	(effects (
		(add	(Wants_Type <type>)))))


;** SELECT_TANK_SIZE **
;     If the problem does not specify the tank size, this will choose one.
(SELECT_TANK_SIZE
        (params (<size>))
	(preconds
	 (Tank_size <size>))
	(effects (
		(add	(Wants_Size <size>)))))


;** SELECT_LOCATION **
;     If the problem does not specify the locaion for the tank, this will choose.
(SELECT_LOCATION
        (params (<place>))
	(preconds
	 (and (Location <place>)
	      (~(Is_Ready))))
	(effects (
		(add	(Wants_Placed <place>)))))


;** AGGRESSIVE_REQUIREMENTS **
;     Add the requirements for an aggressive tank to the state.  These are the things
;          that NEED to be satisfied for an aggressive tank.
;     Notice the forced UnderGravel filter and the lack of plants.
;          Aggressive fish tend to be messy and need an undergravel filter.
;          They also tend to uproot rooted plants.
(GET_AGGRESSIVE_REQUIREMENTS
 (params nil)
 (preconds 
  (and (Wants_Type Aggressive_Tank)
       (~(EXISTS (<type2>) (Tank_Type <type2>) (Selected <type2>)))))
 (effects (
	   (add (Need Fish))
	   (add (Need Filter))
	   (add (Wants_Filter UnderGravel_Filter))
	   (add (Need Heater))
	   (add (Need Light))
	   (add (Need Gravel))
	   (add (Need Thermometer))
	   (add (Selected Aggressive_Tank)))))



;** COMMUNITY_REQUIREMENTS **
;     Requirements for a community tank.
;     Note that plants are required.  Plants allow smaller fish to hide from the larger fish.
;          Basically, community does not mean 'peaceful.'
(GET_COMMUNITY_REQUIREMENTS
 (params nil)
 (preconds
  (and (Wants_Type Community_Tank)
       (~(EXISTS (<type2>) (Tank_Type <type2>) (Selected <type2>)))))
 (effects (
	   (add (Need Filter))
	   (add (Need Heater))
	   (add (Need Light))
	   (add (Need Fish))
	   (add (Need Plant))
	   (add (Need Gravel))
	   (add (Need Thermometer))
	   (add (Selected Community_Tank)))))



;** GOLDFISH_REQUIREMENTS **
;     Goldfish are incredibly hearty.  They don't NEED anything other than water to live.
;     I added gravel as a requirement anyways, since it is common to have it.
(GET_GOLDFISH_REQUIREMENTS
 (params nil)
 (preconds
  (and (Wants_Type GoldFish_Tank)
       (~(EXISTS (<type2>) (Tank_Type <type2>) (Selected <type2>)))))
 (effects (
	   (add (Need Gravel))
	   (add (Need Fish))
	   (add (Selected GoldFish_Tank)))))

)) ;No More Operators.






;Note:
;    Some of my operators could probably be defined as inference-rules, but I wanted
;    to make certain that any changes I made to the state remained permenantly after it
;    was applied.

(setq *INFERENCE-RULES* '(


;** INFER-WORLD **
;    The sum of basic knowledge the computer starts with.
(INFER-WORLD
	(preconds nil)
	(effects (
		  (add	(Filter Box_Filter))                         ;Types of filters
		  (add	(Filter Sponge_Filter))
		  (add	(Filter UnderGravel_Filter))

		  (add	(Gravel Red_Gravel))                         ;Colors of gravel
		  (add	(Gravel Blue_Gravel))
		  (add	(Gravel Green_Gravel))
		  (add 	(Gravel Gray_Gravel))
		  (add	(Gravel White_Gravel))
		  (add	(Gravel Natural_Gravel))
		  (add  (Gravel Black_Gravel))
		  (add  (Gravel Brown_Gravel))

		  (add	(Location Shelf))                            ;Possible locations for a tank.
		  (add	(Location Counter))                          ;   yes, I have used them all.
		  (add	(Location Table))
		  (add	(Location Stand))
		  (add  (Location Desk))
		  (add	(Location Floor))

		  (add	(Connectable UnderGravel_Filter Air_Hose))   ;Things that can connect to each other.
		  (add	(Connectable Air_Hose Air_Pump))
		  (add	(Connectable Air_Pump Power_Strip))
		  (add 	(Connectable Power_Strip Wall_Outlet))
		  (add	(Connectable Sponge_Filter Air_Hose))
		  (add	(Connectable Box_Filter Power_Strip))
		  (add	(Connectable Heater Power_Strip))
		  (add 	(Connectable Light Power_Strip))

		  (add	(Tank_Type Aggressive_Tank))                 ;Types of tanks.  Probably better
		  (add	(Tank_Type Community_Tank))                  ;  described as type of fish allowed.
		  (add	(Tank_Type GoldFish_Tank))

		  (add 	(Tank_Size 10_Rectangle))                    ;Sizes and shapes of common tank.
		  (add	(Tank_Size 20_Rectangle))
		  (add	(Tank_Size 29_Rectangle))
		  (add	(Tank_Size 55_Rectangle))
		  (add	(Tank_Size 110_Rectangle))
		  (add	(Tank_Size 220_Rectangle))
		  (add	(Tank_Size 32_Square))
		  (add	(Tank_Size 8_Hex))
		  (add	(Tank_Size 15_Hex))
		  (add	(Tank_Size 35_Hex))
		  (add	(Tank_Size 55_Hex))
		  
		  (add	(Rooted Red_Arrowhead))                      ;Plants that are rooted into the ground.
		  (add	(Rooted White_Arrowhead))
		  (add  (Rooted Anachris))
		  (add  (Rooted Herpestis))
		  (add	(Rooted Amazon_Sword))
		  (add	(Rooted Hygrophila))

		  (add	(Floating Water_Lettuce))                    ;Plants that float at top.
		  (add  (Floating Salvinia))
		  (add	(Floating Water_Hyacinth))
		  (add	(Floating Duckweed))
		  (add	(Floating Riccia))

		  (add	(Aggressive Aba_Aba_Knife))                  ;Mean Fish.
		  (add  (Aggressive Jack_Dempsey))                   ;    also tend to be larger and
		  (add  (Aggressive Electric_Eel))                   ;    more intelligent.
		  (add  (Aggressive Red_Tail_Catfish))
		  (add  (Aggressive Bala_Shark))
		  (add  (Aggressive Severum))
		  (add  (Aggressive Piranha))
		  (add  (Aggressive Fire_Mouth))
		  (add	(Aggressive Oscar))
		  (add	(Aggressive Convict))

		  (add	(Community Neon_Tetra))                     ;Community Fish.
		  (add  (Community Dojo))                           ;   defined that "They don't kill
		  (add  (Community Red_Top_Platy))                  ;   each other"
		  (add  (Community Black_Sailfin_Molly))
		  (add	(Community Clown_Loach))
		  (add	(Community Tiger_Barb))
		  (add  (Community Pearl_Danio))
		  (add  (Community Gourami))

		  (add	(GoldFish Comet))                           ;GoldFish.  Basically suck.
		  (add  (GoldFish Shubunkin))                       ;The best goldfish is a dead goldfish.
		  (add  (GoldFish Blue_Cap_Oranda))
		  (add	(GoldFish Red_Oranda))
		  (add	(GoldFish Tigerhead))
		  (add  (GoldFish Koi))
		  
					                            ;Classifications of things that
		                                                    ;   be required.
		  (add	(Required Fish))
		  (add	(Required Plant))
		  (add	(Required Filter))
		  (add 	(Required Heater))
		  (add	(Required Light))
		  (add	(Required Gravel))
		  (add	(Required Thermometer)))))



;** INFER-CONNECTED **
;   If X is connected to Y and Y is connected to Z, then X is connected to Z.
;   NOTE: connection is one-way, but it works as long as a left-right system is used.
(INFER-CONNECTED
	(preconds
		(and	(connected <item1> <item2>)
			(connected <item2> <item3>)))
	(effects (
		(add 	(connected <item1> <item3>)))))


;** INFER-SAFE-TO-ADD **
;     Determines whether a fish or plant can be added to the tank.
;     Basically it is bad to mix and match fish.  Also rooted plants are not allowed with
;     aggressive fish, since they tend to uproot them.
(INFER-SAFE_TO_ADD
	(preconds
		(and	(Has_Water)
			(or	(Floating <obj>)
				(and	(Rooted <obj>)
					(~(Selected Aggressive_Tank)))
				(and	(Community <obj>)
					(Selected Community_Tank))
				(and	(GoldFish <obj>)
					(Selected GoldFish_Tank))
				(and	(Aggressive <obj>)
					(Selected Aggressive_Tank)))))
	(effects (
		(add 	(Safe_To_Add <obj>)))))


))




