(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
      '((SELECT-FIRST-GOAL
		 (lhs (and (current-node <node>)
				   (not-top-level-node <node>)
				   (primary-candidate-goal <node> <goal>)))
		 (rhs (select goal <goal>)))
		)
)

(setq *SCR-OP-SELECT-RULES* 
  '(


 ;;; When two people are trying to talk, it seems foolish for them to
 ;;; walk away from each other.
 ;;;

	 (STAY-PUT
	  (lhs (and (current-node <node>)
		(current-goal <node> (aretalking <p1> <p2>))
		(candidate-op <node> converse)
		(known <node> (and
			   (location <loc>)
			   (at <p1> <loc>)
			   (at <p2> <loc>)))))
	  (rhs (select operator converse)))))
(setq *SCR-BINDINGS-SELECT-RULES* 
      '(

;;; When you have to go somewhere, try to make it a useful trip.
;;; This will allow Prodigy to satisfy (at <person> <place>)
;;; immediately, instead of making a stop at another place.
;;;

	(GET-THE-GOODS
	 (lhs (and (current-node <node>)
	       (current-goal <node> (at <dater> <loc2>))
	       (current-op <node> go)
	       (known <node> (at <dater> <loc1>))))
	 (rhs (select bindings (<dater> <loc1> <loc2>))))

;;; If you want to talk, go where the victim is (if they're not at home,
;;; that is; it'd be kinda impolite to walk up to somebody's door and
;;; ask them for a date).
;;;

	(GOTO-VICTIM
	 (lhs (and (current-node <node>)
		   (current-goal <node> (aretalking <dater> <victim>))
		   (current-op <node> converse)
		   (known <node> (and (at <victim> <loc>)
				      (~ (home <victim> <loc>))))))
	 (rhs (select bindings (<dater> <victim> <loc>))))

))
(setq *SCR-NODE-REJECT-RULES* 
      '(

;;;  If the victim isn't at home, they should never have to move.  After
;;; all, you can't count on your quarry to behave in a predictable fashion.
;;;

	(DO-NOT-MOVE-VICTIMS
	    (lhs (and (current-node <node>)
		      (current-goal <node> (go <victim> <from-loc> <to-loc>))
		      (on-goal-stack <node> (aretalking <dater> <victim>))
		      (known <node> (and (at <victim> <from-loc>)
					 (~(home <victim> <from-loc>))))))
	    (rhs (reject node <node>)))
				  
))
(setq *SCR-GOAL-REJECT-RULES* 
      '(

;;;  This avoids all of those annoying conversations with the help.  If
;;; their function is to sell things, it seems a waste of time to chat with
;;; them.
;;;

	(NO-CHIT-CHAT
	 (lhs (and (current-node <node>)
	       (candidate-goal <node> (converse <dater> <loudmouth> <loc>))
	       (on-goal-stack <node> (askedfordate <dater> <victim>))
	       (not-equal <victim> <loudmouth>)
	       (known <node> (and (musthave <victim> gift <obj>)
			      (or (~ (has <loudmouth> <obj>))
					  (sells <loudmouth> <obj>))))))
	 (rhs (reject goal (converse <dater> <loudmouth> <loc>))))
	(OTHER-WAY
	 (lhs (and (current-node <node>)
	       (candidate-goal <node> (converse <loudmouth> <dater> <loc>))
	       (on-goal-stack <node> (askedfordate <dater> <victim>))
	       (not-equal <victim> <loudmouth>)
	       (known <node> (and (musthave <victim> gift <obj>)
			      (or (~(has <loudmouth> <obj>))
				  (sells <loudmouth> <obj>))))))
	 (rhs (reject goal (converse <loudmouth> <dater> <loc>))))

;;; If you must get something to satisfy your prospective date, it would
;;; seem improper to have your date give it to you.
;;;

	(GET-YOUR-OWN
	 (lhs (and (current-node <node>)
	       (on-goal-stack <node> (proffer <dater> <victim> <ob>))
	       (candidate-goal <node> (proffer <victim> <dater> <ob>))))
	 (rhs (reject goal (proffer <victim> <dater> <ob>))))

;;; If you don't have a phone, you can't receive calls.  The phone company
;;; doesn't work fast enough for this world to model.
;;;

	(NO-PHONE
	 (lhs (and (current-node <node>)
	       (candidate-goal <node> (onphone <person>))
	       (known <node> (~(has <person> phone)))))
	 (rhs (reject goal (onphone <person>))))

))
(setq *SCR-OP-REJECT-RULES* 
      '(

;;; If you have something to discuss, by all means, do it here.  No reason
;;; to go gadding about to every location.
;;;

	(STAY-PUT-TO-TALK
	 (lhs (and (current-node <node>)
	       (candidate-op <node> go)
	       (on-goal-stack <node> (askedfordate <dater> <victim>))
	       (current-goal <node> (converse <dater> <victim> <loc>))
	       (known <node> 
		(~(exists (<ob> <retailer>) (gift-ob <ob>)
			  (and (musthave <victim> gift <ob>)
			       (~(has <dater> <ob>))
			       (or (and (sells <retailer> <ob>)
					(~(at <retailer> <place>)))
				   (and (has <person> <ob>)
					(~(at <person> <place>))))))))))
	 (rhs (reject operator go)))
))
(setq *SCR-BINDINGS-REJECT-RULES* 
      '(

;;; If you're a victim, you should let your flirtatious friend do the work.
;;;

	(SHE-STAYS
	 (lhs (and (current-node <node>)
	       (current-op <node> go)
	       (candidate-bindings <node> (<victim> <from> <to>))
	       (known <node> (and (~(nodate <victim>))
			      (at <victim> <from>)
			      (~ (home <victim> <from>))))))
	 (rhs (reject bindings (<victim> <from> <to>))))

;;; Once again, no time for chit-chat.
;;;

	(DO-NOT-TALK-TO-CLERKS
	    (lhs (and (current-node <node>)
		  (current-op <node> converse)
		  (candidate-bindings <node> (<clerk> <person> <loc>))
		  (known <node> (sells <clerk> <ob>))))
	  (rhs (reject bindings (<clerk> <person> <loc>))))
	(DO-NOT-TALK-TO-CLERKS-II
	    (lhs (and (current-node <node>)
		  (current-op <node> converse)
		  (candidate-bindings <node> (<person> <clerk> <loc>))
		  (known <node> (sells <clerk> <ob>))))
	  (rhs (reject bindings (<person> <clerk> <loc>))))


;;; Since none of our rules can be applied to one's self, we can reject
;;; all of these attempts.  This prevents us from expanding more useless
;;; nodes.
;;;

	(DO-NOT-APPLY-TO-SELF
	 (lhs (and (current-node <node>)
	       (candidate-bindings <node> (<ob1> <ob1>))))
	 (rhs (reject bindings (<ob1> <ob1>))))
	(SAME-AS-ABOVE
	 (lhs (and (current-node <node>)
	       (candidate-bindings <node> (<ob1> <ob1> <ob2>))))
	 (rhs (reject bindings (<ob1> <ob1> <ob2>))))
	(DO-NOT-GO-WHERE-YOU-ARE
	    (lhs (and (current-node <node>)
		  (current-op <node> go)
		  (candidate-bindings <node> (<person> <loc> <loc>))))
	  (rhs (reject bindings (<person> <loc> <loc>))))
))
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* nil)
(setq *SCR-OP-PREFERENCE-RULES* 
      '(

;;; We of Dateworld think that there should be more social interaction,
;;; so we prefer to converse face-to-face.
;;;

	(PREFER-CONVERSE
	 (priority 0)
	 (lhs (and (current-node <node>)
	       (current-goal <node> (are-talking <person1> <person2>))
	       (candidate-op <node> telephone)
	       (candidate-op <node> converse)))
	 (rhs (prefer operator converse telephone)))
))
(setq *SCR-BINDINGS-PREFERENCE-RULES* 
      '(
))
