
;-------------------------
; Define spacial relations
;-------------------------



; Range of dust is 3 units under and 1 to either side
; if an obj at x1,y1 is being dusted, then obj at x2,y2 will become dusty
; implies:  y1 > y2 (y1 is higher than y2)

(defun in-range-of-dust (x2 y2 x1 y1)
  (cond ((is-variable y1) 'no-match-attempted)
        ((is-variable y2) 'no-match-attempted)
        ((is-variable x1) 'no-match-attempted)
        ((is-variable x2) 'no-match-attempted)
	(
	 (and
	  (and (> (- x2 x1) -2)  (< (- x2 x1) 2) )
	  (and (> (- y1 y2)  0)  (< (- y1 y2) 4) ) 
	 )
	))
)


; is-under defined as: y1 1 unit under y1 and same x coords
; y1 is under y2

(defun is-under (y1 y2)
  (cond ((is-variable y1) 'no-match-attempted)
        ((is-variable y2) 'no-match-attempted)
	( (= y2 (+ y1 1) ) )
  )
)

(defun isnt-under (y1 y2)
  (cond ((is-variable y1) 'no-match-attempted)
	((is-variable y2) 'no-match-attempted)
	((not (is-under y1 y2) ) )
  )
)




(defun isnt-equal (a b)
  (cond ((is-variable a) 'no-match-attempted)
	((is-variable b) 'no-match-attempted)
	((not (eq a b))) )
)

(defun is-equal (a b)
  (cond ((is-variable a) 'no-match-attempted)
	((is-variable b) 'no-match-attempted)
	((eq a b) ))
)

;; Reach of robot is 2 up/down and 1 to either side.
;
;(defun in-arm-range (robot-x robot-y potential-x potential-y)
;  (and
;   (and (> (- potential-x robot-x) -1) (< (- potential-x robot-x) 2) )
;   (and (> (- potential-y robot-y) -3) (< (- potential-y robot-y) 3) )
;  )
;)

(defun gtr-than (a b)
  (cond ((is-variable a) 'no-match-attempted)
	((is-variable b) 'no-match-attempted)
	((> a b)) )
)



; Meta-Function for Search Control rules

(defun parent-op (node op)
  (and (not-top-level-node node)
       (current-op (node-parent node) op)))

