;****************************************************************
; CODE FOR EXPERIMENTS
;****************************************************************
; HIGH-LEVEL FUNCTIONS:

; TEST-RUN: for testing a set of scrs on a problem set.
; Need to create subdirectories called "rules" and "data" for each
; domain. 
;; example: (test-run "bw" "static-rules" "static-results")

; COMPARE:  for comparing the performance of two sets of scrs.
;; All inputs should be 'symbols!
;; example: (compare 'bw/data/static-results 'bw/data/prodigy-results
;                     'static 'prodigy)

; Running Experiments:

(defvar *indiv-ltime* nil)
(defvar *results* nil)

; Time to do the utility analysis.
(defvar *ua-time* 0)

; Time Prodigy is activated to verify GIs.
(defvar *gi-time* 0)

; "pure" EBL time. This misses some of EBL's bookkeeping overhead.
(defvar *ltime* 0)

; The time used by the planner!
(defvar *ptime* 0)


;; for large problems (eg mbb) might want to set gc-func appropriately.
(defun test-run (domain rules &optional results 
						(time-bound 150) (discard nil) (cum 10)
						(probsets '("run1.lisp" "run2.lisp" "run3.lisp"))
						(path-prefix "/projects/ai/prodigy/domains/")		
						gc-func
						)
  (let ((save *gc-before-run*))
    (setq *gc-before-run* gc-func)
    (unless results (setq results rules))
    (forget-all-rules)
    (setq *activate-ebl* nil *results* nil) ; key init line!
    (setq *discard-failure-branches* discard)
    (load (concatenate 'string path-prefix domain "/startup"))
    (setq *prodigy-time-bound* time-bound)
    (setq *node-cutoff* 'n200000)
    (when rules
		  (if (equal rules "human-rules")
			  (load (concatenate 'string path-prefix domain "/rules/" rules))
			(read-rules (concatenate 'string path-prefix domain "/rules/" rules)))
		  (load-domain)
		  )
    (gc t)
    (iter:iterate
     (iter:for set iter:in probsets)
     (run-cum-exp (concatenate 'string path-prefix domain "/probsets/" set)
				  time-bound))
    (write-cum-results (concatenate 'string path-prefix domain "/data/" results) cum)
    (setq *discard-failure-branches* nil)
    (setq *gc-before-run* save)
    ))


;****************************************************************
; ANALYZING DATA   



; comparsion code.
; prodigy should be first, followed by the speeder.

;; All figures are not including the unsolved problems.
;; All inputs should be 'symbols!
(defun compare (res1 res2 name1 name2 &optional (load nil) (full nil)
		     (time-bound 150))
  (let
      ((ttotal-diff 0)
       (ntotal-diff 0)
       (nt1 0) 
       (nt2 0)
       (unsolved1 0)
       (unsolved2 0)
       (win1 0)
       (win2 0)
       (no-ndiff 0)
       (small-ndiff 0)
       (large-ndiff 0)
       )
    (unless (and (boundp res1) (boundp res2) (not load))
	    (load (write-to-string res1 :case :downcase))
	    (load (write-to-string res2 :case :downcase)))
    (setq res1 (eval res1))
    (setq res2 (eval res2))
    (when full (format t "Problem,     ~s     ~s   Time     Nodes~%"
	      name1 name2))
    (iter:iterate
;;     (iter:initially          )
     (iter:for r1 iter:in (reverse res1))
     (iter:for r2 iter:in (reverse res2))
     (iter:for count from 1 to (length res1))
     (let* ((t1 (cadr r1))
	    (t2 (cadr r2))
	    (n1 (third r1))
	    (n2 (third r2))
	    (tdiff (- t1 t2))
	    (ndiff (- n1 n2))
	    )
       (setq nt1 (+ nt1 n1))
       (setq nt2 (+ nt2 n2))
       (setq ntotal-diff (+ ndiff ntotal-diff))
	   (when (and full (or (not (= ndiff 0)) (not (= tdiff 0))))
			 (format t "~s:  ~4d, ~7d, ~7d. ~7d~%"
					 (first r1) t1 t2 tdiff ndiff))
       (cond
	((= ndiff 0) (incf no-ndiff))
	((<= (abs ndiff) 20) (incf small-ndiff))
	(t (incf large-ndiff)))
       (cond
	((and (= t1 0) (= t2 0)) nil)
	((or (>= t1 time-bound) (>= t2 time-bound))
	 (when  (>= t1 time-bound) (incf unsolved1))
	 (when  (>= t2 time-bound) (incf unsolved2)))
	(t
	   (when (> tdiff 0) (incf win1))
	   (when (< tdiff 0) (incf win2))
	   (setq ttotal-diff (+ tdiff ttotal-diff))
	   )))
)
;;     (iter:finally
      (format t "~s unsolved by ~s ~%" unsolved1 name1)
      (format t "~s unsolved by ~s ~%" unsolved2 name2)
      (format t "~% ~s faster on ~s, but ~s faster on ~s ~%"
	      name2 win1 name1 win2)
      (format t "Overall speedup: ~s ~%" ttotal-diff)
      (format t "Node total for ~s ~s, node total for ~s ~s ~%"
	      name1 nt1 name2 nt2)
      (format t "Overall node reduction: ~s ~%" ntotal-diff)
      (format t "Number of problems with same nodes expanded: ~s ~%"
	      no-ndiff)
      (format t "Number with node difference <=20: ~s ~%" small-ndiff)
      (format t "Number with node difference >20: ~s ~%" large-ndiff)
      )))   ;)

    
;****************************************************************

(defun run-cum-exp (string &optional (bound 150))
  (setq *ebs-print* nil)
  (setq *prodigy-time-bound* bound)
  (setq *node-cutoff* 'n200000)
  (load string)
  (run-all)
  )


(defun sum (data field)
  (iter:iterate
   (iter:for d iter:in data)
   (let ((x (apply field (list d))))
     (iter:summing (if (numberp x) x 0)))))

(defmacro load-n-sum (data field)
  (load (string-downcase (symbol-name data)))
  `(sum ,data ,field))



(defmacro load-n-ave (data field)
  (load (string-downcase (symbol-name data)))
  `(/ (sum ,data ,field) (float (number-solved ,data))))


(defun number-solved (data)
  (iter:iterate
   (iter:for d iter:in data)
   (iter:counting (numberp (fourth d)))))
  

;****************************************************************
(defun forget-learned-rules ()
  (forget-all-rules 'all))

;don't nullify *scr-goal-select-rules* because that contains prodigy's
;default control heuristic.

(defun forget-human-rules ()
    (mapc #'(lambda (rule)
  	      (eval `(setq ,rule nil)))
		'(*scr-node-select-rules*  
                  *scr-op-select-rules* *scr-bindings-select-rules*
		  *scr-node-reject-rules*  *scr-goal-reject-rules* 
		  *scr-op-reject-rules* *scr-bindings-reject-rules*
		  *scr-node-preference-rules* *scr-goal-preference-rules* 
		  *scr-op-preference-rules* *scr-bindings-preference-rules*)))

;don't nullify *scr-goal-select-rules* because that contains prodigy's
;default control heuristic.
(defun forget-all ()
  (forget-rules 'all)
  (setq *learned-rules* nil *new-learned-rules* nil
	*learned-rules-in-sys* nil)
    (mapc #'(lambda (rule)
  	      (eval `(setq ,rule nil)))
		'(*scr-node-select-rules*  
                  *scr-op-select-rules* *scr-bindings-select-rules*
		  *scr-node-reject-rules*  *scr-goal-reject-rules* 
		  *scr-op-reject-rules* *scr-bindings-reject-rules*
		  *scr-node-preference-rules* *scr-goal-preference-rules* 
		  *scr-op-preference-rules* *scr-bindings-preference-rules*)))









;****************************************************************
;utilities:

(defun write-run-results (file-nm)
  (with-open-file (prt file-nm :direction :output :if-exists :supersede
		       :if-does-not-exist :create)
		  (pprint (prepare-for-spoof (reverse *results*)) prt)
		  (pprint *RESULTS* prt)))


; for cumulative experiment in script.lisp.
(defun write-cum-results (file-nm &optional (step 5) name)
  (with-open-file (prt file-nm :direction :output :if-exists :supersede
		       :if-does-not-exist :create)
		  (format prt ";;")
		  (format prt "~s ~% ~%"
			  (cum-for-spoof *results* step))
;		  (format prt ";; ~s problem unsolved ~%"
;			  (find-unsolved *results*))
		  (format prt ";; ~s ~s ~%" (machine-type) (machine-instance))
		  (princ "(setq " prt)
		  (if name
		      (princ name prt)
		    (princ file-nm prt))
		  (princ " (quote " prt)
		  (format prt "~%")
		  (pprint *RESULTS* prt)
		  (format prt "~%")
		  (princ "))" prt)
		  ))
;  (setq *results* nil))


(defun write-cont-results (file-nm)
  (with-open-file (prt file-nm :direction :output :if-exists :append
		       :if-does-not-exist :create)
		  (pprint *RESULTS* prt)))


 (defun cum-for-spoof (data step &optional (field #'cadr))
  (let ((sum 0)
                (len (length data))
                )
        (iter:iterate (iter:for x iter:in (reverse data))
                                  (iter:for i from 1 to len)
;field=cadr means cpu seconds.
                                  (setq sum (+ sum (apply field (list x))))
                                  (when (= (mod i step) 0)
                                                (iter:collect i into result)
                                                (iter:collect sum into result))
                                  (finally (return result)))))



	
;****************************************************************
  
