;;-------------------------------------------------------------------
;;-  Author        :  Rob Spiger 
;;- Sponsoring Prof:  Oren Etzioni
;;-    Date        :  2/9/93
;;-------------------------------------------------------------------


(setq *PREPROCESS-AGAIN* T)

;; Preprocess.lisp
;;
;;
;;Stores each operator in *Rob-operators* as 
;;
;;(Name) = operator name
;;(unmodified params list)
;;(unmodified preconditions)
;;(unmodified effects)
;;
;;(all-variables in operator)
;;(all-non-wild-card-variables-in-operator)
;;(all-wild-card-variables-in-operator)
;;(possible-sharable-preconds)=those things in preconditions which might
;;  be instantiated as shared preconditions (see document 
;;  shared-literals.doc)
;;(subgoalable-preconditions) =those things which might be subgoaled
;;  upon to make the preconditions true. 
;;(static-subgoalable-preconditions)=those things that are static
;;  which might be subgoaled upon to make the preconditions true.
;;(non-static-subgoalable-preconditions)=those things that are non-static
;;  which might be subgoaled upon to make the preconditions true.
;;(list-of-all-effects)=all the effects of the operator in the format
;;  of (pred cond uv)
;;(list-of-effects-with-conditionals)=those things
;;   returned from function parse-effects.

;;
;;
;;  Static-predicates:     (sp1, sp2)  
;;  Non-static-predicates: (p1, p2)
;;
;;  (Sample-op
;;   (params (<x> <y> <z>))
;;   (preconds 
;;    (AND (FORALL (<a> (sp1 <a>) (p1 <a> <a>)))
;;         (FORALL (<a> (sp2 <a>) (p1 <a> <a>)))
;;         (OR
;;           (sp1 <x>)
;;           (p1 <y> <z>)
;;           (sp2 <z>))
;;         (p2 <y>)))
;;   (effects ((del (p2 <y>))
;;             (del (p1 <y> <*w>))
;;             (IF (AND (p1 <z> <*u>) (sp2 <*v>)) (ADD (p1 <*u> <*v>)))))
;;   
;;  NOTE:  Preprocess will give each FORALL or EXISTS generator 
;;         variables unique names.  In the example above, 
;;         the <a> in the first FORALL statement will get a variable
;;         name like <V1> and the second FORALL statement will get
;;         a different variable for <a> like <V2>
;;
;;  NOTE:  Static assumes that the same wildcard variable will not be
;;         present in more than on effect of the operator.  For
;;         example, one could not have both the effects:
;;         (IF (Object <*w>) (ADD (Holding <*w)))
;;         (IF (On <*w> <z>) (DEL (On <*w> <z>)))
;;         Static leaves the result of this undefined.
;;
(defstruct (rob-op
  (:print-function
   (lambda (p s k)
    (if *print-ops-terse*
    (format s "(Op: ~s)" (rob-op-name p))
    (progn
    (format s "~%Data-type:       Rob-op~%")
    (format s "~%Name:            ~s" (rob-op-name p))
    (format s "~%All-variables:   ~s" (rob-op-all-vars p))
    (format s "~%Non-wild-vars:   ~s" (rob-op-non-wild-vars p))
    (format s "~%Wild-vars:       ~s" (rob-op-wild-vars p))
    (format s "~%Preconditions:   ~s" (rob-op-preconds p))
    (format s "~%Sharable-pre:    ~s" (rob-op-sharable-pre p))
    (format s "~%Subgoals:        ~s" (rob-op-subgoals p))
    (format s "~%Static-goals:    ~s" (rob-op-static-goals p))
    (format s "~%Non-static-goals:~s" (rob-op-non-static-goals p))
    (format s "~%All-effects:     ~s" (rob-op-all-effects p))
    (format s "~%Parsed-effects:  ~s" (rob-op-parsed-effects p))
    (format s "~%Op-bindings:     ~s" (rob-op-op-bindings p))
	                                     )))))
  (name nil)                ;;'Sample-op
  (all-vars nil)            ;;(<x> <y> <z> <*w> <*u> <*v>
  (non-wild-vars nil)       ;;(<x> <y> <z> <V1> <V2>)
  (wild-vars nil)           ;;(<*w> <*u> <*v>)
  (preconds nil)            ;;(AND (FORALL (<v1>) (sp1 <v1>) (p1 <v1> <v1>))
                            ;;     (FORALL (<v2>) (sp2 <v2>) (p1 <v2> <v2>))
                            ;;     (OR
                            ;;       (sp1 <x>)
                            ;;       (p1 <y> <z>)
                            ;;       (sp2 <z>))
                            ;;     (p2 <y>))
  (sharable-pre nil)        ;;((sp1 <x>) (p1 <y> <z>) (sp2 <z>) (p2
							;;  <y>) (p1 <z> <*u>) (sp2 <*v>))
                            ;;
                            ;; (Duplicates are removed if they match
							;; exactly.)  SEE DOCUMENT 
                            ;;              sharable-literals.doc
  (subgoals nil)            ;;((~ (sp1 <V1>)) (p1 <v1> <v1>)
  			    ;; (~ (sp2 <V2>)) (p1 <v2> <v2>)
                            ;; (sp1 <x>) (p1 <y> <z>) (sp2 <z>) (p2 <y>))
                            ;; These subgoals exclude those things in
							;; the conditionals of conditional effects.
  (static-goals nil)        ;;((~ (sp1 <v1>)) (~ (sp2 <v2>)) (sp1 <x>)
                            ;; (sp2 <z>))
  (non-static-goals nil)    ;;((p1 <v1> <v1>) (p1 <v2> <v2>)
                            ;; (p1 <y> <z>) (p2 <y>))
  (parsed-effects nil)      ;; EXACTLY what function parse-effects returns.
  (all-effects nil)         ;; (((~ (p2 <y>)) T nil)
                            ;;  ((~ (p1 <y> <*w>)) T (<*w>))
                            ;;  ((p1 <*u> <*v>) (AND (p1 <z> <*u>)
                            ;;                   (sp2 <*v>)) (<*u> <*v>)))
                            ;;FORMALLY=(effect t wildcards)
  (op-bindings nil)         ;;how the things in the operator were
							;;rebound

                     )  ;;important ()


(defun preprocess ()
 (setq *pos-achievers* nil)
 (setq *neg-achievers* nil)
 (setq *rob-achievers* nil)
 (setq *rob-achievables* nil)
 (iter:iterate
 (iter:for op iter:in *achievers*)
  (format t "~%~s" (first op))         
  (let* (    (name           (first op))
    (old-vars       (find-variables op))
    (op             (give-forall-and-exists-unique-vars-in-op op))
    (new-vars       (find-variables op))
    (delta-vars     (remove-if #'(lambda (x) (member x old-vars)) new-vars))
;;delta-vars are those unique variables that the EXISTS and FORALL
;;statements were instantiated with.  (These are not wildcards)
    (preconds       (second (third op)))
    (all-vars       new-vars)
    (precond-vars   (find-variables preconds))
    (precond-vars   (remove-if #'(lambda (x) (member x delta-vars))
                                         precond-vars))
                      ;;Can't just take precondition variables out
					  ;;of the params list since we have added some by
					  ;;giving each forall and exists statement unique
					  ;;variable names.
    (precond-blist  (make-new-blist precond-vars))
    (op             (instantiate op           precond-blist))
    (preconds       (instantiate preconds     precond-blist))
    (precond-vars   (instantiate precond-vars precond-blist))
    (all-vars       (instantiate all-vars     precond-blist))
;;         (delta variables don't change)
;;gave new names to all variables in operator so test to find which
;;  kind of variable somethings is is valid henceforth.  


    (parsed-effects (parse-effects (second (fourth op))))
    (effects-vars   (find-variables (mapcar #'first parsed-effects)))
    (wild-vars      (remove-if #'(lambda (x) (member x precond-vars))
                      effects-vars))
    (non-wild-vars  (remove-if #'(lambda (x) (member x wild-vars))
                      all-vars))

;;instantiate the wildcards with wild card names
    (wild-blist     (make-new-wild-blist wild-vars))
    (parsed-effects (instantiate parsed-effects wild-blist))
    (wild-vars      (instantiate wild-vars      wild-blist))
    (all-vars       (instantiate all-vars       wild-blist))

;;save how things were bound with operator
    (op-bindings    (append wild-blist precond-blist))
(parsed-effects-copy (mapcar #'(lambda (x) x) parsed-effects))

;;org line    (preconds-4-efs `(AND ,(mapcan #'second parsed-effects-copy)))
;;org line cannot be used due to some destructive thing happending to
;; parsed-effects when it is used.  (??? Not sure why.)

    (preconds-4-efs `(AND ,@(remove-nils (mapcar #'second parsed-effects-copy))))
	                  ;;yeilds a list of all preconds for conditional
					  ;;effects 
    (all-preconds   `(AND ,preconds ,@preconds-4-efs))
    (sharable-pre   (sharable-literals all-preconds))

    (sharable-pre   (remove-duplicates sharable-pre :test #'equal))
         ;;**One should note sharable-preconds still have predicates
         ;;containing wildcards in them, since they contain the
         ;;conditionals of conditional effects

    (subgoals       (subgoalable-literals preconds))
                      ;;(excludes preconds-4-efs, see document above)

    (subgoals       (remove-duplicates subgoals :test #'equal))

    (static-goals   (remove-if-not #'(lambda (x) (member (predicate-name x)
                                  *static-preds*)) subgoals))

    (non-static-goals (remove-if #'(lambda (x) (member x static-goals))
                                  subgoals))

    (all-effects    (mapcar #'(lambda (e-c) 
                               (transform-effects e-c wild-vars))
                     parsed-effects))
    (just-effects   all-effects)

    (just-del-effects (remove-if-not #'(lambda (x) (eq '~ (first
								   (first x)))) just-effects))
    (just-add-effects (remove-if #'(lambda (x) (eq '~ (first
								   (first x)))) just-effects))
    (op-cell        (make-rob-op 
     :name             name             :all-vars         all-vars
     :non-wild-vars    non-wild-vars    :wild-vars        wild-vars
     :preconds         preconds         :sharable-pre     sharable-pre
     :subgoals         subgoals         :static-goals     static-goals
     :non-static-goals non-static-goals :parsed-effects   parsed-effects
     :all-effects      all-effects      :op-bindings      op-bindings))
    (neg-effects    (mapcar #'(lambda (x) `(,x ,op-cell)) just-del-effects))
    (pos-effects    (mapcar #'(lambda (x) `(,x ,op-cell)) just-add-effects)))
;; For debuggin neg-effects and pos-effects just set op-cell to name
;;        so you don't end up looking at the structure everytime you
;;        look at *pos-achievers*

   (setq *rob-achievables* (append *rob-achievables*
               (remove-if #'(lambda (x) (member x *rob-achievables*
                        :test #'match-var-to-var-only))
						  just-effects)))    
   (setq *rob-achievers* (cons op-cell *rob-achievers*))

   (add-effects-to-pos-achievers pos-effects)
   (add-effects-to-neg-achievers neg-effects))))


;;add positive effects to positive achievers
(defun add-effects-to-pos-achievers (pos-effects)
 (iter:iterate
 (iter:for pos-effect iter:in pos-effects)
  (let* (
    (pred-name   (first (first (first pos-effect))))
    (type-info   (find-type-info-for-effect pos-effect))
    (pos-effect  (append pos-effect (list type-info)))
    (member-pred (member pred-name *pos-achievers*
                   :test #'eq-first-of-pair)))
   (if member-pred
    (let* (
      (front     (butlast *pos-achievers* (length member-pred)))
      (middle    (first member-pred))
      (end       (rest member-pred))
      (middle    (append middle (list pos-effect))))
     (setq *pos-achievers* `(,@front ,middle ,@end)))
    (setq *pos-achievers* (cons `(,pred-name ,pos-effect)
						  *pos-achievers*))))))


;;add effects to negative achievers
(defun add-effects-to-neg-achievers (neg-effects)
 (iter:iterate
 (iter:for neg-effect iter:in neg-effects)
  (let* (  
    (pred-name   (first (second (first (first neg-effect)))))
    (type-info   (find-type-info-for-effect neg-effect))
    (neg-effect  (append neg-effect (list type-info)))
    (member-pred (member pred-name *neg-achievers*
                   :test #'eq-first-of-pair)))
   (if member-pred
    (let* (
      (front     (butlast *neg-achievers* (length member-pred)))
      (middle    (first member-pred))
      (end       (rest member-pred))
      (middle    (append middle (list neg-effect))))
     (setq *neg-achievers* `(,@front ,middle ,@end)))
    (setq *neg-achievers* (cons `(,pred-name ,neg-effect)
						  *neg-achievers*))))))

;;effect here is the effect paired with the operator which achieves the effect.
(defun find-type-info-for-effect (effect-op)
 (let* (
   (effect (first  effect-op))
   (op     (second effect-op))
   (effects-preconds (second effect))
   (preconds        (rob-op-preconds op))
   (effects-preconds (rob-simplify effects-preconds 'no-sub))
   (preconds         (rob-simplify preconds         'no-sub)) ;;note this will remove
                                              ;;those preconds in false list!
   (typing-lits (append (find-anded-static-preds-in-exp effects-preconds)
                        (find-anded-static-preds-in-exp preconds))))
  typing-lits))


;;******could get list of achievables by snaging everything out of
;;  pos-effects and neg-effects.

(defun find-bad-operators-for-goal (goal)
 (remove-duplicates
  (apply #'append
   (mapcar #'rest
    (remove-if-not
     #'(lambda (bad-ops-list-element) 
        (match-nonvar-or-var-to-var-only goal
                               (first bad-ops-list-element)))
     *bad-ops*)))))



;; Takes in a ((effect) (cond)) and finds the wildcards in it
;; and returns it in the form (effect cond wildcards)
;;  NOTE:  if cond = nil then cond is set to T

(defun transform-effects (e-c wild-vars)
 (let* (
  (effect     (first e-c))
  (effect-var (find-variables effect))
  (uv         (remove-if-not #'(lambda (x) (member x wild-vars)) effect-var))
  (condition  (second e-c))
  (condition  (if (null condition) T condition)))
 `(,effect ,condition ,uv)))
 

;;For every forall or exists statement in the operator, it gives those
;; variables which are in their params list unique variables names
;; and instantiates them.
;;
;; Also, converst ~EXISTS into forall statements, otherwise you would
;;  give the ~EXISTS statements variables like <E1> and change the
;;  ~EXISTS statement to a FORALL expression later on with <E1>
;;  variables in it.

(defun give-forall-and-exists-unique-vars-in-op (op &optional (blist nil))
 (cond
  ((null op) nil)
  ((atom op) (instantiate op blist))
  ((OR (eq (first op) 'EXISTS)
       (eq (first op) 'FORALL))
    (let* (
       (blist  (append blist (make-new-blist-fe (second op) (first op))))
       (params (instantiate (second op) blist)))
      (append 
      `(,(first op) ,params 
        ,(give-forall-and-exists-unique-vars-in-op (third op) blist))
        (when (= (length op) 4)
          (list (give-forall-and-exists-unique-vars-in-op (fourth op)
													blist))))))
  ((AND (eq (first op) '~)
        (eq (first (second op)) 'EXISTS))
     (give-forall-and-exists-unique-vars-in-op 
                    (negate-sentence (second op))))
  (t (mapcar #'(lambda (x)
             (give-forall-and-exists-unique-vars-in-op x blist)) op))))
     
      


;;-----------------------------------------------------------
;; Have set-up as follows:
;;
;;*rob-pos-achieve*
;; (predicate-name (instance-of-predicate-in-effect1 operator1)
;;                 (instance-of-predicate-in-effect2 operator2)
;;                 (instance-of-predicate-in-effect3 operator3))
;;
;;Example from blocksworld of *pos-achievers*:
;;((ON        (((ON <V169> <V168>) T NIL) (Op: STACK)))
;;
;; (ON-TABLE  (((ON-TABLE <V167>) T NIL) (Op: PUT-DOWN)))
;;
;; (ARM-EMPTY (((ARM-EMPTY) T NIL) (Op: PUT-DOWN))
;;            (((ARM-EMPTY) T NIL) (Op: STACK)))
;;
;; (CLEAR     (((CLEAR <V167>) T NIL) (Op: PUT-DOWN))
;;            (((CLEAR <V169>) T NIL) (Op: STACK)) 
;;            (((CLEAR <V170>) T NIL) (Op: UNSTACK)))
;;
;; (HOLDING   (((HOLDING <V166>) T NIL) (Op: PICK-UP))
;;            (((HOLDING <V171>) T NIL) (Op: UNSTACK)))) 
;;
;;The above example was found with *print-ops-terse set to T.
;;
;; *neg-achievers* has the same format as *pos-achievers*.
;;--------------------------------------------------------------

;; Input: Goal=  must be a possibly-negated-predicate
;;
;; Returns a list of the following:
;;
;; op-name
;; binding-list             variables that bind the op to the goal
;; unbound-normal-variables [But may include things inside FORALL or 
;;                           EXISTS statements.]
;; unbound-wildcard-variables [None of the wildcard variables will
;;                             ever be bound by matching with the goal.]
;; semi-bound-preconditions
;; semi-bound-sharable-preconditions
;; semi-bound-effects
;; 
;;
;; semi-bound-effects have form (pred cond uv)
;;           pred=single effect
;;           cond=single conditional for effect to happen
;;                 (equal T for unconditional effects)
;;           uv=those variables in effect that are wildcards
;;
;; Also handles the case of the goal variables binding to the
;; wildcards in the effect.  If this happens, the effect is
;; created twice.  Once bound to the goal and once unbound with the
;; wildcard in.
;;
;; For example:  If the effect was:
;;    (IF (Object <*x>) (ADD (On <y> <*x>)))
;;
;;  And the goal was: (On <a> b)
;;
;; the semi-bound-effect returned would be:
;;
;; (((On <a> b) (Object b) nil)
;;  ((On <y> <*x>) (Object <*x>) (<*x>)))
;;

(defun rob-relevant-operators (goal)
(let ((result
 (let* (
   (bad-ops     (find-bad-operators-for-goal goal))
   (negated   (eq (first goal) '~))
   (non-neg-goal (if negated (second goal) goal))
   (predicate (if negated (first (second goal))
                          (first goal)))
   (pred-ops  (if negated (rest (first 
						   (member predicate *neg-achievers*
                            :test #'eq-first-of-pair)))
                          (rest (first (member predicate *pos-achievers*
							:test #'eq-first-of-pair))))))
;;pred-ops is a list of (pred-cond-uv ptr-to-operators typing-info-about-op-vars)
  (remove-nils
  (iter:iterate
  (iter:for pred-op iter:in pred-ops)
   (let* (
     (org-blist       (rob-match (first (first pred-op)) goal))
     (blist       org-blist)
     (op-name     (rob-op-name (second pred-op)))
     (uv          (third  (first pred-op)))
     (conditional (second (first pred-op)))
     (cond-wild-v (find-variables conditional))
     (cond-wild-v (remove-if-not #'(lambda (x) (member x uv)) cond-wild-v))
;;need to give wildcards in conditional normal names if the
;;conditional is put into the preconditions.  
     (cond-blist  (make-new-blist cond-wild-v))
     (conditional (instantiate conditional cond-blist))
     (cond-vars   (instantiate cond-wild-v cond-blist)) ;;These need to be added
  	                                       ;;to the unbound variables
     (op          (second pred-op)))
	(unless (OR (eq blist 'No-match)
                (member op-name bad-ops))

     (list
      (let* (
        (extra-effect           (instantiate (first pred-op) blist))
;;This effect of the operator will need to be added if the goal's
;; variables were bound to a wildcard variable in the effects
        (smaller-uv      (remove-if #'(lambda (x)
                         (member x blist :test #'eq-first-of-pair)) uv))
;;This smaller-uv will be for the extra effect since the things the
;; goal variables bound to are no longer wildcard variables.

        (extra-effect    (unless (equal smaller-uv uv)
                         `(,(first extra-effect) ,(second extra-effect)
                         ,smaller-uv)))
;;Set the extra-effect to NIL if none of the goal's variables were
;;  bound to a wildcard variable.
;;Otherwise, remove from the extra-effects uv list those wildcards
;;  which got bound to the goal.
        (blist         (remove-if #'(lambda (bpair)
                         (member (first bpair) uv)) blist))
;;Remove from blist those variables of the goal which got bound to
;; wildcard variables - they won't be needed to instantiate the
;; preconditions and they will mess up the other wildcard effects
;; if the effects are instantiated with them.
        (effects       (instantiate (rob-op-all-effects op) blist))
        (effects       (if extra-effect
                        (append effects (list extra-effect))
                        effects))

        (name          (rob-op-name op))
        (non-wild-vars (remove-if #'(lambda (x) (member x blist
                               :test #'eq-first-of-pair)) 
                            (rob-op-non-wild-vars op)))
        (non-wild-vars (append non-wild-vars cond-vars))
        (wild-vars     (rob-op-wild-vars op))
        (op-bindings   (reverse-blist (rob-op-op-bindings op)))
        (preconds      (if (equal T conditional)
                        (rob-op-preconds op)
                        `(AND ,(rob-op-preconds op) ,conditional)))
;;And the conditional of the conditional effect if the goal was 
;; bound to a conditional effect.  Otherwise, leave the preconditions
;; the way they are.
        (preconds      (instantiate preconds blist))
        (sharable-pre  (instantiate (rob-op-sharable-pre op) blist)))
   
   (unless (typing-info-makes-op-fail non-neg-goal (third pred-op) org-blist)
    (iter:collect 
    `(,name
      ,blist
      ,non-wild-vars
      ,wild-vars
      ,preconds
      ,sharable-pre
      ,effects
      ,op-bindings))))))) ) ))
)) 
;;(format t "~%Found Rob-relevant-operators")
result))


(defun bpair-of-goal-var-bound-to-const (bpair)
 (and (goal-var? (first bpair))
      (is-constant (second bpair))))

(defun op-bound-goal-var-to-consts (op)
 (find-if #'bpair-of-goal-var-bound-to-const (second op)))

 

;;just like rob-relevant-operators, only computes the shared literals
;;and returns them.  Leaves out the things used only to compute shared
;;literals.
;; See end of function for what it returns.
;;   THE VALUES RETURNED DO NOT NEED TO BE INSTANTIATED.

(defun relevant-ops-with-shared-lits (goal parent-node)
 (let* (
   (goal-consts              (find-goal-consts goal))
   (goal-blist               (mapcar #'(lambda (consts) 
                               `(,(make-all-goal-consts-into-vars consts) ,consts)) goal-consts))
   (goal                     (make-all-goal-consts-into-vars goal))
   (all-the-ops              (rob-relevant-operators goal))

;;do a little extra work here to figure out what things they goal could have bound
;; to if it had had goal variables instead of goal constants.  The list of bad-bindings
;; which is returned at the end of this functions output is a list of those bindings which
;; could have happened if the goal had been made of goal variables instead of goal constants.
;; This list is important because it holds information about what options for bindings STATIC
;; has rules out because it has bound the roots of the PSGs to goal constants instead of variables.
;;
   (all-the-ops-that-didnt-work (remove-if-not #'op-bound-goal-var-to-consts all-the-ops))
   (all-the-bad-blists       (mapcan #'second all-the-ops-that-didnt-work))
   (all-the-bad-bindings     (remove-if-not #'bpair-of-goal-var-bound-to-const all-the-bad-blists))
   (all-the-bad-bindings     (remove-duplicates all-the-bad-bindings :test #'equal))

   (all-the-ops              (remove-if #'op-bound-goal-var-to-consts all-the-ops))
   (all-the-ops              (instantiate all-the-ops goal-blist))
   (each-ops-name            (mapcar #'first   all-the-ops))
   (each-ops-goal-blist      (mapcar #'second  all-the-ops))
   (each-ops-unbound-vars    (mapcar #'third   all-the-ops))
   (each-ops-wild-vars       (mapcar #'fourth  all-the-ops))
   (each-ops-preconditions   (mapcar #'fifth   all-the-ops))
   (each-ops-sharable-lits   (mapcar #'sixth   all-the-ops))
   (each-ops-effects         (mapcar #'seventh all-the-ops))
   (each-ops-op-bindings     (mapcar #'eighth  all-the-ops))
   (each-ops-parent-node     (mapcar #'(lambda (x) parent-node) all-the-ops))
   (next-level-bl-lits       (find-bindings-for-all-ops
                               each-ops-sharable-lits
                               each-ops-goal-blist
                               each-ops-wild-vars
                               each-ops-unbound-vars))
   (each-ops-binding-list    (first  next-level-bl-lits))
   (each-ops-whole-blist     (n-mapcar #'append each-ops-goal-blist
                                     each-ops-binding-list))
   (each-ops-op-bindings     (n-mapcar #'instantiate each-ops-whole-blist
                                   each-ops-op-bindings))
   (shared-lits              (second next-level-bl-lits)))
  (unless (null each-ops-name)
   `((,each-ops-parent-node
      ,each-ops-name
      ,each-ops-op-bindings
      ,(n-mapcar #'instantiate each-ops-preconditions each-ops-binding-list)
      ,(n-mapcar #'instantiate each-ops-effects       each-ops-binding-list)
      ,shared-lits)
     (,all-the-bad-bindings)))))


;;have to deal with another level of indirection because 
;; of preprocessing the operators.
