;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; 
;; Globals.lisp contains the declaration of all the global 
;;   variables used by static
;;
;; Author: Julie Roomy
;; Sponsoring Professor: Oren Etzioni
;; Modifications: Rob Spiger
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;; *roots* is used to point to the list containing all of the 
;; created psgs.
(defvar *roots* nil)

;; *limit* usefull for large domains
;; limit on the number of operator levels.

;; set *make-preference-rules-with-op-failure-conditionals*
;; when you want to make preference rules based on a particular
;; operator being used.

(defvar *make-preference-rules-using-specific-operator* nil)

;; counters
(defvar *VAR-NAME-COUNTER* 0)
(defvar *const-name-counter* 0)
(defvar *rule-name-counter* 0)
(defvar *wc-name-counter* 0)
(defvar *forall-name-counter* 0)
(defvar *exists-name-counter* 0)
(defvar *nod-name-counter* 0)

(defvar *static-est-savings* 30)
(defvar *limit* 100)
(defvar *screen-width* 0)
(defvar *achievers* nil)
(defvar *achievables* nil)



(defvar *WILD-CARDS* nil)          ;; still have to implement


;;-----------------
;; global variables used to store the rules as they are being generated

(defvar *frules* nil)
(defvar *top-level-node-rejection-rules* nil)
(defvar *all-rules* nil)
(defvar *brules* nil)
(defvar *preference-rules* nil)
(defvar *goal-rejection-rules* nil)
(defvar *operator-rejection-rules* nil)
(defvar *learned-rules* nil)
(defvar *new-learned-rules* nil)
(defvar *learned-rules-in-sys* nil)
(defvar *saved-rules* nil)
(defvar *srules* nil)
(defvar *node-rules* nil)
(defvar *gc-rules* nil)
(defvar *pv-rules* nil)
(defvar *op-gc-rules* nil)
(defvar *op-pv-rules* nil)

;; The sole-op failure rules are removed from *frules* after forming binding
;; rules.  In case the information in these rules is desired at a later
;; date, it is saved in *sole-op-frules*
(defvar *sole-op-frules* nil) 


;;---------------
;; global variables used to bookeep results of running Prodigy with
;; and without generated rules
(defvar *results* nil)
(defvar *end-time* nil)
(defvar *macro-learning nil)
(defvar *ua-time* nil)
(defvar *indiv-ltime* nil)
(defvar *gi-time* nil)


;;----------------
;; global variables used to store usefull information about a domain
;; See domain.lisp for more information on these variables.

; List that holds invariant facts about the domain.
(defvar *invariant-list* nil)

; List that holds those predicates which are rarely unique
(defvar *rarely-unique-list* nil)
(defvar *typing-info-list* nil)

; Is true when the typing information in *typing-info-list* 
; should be used when picking operators.

(defvar *use-typing-info-list* t)

; List that holds all necessarily false literals in the domain.
(defvar *false-list* nil)

; List that holds static-preds that are always satisfied.
(defvar *non-gratis-list* nil)

; List of literals that won't be top-level goals.
(defvar *non-goals* nil)

; List of ops that shouldn't be used.
; encodes the knowledge in default ck.
(defvar *bad-ops* nil) 

;A list containing the predicates that cannot hold in the same state.
; The list is initialized by make-negation-list.
(defvar *negation-list* nil)
(defvar *negation-list-both-ways*)
(defvar *negation-list-predicates*) ;;hash function for rob-negate-w-axioms

; List of predicates which are too expensive to expand.
(defvar *dont-expand-list* nil)

;;-----------------
;; Constants used by the matcher

; Returned by the matcher when a match requires no substitutions.
(defconstant *null* '(((nil nil))))

; input to the matcher.
(defconstant *null-bl* '(((nil))))


;;---------------------------------
;; variables used by the simplifier
; Null EBL axioms, to pacify Steve's simplifier code.
;;
;;(defvar *SINGLETON-PREDS* nil)
;;(defvar *AT-LEAST-ONE-GENERATORS* nil)
;;(defvar *EVALUABLE-DOMAIN-FNS* nil)
;;(defvar *SIMPLIFICATION-RULES* nil)

;;---------------------------------
;; variables used in creating the PSG.
;;

(defvar *CREATE-NEXT-LEVEL_OF_LITERALS* nil)
(defvar *CREATE-PSG-DEPTH* nil)
(defvar *CREATE-SHARED-LITERALS nil)
(defvar *EXPAND-BELOW-SHARED-LITERALS* nil)

;;----------------------------------
;; variables used by preprocessing
;;
(defvar *pos-achievers* nil)
(defvar *neg-achievers* nil)
(defvar *rob-achievers* nil)
(defvar *rob-achievables* nil)
(defvar *print-ops-terse* nil)

;;used by rob-bindings.lisp
(defvar *var-bind-info* nil)

