;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  Data Structures for Static Analyzer for Full Prodigy language
;;
;;  This file contains all the data structures used 
;;
;;
;;  Author: Julie Roomy
;;  Sponsoring Professor: Oren Etzioni
;;  Modifications:  Rob Spiger
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;Notes:  Use (browse) to figure out what each of these fields are.
;;        An additional data-structure is not documented here.
;;          See preprocess/preprocess.lisp to see data-structure for
;;          Rob-op which is how the preprocessed operators are
;;          are stored in *rob-achievers*.

;; Operator
(defstruct (Operator
    (:print-function
     (lambda (p s k) (show-op p))))
	(name nil)
	(parent nil)	    ;; link to goal
	(preconditions nil) ;; link to preconditions
	(label nil)
	(failure-condition nil)
	(effects nil)
	(necessary-effects nil)
	(bindings nil))

;; Literal
(defstruct (Literal
    (:print-function
     (lambda (p s k) (show-lit p))))
	(name  nil)          ;; predicate and quantified variables (generator)
			     ;;  predicate may be negated
	(parent nil)         ;; either an Internal node or an Operator node
	(operators nil)      ;; operators which achieve literal as subgoal
	(label nil)
	(failure-condition nil)
	(goal-stack nil)
	(shared nil)
	(already-traversed nil)
        (bad-bindings nil)
	(bindings nil)
    (completely-shared nil)    
    (necessary-effects nil)   
)


;; Internal Node
(defstruct (InternalNode
    (:print-function
     (lambda (p s k) (show-internal p))))
	(name nil)	    ;; either AND, OR, NOT, FORALL (EXISTS uses and)
	(parent nil)	    ;; either an Internal node or an Operator node
	(operands nil)	    ;; the operands of the clause
	(label nil)
    (params nil)
    (generator nil)
    (anded-static-preds nil)
    (f-expression nil)
	(failure-condition nil)
	(goal-stack nil)
    (necessary-effects nil)
	(bindings nil))


;;Handy function to show elements of these structures
;; in a much shorter form to follow while tracing functions.

(defun terse-nodes ()
 (defun show-lit (p) (format t "~s" (literal-name p)))
 (defun show-internal (p) (format t "~s" (internalnode-name p)))
 (defun show-op (p) (format t "~s" (operator-name p))))

;;Just say:
;; <cl> (terse-nodes)
;; to use.