;;****************************************************************
;;****************************************************************
;;
;; STATIC V2.0
;; by:   Oren Etzioni
;; mod:  Bruce LeSourd
;;
;; date: 16 Dec 1991
;;
;; MATCHER
;;
;; MODS:
;; 
;;
;;****************************************************************
;;****************************************************************

 
;****************************************************************
; My modifications:
; Made arg-type nil, since I don't use types.
; Made blsts optional with (((nil))) as the default.
; Changed Craig's conses to lists.
; modified is-var to craig-is-var to avoid conflict with prodigy/ebl.
; Allowed singleton arguments to match.

; Notes:

; Semantics: match(P,Q) iff exists s1,s2 s.t. forall p in P, exists q
; in Q s.t. s1(p)=s2(q).

; The arguments need to be lists of literals!  The two arguments are
; not symmetric.  That is, the matcher takes the first expression, and
; matches it with the second, doing unification between the literals.

; so:
; ((p <x>)) matches ((p <y>) (q <z>)). But not vice versa.
; The variables in either experssion can be specialized, however:
; ((p <x>)) matches ((p b)) and vice versa.
; It follows that:
; If both the lists are singleton then the the success of match does
; not depend on the argument order.  However, the order in the
; bindings list is determined by the argument order so:
; ((p <x>) ((p <y>))--> ((<x> <y>)). But
; ((p <y>) ((p <x>))--> ((<y> <x>)).

;****************************************************************

(setq *MATCH-TRACE* nil)
(setq *MATCH-FAILURES* nil)

; Interface function that encapsulates my changes to Craig's code.
(defun match (exp1 exp2 &optional (blsts '(((nil)))) notvars)
  (unless (listp (car exp1)) (setq exp1 (list exp1)))
  (unless (listp (car exp2)) (setq exp2 (list exp2)))
  (make-conses-into-lists (craig-match exp1 exp2 blsts notvars)))


(defun make-conses-into-lists (lbl)
  (iter:iterate
   (iter:for bl iter:in lbl)
   (iter:collect
    (iter:iterate
     (iter:for b iter:in bl)
     (iter:collect (list (car b) (cdr b)))))))

; Top level matching function.  Called with two lists of literals and
; a list of binding lists.  The first list is matched against the
; second and it returns the possible bindings for the match.  There is
; an optional fourth argument which specifies a list of variables that
; cannot be restricted.  Thus, those variables are treated as
; constants.  
(defun craig-match (exp1 exp2 &optional blsts notvars)
  (cond ((not (listp blsts))(error "Illegal binding list in matcher")))
  (cond (*MATCH-TRACE* (format t "~%~%Exp1: ")
		       (pprinc exp1)
		       (format t "~%Exp2: ")
		       (pprinc exp2)
		       (format t "~%Blsts: ")
		       (pprinc blsts)
		       (format t "~%Result: ")))
  (let ((result (matcher exp1 exp2 blsts notvars)))
    (if *MATCH-TRACE* (pprinc result))
    result))

;;;
;;;
;;;
;;; Recurses through the first list of literals attempting to match each 
;;; literal with the second list.  
;;;
(defun matcher (exp1 exp2 blsts notvars)
  (cond ((null exp1) blsts)
	(t (let ((new-blsts (remove-duplicates 
			     (match-each (car exp1) exp2 blsts notvars)
			     :test #'equal)))
	     (cond ((not (null new-blsts))
		    (matcher (cdr exp1) exp2 new-blsts notvars)))))))
;;;
;;;
;;;
;;; Recurses through the second list of literals and attempting to match the 
;;; first literal against each of the literals in the second list.
;;;
(defun match-each (lit1 exp2 blsts notvars)
  (cond ((null exp2) nil)
	(t (let ((new-blsts (match-each-blst lit1 (car exp2) blsts notvars)))
	     (cond ((null new-blsts)
		    (match-each lit1 (cdr exp2) blsts notvars))
		   (t (append new-blsts 
			      (match-each lit1 (cdr exp2) blsts notvars))))))))
;;;
;;;
;;;
;;; Recurses through the setting of binding lists, calling the unifier with 
;;; the two literals and each of the binding lists.
;;;
(defun match-each-blst (lit1 lit2 blsts notvars)
  (cond ((null blsts) nil)
	(t (let ((new-blsts (unify lit1 lit2 (car blsts) notvars)))
	     (cond ((null new-blsts)
		    (match-each-blst lit1 lit2 (cdr blsts) notvars))
		   (t (cons new-blsts 
			    (match-each-blst lit1 lit2 (cdr blsts) notvars))))))))

;;;    This function takes two expressions and a list of bindings and
;;;attempts to unify them.  It assumes that the variable names in each
;;;expression are unique from those in the other expression.  The
;;;initial blst should be ((nil . nil)) and the function returns nil
;;;if it fails to unify.

(defun unify (x y blst notvars)
  (let ((x (sublis blst x))
	(y (sublis blst y)))
    (cond ((and (null x)(null y)) blst)
	  ((eq x y) blst)
	  ((and (craig-is-var notvars x)
		(eq (arg-type x)(arg-type y)))
	   (deref (acons x y blst)(acons x y blst) notvars))
	  ((and (craig-is-var notvars y)
		(eq (arg-type x)(arg-type y)))
	   (deref (acons y x blst)(acons y x blst) notvars))
	  ((not (and (listp x)(listp y)))
	   (if (eq x y) blst))
	  (t (let ((car-blst (unify (car x)(car y) blst notvars)))
	       (cond ((null car-blst) nil)
		     (t (unify (cdr x)(cdr y) car-blst notvars))))))))
;;;
;;;
;;;
;;; Takes a binding list (the first and second argument should be identical)
;;; and derefereces all the variables in that list.  This means it takes
;;; the cdr of each association pair, checks to see if it is a variable and
;;; then replaces it with any corresponding bindings if it is.
;;;
(defun deref (blst entire-blst notvars)
  (cond ((null blst) nil)
	((craig-is-var notvars (cdar blst))
	 (cond ((null (assoc (cdar blst) entire-blst))
		(cons (car blst)(deref (cdr blst) entire-blst notvars)))
	       (t (cons (cons (caar blst)(cdr (assoc (cdar blst) entire-blst)))
			(deref (cdr blst) entire-blst notvars)))))
	(t (cons (car blst)(deref (cdr blst) entire-blst notvars)))))
;;;
;;;
;;;
(defun craig-is-var (notvars x)
  (cond ((and (rob-is-var? x)
	      (not (member x notvars))))))


; I don't use typed arguments.
(defun arg-type (x) nil)