;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; Common Lisp NONLIN - University of Maryland at College Park 
;;;;
;;;; Version 1.2, 11/91
;;;; (email nonlin-users-request@cs.umd.edu for more info)
;;;; 
;;;; TOME.LISP:  Functions for handling TOME (Table of Multiple Effects) Entries
;;;;
;;;; History: 
;;;; 10/01/91 bpk - fixed bug in LOOKUP-TOME-PARTIAL-PAT


(defstruct (tome-entry (:print-function print-tome-entry))
  effect    ;; a ground pattern
  asserts   ;; list of nodes
  deletes)  ;; list of nodes          

(defvar *tome* (make-hash-table)
 "the global table of tome-entrys hashed under predicates")
    

(defun print-tome-entry (tome-entry stream depth)
  (declare (ignore depth))
  (format stream "Eff:~s  :assert[~s ]  :delete[~s ]~%" (tome-entry-effect tome-entry)	
	  (get-tome-entry-asserts tome-entry) (get-tome-entry-deletes tome-entry))
  )


(defvar *tome* (make-hash-table)
 "the global table of tome-entrys hashed under predicates")

(defun print-tome (&optional(stream t) (depth t))
   (declare (ignore depth))
  (format stream "~%Tome Table Entrees:~%")
	       (for (tome-entry :in (all-tome-entrys))
                 :do
	       (format stream "~s" tome-entry))
nil
    )

    
(defun all-tome-entrys ()
    (let (glist)
	 (maphash #'(lambda (key tome-entry-list)
			    (declare (ignore key))
			    (setf glist (append glist tome-entry-list))
		    ) *tome*)
	 glist))
    
(defun reset-tome ()
    (setf *tome* (make-hash-table)))
    
;; returns the list of tome entrys whose predicate match the predicate
;; of the pattern "pattern". pattern is always ground.

(defmacro relevant-tome-entrys (pattern)
    `(gethash (predicate ,pattern) *tome*))

;; enters a tome-entry into tome into the hashed bucket

(defmacro  enter-tome-table (entry)
    `(push ,entry (gethash (predicate (tome-entry-effect ,entry)) 
		      *tome*))
)
    
;; TOME also does not deal with partially instantiated patterns.
;; This function returns the tome-entry whose pattern matches 
;; the effect "effect"

(defun lookup-tome (effect)
    (let (result (datalist (relevant-tome-entrys effect)))    
          (setf result (find effect datalist
			     :key 'tome-entry-effect :test #'equal))
    )
)

;; if an entry corresponding to the effect is in tome, the entry
;; is returned--else, an entry is made for that effect, is placed
;; in *tome* and the entry is returned..
;; effect has to be GROUND--partially instantiated effects are not
;; stored in tome...

(defun index-tome  ( effect)
     (let ((lookup-result (lookup-tome effect))
            effect-entry)
	   (if lookup-result
	      ; if there is such an entry already then return it
	      (return-from index-tome lookup-result)
		 (else
		   (setf effect-entry 
			 (make-tome-entry :effect effect))
		   ; put the new entry into tome
		   (enter-tome-table effect-entry)
		   (return-from index-tome  effect-entry)
		  ))
    ))

;; This is the only function which handles partially instanciated 
;; effects. Given a partially instanciated effect in peffect this
;; returns all tome entrys whose pattern unify with peffect. This
;; is called by the function Q&A(the question answering routine)
;; to determine the truthfulness of a condition at a particular
;; node

(defun lookup-tome-partial-pat (peffect)
    (let (results 
         (datalist (relevant-tome-entrys peffect)))
    (cond ((null datalist) nil) ; fixed this to Not call retrieve if no match
    (t 
       (setf results (retrieve peffect :from-data-list datalist
			       :key-function 'tome-entry-effect :with-pat t))))
 ))

;; Enters the fact into tome that the effect "effect" of type "type" is the effect of
;; the node "atnode". type is either assert or delete. Just like make-succnode,make-
;; prenode etc this is context sensitive i.e. if the current context is same as the
;; latest context in the corresponding tome entry then the atnode is just added 
;; otherwise a new tome entry is made with the current context, atnode and the nodes
;; with the latest context and pushed the corresponding tome entry

(defun enter-tome ( effect  type atnode)
    (let ((effect-entry (index-tome  effect)))
	 ;; make an entry for tome, if not already present
	 (case type
	       (:assert 
		 (if (not (member atnode (get-tome-entry-asserts effect-entry)))
		   (then
		     (if (eql *current-context* (get-context (car (tome-entry-asserts effect-entry))))
		        ;contexts are same and therefore just add atnode to the car of the 
			;list
		        (setf (tome-entry-asserts effect-entry)
			      (push (append1 (car (tome-entry-asserts effect-entry)) atnode)
			            (cdr (tome-entry-asserts effect-entry))))
			;else
			;make a new list with the current context and add to the list 
			(push (add-context (cons atnode (get-tome-entry-asserts effect-entry)))
			      (tome-entry-asserts effect-entry))))))
	       (:delete
		 (if (not (member atnode (get-tome-entry-deletes effect-entry)))
		    (then
		      (if (eql *current-context* (get-context (car (tome-entry-deletes effect-entry))))
			 (setf (tome-entry-deletes effect-entry)
			       (push (append1 (car (tome-entry-deletes effect-entry)) atnode)
			             (cdr (tome-entry-deletes effect-entry))))
			 ;else
			 (push (add-context (cons atnode (get-tome-entry-deletes effect-entry)))
			       (tome-entry-deletes effect-entry))))))
	 )
	 ;;;if we are using init-ctxt, here is when you check if the 
	 ;;;if the effect is present in init-ctxt and if so remove it and
	 ;;;put it in plan-head..
	 (if (eql type :delete)
	     ;;all (not(pat)) are specified as (pat) :delete
	     ;;there are no (not(pat)) in init-ctxt--> so modification
	     ;;needs to be done only for :delete effects....
	     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	     ;;THIS IS AN ASSUMPTION...IF WE HAVE NEGATIVE FACTS IN INIT-CTXT WE HAVE
	     ;;TO CHANGE THIS
	     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	     (modify-init-ctxt effect type)
	     ;basically, because of this we will route all conflicts
	     ;;to planhead, leaving init-ctxt untouched--{also init-ctxt
	     ;;is not present in allnodes, so for linking to work, we need
	     ;;to do this
	     )
    ))

;; This is the inverse of enter-tome. It deletes the fact from tome that the effect "effect"
;; of type "type" is caused by node "atnode"

(defun delete-tome (effect type atnode)
   (let ((effect-entry (index-tome effect)))
        (case type
              (:assert
                 (if (eql *current-context* (get-context (car (tome-entry-asserts effect-entry))))
		    (setf (tome-entry-asserts effect-entry) 
			  (push (remove-list atnode (car (tome-entry-asserts effect-entry)))
				(cdr (tome-entry-asserts effect-entry))))
		    ;else
		    (push (add-context (remove-list atnode (get-tome-entry-asserts effect-entry)))
			  (tome-entry-asserts effect-entry))))
	      (:delete
	         (if (eql *current-context* (get-context (car (tome-entry-deletes effect-entry))))
		    (setf (tome-entry-deletes effect-entry)
			  (push (remove-list atnode (car (tome-entry-deletes  effect-entry)))
				(cdr (tome-entry-deletes effect-entry))))
		    ;else
		    (push (add-context (remove-list atnode (get-tome-entry-deletes effect-entry)))
			  (tome-entry-deletes effect-entry))))
  )))

;; returns conflict nodes for the effect.  
;; if the type is :assert, the delete nodes of the tome entry
;; corresponding to effect is returned and vice-versa

(defun tome-conflicts (effect  type )
  (let ((effect-entry  (lookup-tome effect)))
        (case type
	   (:assert
     	       (return-from tome-conflicts (get-tome-entry-deletes effect-entry)))
	   (:delete
	       (return-from tome-conflicts (get-tome-entry-asserts effect-entry)))
	)
  ))

(defun get-tome-entry-asserts (entry)
   (cdar (tome-entry-asserts entry)))

(defun get-tome-entry-deletes (entry)
   (cdar (tome-entry-deletes entry)))
    
	 
        

