;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; Common Lisp NONLIN - University of Maryland at College Park 
;;;;
;;;; Version 1.2, 11/91
;;;; (email nonlin-users-request@cs.umd.edu for more info)
;;;; 
;;;; SCHEMA.LISP: Routines for selecting schemas, etc.  
;;;;
;;;; History:

;;; added DEVISOR mods - 4/91 bpk

;; Chooses one of the applicable schemas and saves the rest in the context-list
;; for backtracking purposes. Creates a new context because schema expansion is 
;; a choice point

(defun select-schema-to-expand (atnode)
    (let ((schema-instances 
	      (get-plausible-schema-instances atnode)))
	 (if (null schema-instances)
	   (then
	      (backtrack))
  	   (else
	     ;save the alternative schemas in context history
	     (let (save-entry)
	       (for (schema :in schema-instances)
		    :do
		    (setf save-entry (append1 save-entry (list atnode schema)))
	       )
	     (push (add-context (make-backtrack-entry
	  			:type :schema
				:alternatives 
				(cdr (reverse save-entry))))
			        *context-list*)
	     (create-new-context)
	     (car (reverse schema-instances))
          )))
	 
    ))

;; This returns a list of ground schemas with binding.

(defun get-plausible-schema-instances (atnode &aux results)
    
    (for (schi :in (get-applicable-schemas (node-todo atnode)))
	 :do
	 (let* ( (schema (retrieval-result-data schi)) 
		 (retrieval-binding (retrieval-result-binding schi))
		 (si (make-schema-instance schema retrieval-binding))
	       )
	       ;; Variables are substituted for only the chosen schemas
	       (setf results (append results
				     (old-construct-schema-instances si atnode)))
	 ))
    results
    ;;return a list of schemas
)

#|
;;THREW IT AWAY BECAUSE IF THE 'AND REQUEST FORCES THE Q&A TO MAKE
;;ALL THE PATTERNS BECOME TRUE FROM EITHER -2 OR -1 OR FROM TRIES TO
;;SEE FOR THE 'AND REQUEST ITSELF IN TOME 7/13/89
(DEFUN construct-schema-instances (si atnode &aux results)
  (LET ((pat (for (COND :in (schema-conditions si))
		  :when
		  (EQL (scondition-type cond) :use-when)
		  :save
		  (scondition-pattern cond)))
	;;save all conditions
	)
    (PUSH 'AND pat)
    ;;make pat a conjunctive retrieval request
    ;;WE WILL MAKE ALL THE CONDITIONS HAVE THE SAME CONTRIBUTOR
    (MULTIPLE-VALUE-BIND (result nd-bd-pairs)
	(q&a pat ATNODE :all-bindings t)
      ;;WHAT EVER THE NODE NUMBER IS WE WANT TO MAKE SURE THAT
      ;;IT WONT GET CONFLICTING CONTRIBUTORS FOR THE NODE
      (for (nd-bd :in nd-bd-pairs)
	   :do
	   (LET* ((contributors (LIST (NODE-NODENUM *INIT-CTXT*)))
		  ;;(FIRST nd-bd)
		  (binding (SECOND ND-BD))
		  ;;make sure this is right...
		  ;;and keeps the binding inthe third place
		  (new-si (make-schema-instance si binding))
		  (nconts (MAPCAR #'(lambda (x) (- x *striplen*)) contributors))
		  ;;the goodal to get numbers down
		  )
	     (for (COND :in (schema-conditions new-si))
		  :when (EQL (scondition-type cond) :use-when)
		  :do
		  (SETF (scondition-contributors cond) nconts)
		  ;;we don't differentiate between always-ctxt and init-ctxt
		  )
	     (PUSH new-si results))
	   ))
    results ;;return the results
    )
  
  )
|#


;;si is a schema instance which is bound by establishing its :use-when conditions

(defun old-construct-schema-instances (si atnode)
    (let ((rec-result (recursive-propagate-usewhen-bindings si atnode 0
			 (1- (length (schema-conditions si )))
			 ;;basically we have to recurse with an upper bound
			 ;; of the # of conds (we will use nth, so 1- & 0)
		     )))
	     ;;will contains nil
	  (for (res :in rec-result) :when (not (null res))
	       :save res)
	  ;;returns the resultant schemas without the null values.
	 ))
    


;; this function binds the variables by recursively binding each 
;; :use-when and :use-only-for-query condition. It calls Q&A to get
;; all possible bindings that make the :use-when and :use-only-for-query
;; conditions true. For :use-only-for-query conditions it also saves the
;; bindings in the condition for rebinding at a later stage

(defun recursive-propagate-usewhen-bindings  (si atnode ind length)
    (if (> ind length)
	;;index should not be greater than number of conditions
	(return-from recursive-propagate-usewhen-bindings (list si)))
    ;;return si itself... each time we return a list
    (let ((cond (nth ind (schema-conditions si)))   )
	 (if (or (eql (scondition-type cond) :use-when)
		 (eql (scondition-type cond) :use-only-for-query))
	     (then
		  (multiple-value-bind (result nd-bd-pairs)
		      (Q&A (scondition-pattern cond) (node-nodenum atnode)
			   :all-bindings t)
		      ;;we are going to ask for all BINDINGS..
		      (if (not result)
			  (then ;;then this schema with this binding fails
				;;just return nil
				nil)
			  (else-let (results)
			    (if nd-bd-pairs
			      (then	
			      (for (nd-bd :in nd-bd-pairs)
				   :do
				   (let* ((contributors  (first nd-bd))
					  (binding (second nd-bd))
					  (new-si (make-schema-instance si 
						      binding))
					  (new-cond (nth ind (schema-conditions 
								 new-si)))
					 )
				         (if (eql (scondition-type new-cond) :use-only-for-query)
					    (push (add-context binding) (scondition-binding new-cond))) 
					 (for (ncont :in 
						     (mapcar #'(lambda (x) (- x *striplen*))
							     contributors))
					      :do (push ncont (scondition-contributors 
								  new-cond)))
					 (setf results (append results
							       (recursive-propagate-usewhen-bindings
								   new-si atnode (1+ ind) length)))
				   ))
			      results
			      ;;return results
			  )
			  (else
		  		(recursive-propagate-usewhen-bindings si atnode (1+ ind) length)))
		       )
		   )))
	     (else
		  ;;it is not a use-when condition, just skip
		  ;;over it by increasing the index and recursing
		  (recursive-propagate-usewhen-bindings si atnode (1+ ind) length))
	 )
    ))


(defun GET-APPLICABLE-SCHEMAS (pattern)    
    (let* ((relevant-schemas (get-relevant-schemas pattern)))
	  (retrieve pattern :from-data-list relevant-schemas
	      :key-function 'schema-todo :with-pat t))
)


(defmacro destructive-replace-variables (place binding)
    `(setf ,place (replace-variables ,place ,binding))
    ; ; replace-variables comes from unify routines
)
    
;;      1. make a copy of the schema 
;;      2. substitute the binding list into the body of the copy
;;      return the copy

(defun make-schema-instance (schema binding)
    
    (let ((si (my-copy-schema schema)))
	 (propagate-binding si binding)
	 
    ))


;; propagate the binding to all parts of the schema

(defun propagate-binding (si binding)
    (destructive-replace-variables (schema-todo si) binding)	 
    (for (cond :in (schema-conditions si))
	 :do
	 (destructive-replace-variables (scondition-pattern cond) binding))
    (for (effect :in (schema-effects si))
	 :do
	 (destructive-replace-variables (seffect-pattern effect) binding))
    (do ((index 0 (+ index 1)))
	((> index (- (schema-size si) 1)))
	(let ((expnode  (aref (schema-strip si) index)))
	     (destructive-replace-variables (node-todo expnode) binding)))
    ;;; At this point, all the variable dependent patterns are
    ;;; replaced in si...
    
    (setf (schema-vars si) binding) ;; ???
    si ;return si
)

#|
(defun propagate-mapping (si mapping)
    ;;propagate a variable binding to all parts of the schema instance
    (dmap-objects (schema-todo si) mapping)
    (for (cond :in (schema-conditions si))
	 :do
	 (dmap-objects (scondition-pattern cond) mapping))
    (for (effect :in (schema-effects si))
	 :do
	 (dmap-objects (seffect-pattern effect) mapping))
    (do ((index 0 (+ index 1)))
	((> index (- (schema-size si) 1)))
	(let ((expnode  (aref (schema-strip si) index)))
	     (dmap-objects (node-todo expnode) mapping)))
    
    ;; SUBSTITUTE VARIABLES???**this has to be taken care of****
    (dmap-objects (schema-vars si) mapping) ;; ???
    si ;return si
)
|#

;; makes a copy of the schema sch

(defun my-copy-schema (sch)
    (let ((copy-name (gensym (symbol-name (schema-name sch))))
	  (copy-todo ;;(uniquify-variables (schema-todo sch))
	    ;;can't use uniquify stuff.  all the same variables should be mapped
	    ;;onto same variables... (not even that is necessary)
	    ;;pcvar by themselves are useless without a separate binding list...
	    (schema-todo sch))
	  (copy-size (schema-size sch))
	  (copy-conditions (for (scond :in (schema-conditions sch))
				:save
				(my-copy-scondition scond)))
	  (copy-effects (for (seff :in (schema-effects sch))
			     :save 
			     (my-copy-seffect seff)))
	  (copy-vars ;(uniquify-variables (schema-vars sch))
	    (schema-vars sch))
	  (copy-strip (my-copy-strip (schema-strip sch) (schema-size sch)))
  	  ;; DEVISOR mods:
          (copy-duration (schema-duration sch))
          (copy-swindow (copy-window (schema-window sch)))
	 )
	 (make-schema :name copy-name
	     :todo copy-todo
	     :size copy-size
	     :strip copy-strip
	     :size copy-size
	     :effects copy-effects
	     :conditions copy-conditions
	     :vars copy-vars
             :window copy-swindow
             :duration copy-duration) ; DEVISOR mods
    ))
    

(defun my-copy-scondition (scond)
    (let ((scond-cpy (copy-scondition scond)))
;;	 (setf (scondition-pattern scond-cpy)
	;;       (uniquify-variables (scondition-pattern scond-cpy)))
	 scond-cpy
    ))
    
;; makes a copy of the effect seff

(defun my-copy-seffect (seff)
    (let ((seff-cpy (copy-seffect seff)))
	;; (setf (seffect-pattern seff-cpy)
	  ;;     (uniquify-variables (seffect-pattern seff-cpy)))
	 seff-cpy
    ))
	 
;; makes a copy of the strip (allnodes) "strip"

(defun my-copy-strip (strip size)
    (let ((strip-cpy (make-array (list size))))
	 (do ((index 0 (+ index 1)))
	     ((> index (- size 1)))
	     (setf (aref strip-cpy index)
		   (my-copy-node (aref strip index)))
	 )
	 strip-cpy
	 ))
    
;; makes a copy of the node "node"

(defun my-copy-node (node)
    (let ((node-cpy (copy-node node)))
	 ;;(setf (node-todo node-cpy)
	   ;;    (uniquify-variables (node-todo node-cpy)))
       (setf (snode-id node-cpy) (gensym "ND"))
       ; DEVISOR mod
       (setf (snode-window node-cpy) (copy-window (snode-window node)))
       node-cpy)
)
