;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; Common Lisp NONLIN - University of Maryland at College Park 
;;;;
;;;; Version 1.2, 11/91
;;;; (email nonlin-users-request@cs.umd.edu for more info)
;;;; 
;;;; READSCHEMA.LISP:  Process operator and plan schemas  
;;;;
;;;; History:
;;;; 09/22/91 bpk - added support to store goal specification in *goals*


(defvar *autocond* t "switch to fill in goal conditions and effects")
(defvar *planschema* nil "the schema which stores the plan statement")
(defun autocond-p () 
    *autocond*)    
(defparameter *schematable* (make-hash-table)
 "the global table of schemas hashed under predicates")

(defun reset-schematable ()
   (setf *schematable* (make-hash-table))
)
    
(defun dump-schematable ()
    (format t "~%The contents of the Schema Table are...~%~%")
    (maphash #'(lambda (key schemas) 
		       (declare (ignore key)) 
		       (for (schema :in schemas)
			    :do (format t "~%-------------------------------------------~%")
			    (print-schema schema)
		       ))
	*schematable*)
    (format t "~%=================================================")
)
    
;; retrieves all schemas whose predicate match the predicate in the pattern
(defmacro get-relevant-schemas (pattern)
    `(gethash (predicate ,pattern) *schematable*))

;; enters a schama "schema" into the schema table in the hashed bucket
(defmacro  enter-schema-table (schema)
    `(push ,schema (gethash (predicate (schema-todo ,schema)) *schematable*)
     )
)
;; reads an opschema into the schama table
(defmacro opschema (name &rest body)
    `(apply 'readschema ',name ',body))
    
;; reads an actschema into the schama table
(defmacro actschema (name &rest body)
    `(apply 'readschema  ',name ',body))

;;;plan schema template will be (plan {<goalname> :goal <goal pat>}*)
				     				      
(defmacro plan (name &rest goal-specs)
    `(progn (setf *planschema* 
	   (readschema ',name :todo 'plan :dont-enter t :expansion ',goal-specs))
    ;;it is ,body not ,@body so that list will be there
    ;;no variables will be supplied, so that no substitution
    ;;will take place
            (setf *goals* ',goal-specs))
)
    
(defun readschema (name &rest body &key variables &allow-other-keys)
    (let ((new-body body))
	 (for (pcvar :in variables)
	      :do (setf new-body 
			(pcvar-subst (pcvar-id pcvar) 
			    (make-pcvar :id (gensym (symbol-name (pcvar-id pcvar))))
			    new-body)))
;;;if you want to change the id only, then send just gensym and in
;;;pcvar-subst just change the id, of any pcvar with substitutable id

	 ;; finally the new-body is pcvar substituted by gensymmed stuff
	 
	 
	 ;;;Basically to escape the argument evaluation    
	 (apply #'readschemafn name new-body)
))
        
;; builds the schema and enters it into the schema table unless dont-enter is
;; set to true. 
(defun readschemafn (name &rest body &key todo expansion 
			  orderings variables conditions effects
                          duration window
			  dont-enter)
    (multiple-value-bind (strip size expan-trans-list mod-conditions
				mod-effects)
	(make-strip orderings expansion conditions effects 
           window duration) ; DEVISOR mod
	(let ((sconditions (get-sconditions mod-conditions expan-trans-list))
	      (seffects (get-seffects mod-effects expan-trans-list))
              (window (create-window window)) ; DEVISOR mod
              (duration (init-duration duration))        
	      schema)
	     (setf schema (make-schema :name name
			      :todo todo :strip strip :size size
			      :conditions sconditions 
			      :effects seffects :vars variables
                              :duration duration :window window)) ;DEVISOR mod
	     (unless dont-enter (enter-schema-table schema))
	    (return-from readschemafn schema)
	    ))
    
)

	      
;; makes a strip like allnodes array containg the nodes in the
;; expansion. Note that the expansion of a node is itself a small 
;; partially ordered network

(defun make-strip (orderings expansion conditions effects swindow sduration)
    (let* ((window (create-window swindow))      ; DEVISOR mods
           (duration (init-duration sduration))
           (pretable (make-hash-table))
	   (succtable (make-hash-table))
	   (expsteps (for (exp-spec :in expansion) 
			  :save (car exp-spec)))
	   ;; expsteps contains step names/numbers of the expansion
	   begstep-s endstep-s
	   (strip (make-array (list (+ (length expsteps) 2))))
	   ;; atmost two dummy nodes!
	   (stripsize 0)
	   (mod-conditions conditions)
	   (mod-effects effects)
	   expan-trans-list
	   
	  )
	  ; update the pretable and succtable for each entry in orderings
	  (for (order :in orderings)
	       ;;;orderings are  (a -> b) 
	       :do (let ((n1 (first order))
			 (ord (second order))
			 (n2 (third order)))
			(cond ( (eq ord '->)
				(push n1 (gethash n2 pretable))
				(push n2 (gethash n1 succtable)))
			      ((eq ord '<-)
			       (push n2 (gethash n1 pretable))
			       (push n1 (gethash n2 succtable)))
			      (t 
				 (error
				       "unknown ordering relation in schema ~s"
				       ord)))))
	  (for (n :in expsteps)
	       :do 
	       (if (null(gethash n pretable))
		   ;; there are no predecessors for this step
		   (push n begstep-s))
	       (if (null (gethash n succtable))
		   (push n endstep-s)))
	  ;;;Now, we make dumnodes if required	  
	  (if (> (length begstep-s) 1)
	      ;;if there are more than one beginning nodes
	      (then
		   (push `(beg-exp :dummy) expansion)
		   (setf  (gethash 'beg-exp succtable)  begstep-s)
		   (for (node :in begstep-s)
			:do (push 'beg-exp (gethash node pretable)))))
	  (if (> (length endstep-s) 1)
	      (then
		   (setf expansion 
			 (append expansion '((end-exp :dummy))))
		   (setf  (gethash 'end-exp pretable)  endstep-s)
		   (for (node :in endstep-s)
			:do (push 'end-exp (gethash node succtable)))))
	  
	  ;;;now expansion contains all the nodes required, including dummy nodes
	  ;;construction expan-trans-list    
	  (setf expan-trans-list
		(let ((count 0))
		     (for (expentry :in expansion)
			  :save (prog1 (list (first expentry) count)
				       (setf count (+ count 1))))))
	  ;;;putting in the strip
	  (setf stripsize (length expansion))
	  (setf strip (make-array (list stripsize)))
	  (for (expentry :in expansion)
	       :do (let ((nodenum (translate (first expentry)
				      expan-trans-list))
			 (prenodes (translate (gethash (first expentry) pretable)
				       expan-trans-list))
			 (succnodes (translate (gethash (first expentry) succtable)
					expan-trans-list))
			 (type (second expentry))
			 (pattern (third expentry))
			 newnode)
			(setf newnode (make-node :type type :todo pattern
					  :nodenum nodenum
					  :prenodes prenodes 
                                          :succnodes succnodes
                                          :window (copy-window window)
                                          :duration duration)) ; DEVISOR mod
			(setf (aref strip nodenum) newnode)
		   ))
	  	  ;;;add auto conditions and effects and take care of dummy
	  ;;;fill in
	  (if (autocond-p)
	      (for (exp-spec :in expansion)
		   :when (eql (second exp-spec) :goal)
		   :do
		   (let* ((stepname (first exp-spec))
			 (goalpat (third exp-spec))
			 eff-template cond-template
			 (cond-atstep (car(gethash stepname succtable)))
			)

			(setf eff-template 
			      `(,stepname :assert ,goalpat))
			(unless (find eff-template mod-effects :test #'equal)
				(push eff-template mod-effects))
;;;			(setf cond-template 
;;;			      (find goal-pat 
;;;				    (for (cond :in mod-conditions)
;;;					 :when (member stepname cond)
;;;					 :save cond)
;;;				    :key #'second
;;;				    :test #'equal))
			;;this is to check if there is already such a 
			;;condition template
			(if (null cond-template)
			    ;;if no such template exists already
			    (push `(:precond ,goalpat :at ,cond-atstep
				       :from ,stepname) mod-conditions)
			)))
	      )
			
			 

	  ;;;now, return strip, stripsize, expan-trans-list
	  (return-from make-strip 
	      (values strip stripsize expan-trans-list 
		      mod-conditions mod-effects))
    ))

			          
    
(defun translate (item-or-list assoclist)
    (if (listp item-or-list)
	(for (item :in item-or-list)
	     :save (translate item assoclist))
	(second (assoc item-or-list assoclist))))

(defun get-sconditions (conditions expan-trans-list)
    (for (cond-spec :in conditions)
	 ;; cond-spec is expected to be of the form
	 ;; (type pattern {:at step} {:from step})
	 :save
	 (let ((type (car cond-spec))
	       (pattern (cadr cond-spec))
	       (atstep (getf (cddr cond-spec) :at))
	       atnode cont-nodes
	       (contributor-s (getf (cddr cond-spec) :from)))
	      (unless (listp contributor-s)
		      (setf contributor-s (list contributor-s)))
	      (if (and (not (autocond-p))(null atstep))
	      ;; this occurs when the expansion has more than one
	      ;; end point as during the initial read-in
	      ;;if autocond is on this would have been done at the
	      ;;make-strip itself
		  (setf atstep 'end-exp))
	      (setf atnode (translate atstep expan-trans-list))
	      (setf cont-nodes (for (cstep :in contributor-s)
				    :save (translate cstep
					      expan-trans-list)))
	      (make-scondition :atnode atnode :type type
		  :contributors cont-nodes :pattern pattern)
	 ))
    
)

;; Reads effects
(defun get-seffects (effects expan-trans-list)
  (for (effect-spec :in effects)
       :save
       (let ((atstep (first effect-spec))
	     (type (second effect-spec))
	     (pattern (third effect-spec))
	     
	     atnode)
	 (setf atnode (translate atstep expan-trans-list))
	 (make-seffect :type type :atnode atnode 
		       :pattern pattern)
	 
	 ))
  )	      
	             
