;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; Common Lisp NONLIN - University of Maryland at College Park 
;;;;
;;;; Version 1.1, 4/91
;;;; (email nonlin-users-request@cs.umd.edu for more info)
;;;; 
;;;; PRINTPLAN.LISP:  Outputs the complete plan
;;;;
;;;; History:
;;;; 09/22/91 bpk - fixed bug in TOPSORT, GET-PLAN
;;;; 09/13/91 bpk - added support for storing planner output in *planner-out*

(defvar *plan-list* nil "contains the plan")
(defvar *plan-nodes* nil "the plan copy of allnodes")
    
(defun reset-plan-list ()
    (setf *plan-list* nil))
    
;; does a topological sort of the network to get a linear plan

(defun get-plan ()
    (let ((dummynode (make-node :type :plantail)))
    ;this dummy node will be added to *planlist* for proper
    ;termination of the print routine
    (if *plan-list* (return-from get-plan *plan-list*))
         (unmark-allnodes)
	 (topsort *planhead*)
	 ;;topsort sets the *plan-list*
	 (setf *plan-list* (append1 *plan-list* dummynode))
	 ;;add the dummynode to the end of the plan list
;	 (setf (node-type (car (last *plan-list*)))
;	       :plantail)
	 ;;this is so that goal state will be printed properly
	 ;;wont work if there was no dummy node in the plan schema expansion
	 ;;for stopgap it is ok
	 *plan-list* ;;finally return plan-list
    )
)

(defun get-ground-plan ()
    ;;returns only the nodes that get printed
    ;;--phantoms and dummys are supressed
    (for (node :in (get-plan))
	 :filter (if (member (node-type node) 
                    '(:planhead :plantail :primitive :event))
		     node)
    ))
         
    

;;;the following algorithm is from hopcroft&ullman&aho datastructures book
;;;works for DAG's

(defun topsort (node)
    ;;it works because :visited was not used as a mark before
    (when (not (node-p node)) (setf node (allnodes node))) ; make sure node is a structure
    (setf (node-mark node) :visited)
    (for (snode :in (get-succnodes node))
	 :do
         (when (not (node-p snode))         ; make sure snode is a structure
             (setf snode (allnodes snode))) ; added this to fix bug - bpk
	 (if (not (eql (node-mark snode) :visited))
              (topsort snode)))
              (push node *plan-list*) 
	     ;;because we are using push, the reverse order becomes actual order
	     ;;at the end.........
    )
	     

(defun print-plan (&key (with-cond nil)(with-eff nil))
    (let* ((plan (get-plan)) 
           nodetag
	  )

          (when *devisor-mods*              ; DEVISOR mod
             ;; select actual (ideal) start time for each node 
             ;;   with a time window 
             (determine-ideal-start-times))

	  (format t "~& The plan is...")
	  (for (node :in plan)
	       :do
	       (case (node-type node)
		     (:phantom )
		     (:dummy )
		     (:plantail
			 (format t "~%~%***********GOAL STATE***************")
			 (for (scond :in (find-conditions node))
			      :do (format t "~&~25T ~s" scond)))
		     (:planhead
			 (format t "~%~%***********INITIAL STATE************")
			 (for (pattern :in (append (node-ctxt *init-ctxt*)
						   (node-ctxt *planhead*)
						   (node-ctxt *always-ctxt*)))
			      :do
			      (format t "~&~s~%" pattern))
			 (for (scond :in (append (find-uses node)
						 (find-uses 
						     (node-nodenum 
							 *init-ctxt*))
						 (find-uses 
						     (node-nodenum
							 *always-ctxt*))))
			      :do (format t "~&~15T ~s" scond))
                         (when *devisor-mods*  ; DEVISOR mods
                            (format t "~& Planning begins at *time0* = ~s"
                               *time0*)
                            (format t "~& (Time *infinity* = ~s)"
                               *infinity*))
			 (format t "~%***************************************"))
		     
		     ((:primitive :goal :action :event) 
		      (unless (null with-cond)
			      (format t "~%~10TAPPLICABILITY CONDITIONS")
			      (for (scond :in (find-conditions node))
				   :do (format t "~&~15T ~s" scond)))
		     
                      (if (equal (node-type node) :event)
                         (setf nodetag (node-eventname node))
                      ; else
                         (setf nodetag (node-todo node)))
                              
		      (format t "~& ~% ~s: ~s ~s ~40T[Prenodes:~s]~%"
   		         (node-nodenum node) (node-type node)
			 nodetag (get-prenodes node))                     
                      (format t "~& ~40T[Succnodes:~s] ~%"
                         (get-succnodes node))
                       
                      (setf *planner-out* ; save the actions comprising the plan
                          (append *planner-out* 
                             (list (list 
                                (snode-id node) (node-type node) (node-todo node)))))

                      (when *devisor-mods* ; DEVISOR mods
                      (format t "~& ~40T[Start Time: ~s] ~60T[Duration: ~s] ~%"
                         (window-ist (node-window node)) (node-duration node)))
		      (unless (null with-eff)
			      (format t "~%~20TGOALS--EFFECTS")
			      (for (scond :in (find-uses node))
				   :do (format t "~&~25T ~s" scond)))
		      
		      (if (or with-eff with-cond)
			  (format t "~&~10T***************************************"))
		     )

    	       ))
         
    ) nil )
    
(defun  find-conditions (node &aux node-conditions)
    ;;finds the applicability conditions and their justifications from GOST
    (for (gost-entry :in (all-gost-entrys))
	 :do
	 (let ((scond-pat (gost-entry-condition gost-entry)))

	      (for (gentry :in (gost-entry-pluses gost-entry))
		   :when (eql (gentry-node gentry) node)
		   :do (push (make-scondition :type (gentry-type gentry)
				 :pattern scond-pat
				 :atnode node
				 :contributors (get-gentry-contributors gentry))
			     node-conditions))
	      (for (gentry :in  (gost-entry-minuses gost-entry))
		   :when (eql (gentry-node gentry) node)
		   :do (push (make-scondition :type (gentry-type gentry)
				 :pattern (negate-pat scond-pat)
				 :atnode node
				 :contributors (get-gentry-contributors gentry))
			     node-conditions))

	 ))
    node-conditions
    
    )

(defun find-uses (node &aux node-uses)
    (for (gost-entry :in (all-gost-entrys))
	 :do
	 (let ((scond-pat (gost-entry-condition gost-entry)))

	      (for (gentry :in (gost-entry-pluses gost-entry))
		   :when (and (member node (get-gentry-contributors gentry))
			      (member (node-type (gentry-node gentry))
				      ;;WHY SHOULD WE EXCLUDE PHANTOM??
				      ;;THEY ARE ALSO USES
				       '(:primitive :action :goal :phantom :plantail))
			 )

		   :do (push (make-scondition :pattern scond-pat
				 :atnode (gentry-node gentry)
				 :contributors (list node))
			     node-uses))
	      (for (gentry :in (gost-entry-minuses gost-entry))
		   :when (and (member node (get-gentry-contributors gentry))
			      (member (node-type (gentry-node gentry))
				       '(:primitive :action :goal :plantail :phantom)))
	      
		   :do (push (make-scondition :pattern (negate-pat scond-pat)
				 :atnode (gentry-node gentry)
				 :contributors (list node))
			     node-uses))
	 ))
    node-uses
)

;;take out the contributors that do not figure in plan.  
;;print without the condition id..        
;;TAKE CARE OF CONDITION TYPES--ALL SHOULD NOT BE :USE-WHEN'S

(defun find-effects (node &aux node-effs)
    (for (tome-entry :in (all-tome-entrys))
	 :do
	 (if (member node (tome-entry-asserts tome-entry))
	     (push (make-seffect :pattern (tome-entry-effect tome-entry)
		       :type :assert
		       :atnode node)
		   node-effs))
	 (if (member node (tome-entry-deletes tome-entry))
	     (push (make-seffect :pattern (tome-entry-effect tome-entry)
		       :type :delete
		       :atnode node)
		   node-effs))
    ) 
    node-effs)
	     

(defun unmark-allnodes ()
;;; this makes sure that all mark flags are reset prior to doing topological sort
;;; of the planlist
  (do ((index 0 (1+ index)))
      ((> index (1- *striplen*)))
      (if (not (null (aref *allnodes* index)))
        (then
          (setf (node-mark (cdar (aref *allnodes* index)))  'unvisited)
        )))
)
