;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; Common Lisp NONLIN - University of Maryland at College Park 
;;;;
;;;; Version 1.2, 11/91
;;;; (email nonlin-users-request@cs.umd.edu for more info)
;;;; 
;;;; PLAN.LISP:  Basic Planner Cycle
;;;;
;;;; History:
;;;; 10/04/91 bpk - added support for optional limit on number of execution cycles
;;;; 09/13/91 bpk - added support for saving planner input and output in globals
;;;;                *planner-in* and *planner-out*
       
(defun plan-for ( &key (problem nil) (interactive t) (reuse nil) (reusing nil))
    (unless problem
	    ;;if problem is not set
	    ;;get the problem
	    ;;This is interactive session
	    (setq problem (get-problem))
    )

    (reset-context)
    (reset-datastructures)
    (let (plannode)
	 (funcall problem)
	 ;;get-problem sets init-ctxt and plan schema    
	 (setf *planhead* (make-node :type :planhead
            :window (create-window (list 'at *time0*))))  ; DEVISOR mod
	 (set-allnodes *planhead*)
		 
	 (setf plannode (make-node :type :plan))
	 (set-allnodes plannode)
		 
	 (make-succnode plannode *planhead*)
         (make-prenode  *planhead* plannode)

         ;; DEVISOR mods:
         ;; enter scheduled events into network
         (when *devisor-mods*
            (format t "Calling STORE-EVENTS...")
            (store-events)
         )
         
	 (enter-taskqueue plannode)

	 ;;the initial network is constructed
	 (format t "~& The world state is ~s" (node-ctxt *init-ctxt*))
	 (format t "~& ~% the problem to be solved is~%")
	 (print-schema *planschema*)

         (setf *planner-in* 
            (list (node-ctxt *init-ctxt*) (node-ctxt *always-ctxt*) *goals*))
		 
	 (bplanner) ;call the backtracking planner
     )
)
            
;; top level control structure of NONLIN. Picks up a task(node) from the taskqueue
;; and expands it, until the taskqueue becomes empty.
;; After the taskqueue is empty, it attempts to establish any :unsuperv
;; conditions.

(defun planner ()
  (do ((nexp (pick-taskqueue) (pick-taskqueue)))
      ((null nexp) (establish-unsupervised-conds) (end-planning))
      ;;when this loop is exited, the plan is ready


    (if (and (debug-p)(not (member (node-type nexp) '(:plan :planhead :dummy))))
      (format t "~&expanding ~s ~s ~s (Purpose ~s)" (node-nodenum nexp) (node-type nexp)
			    (node-todo nexp) (purpose-nodes (node-nodenum nexp) (node-todo nexp))))
	
	(mark nexp) ;; mark the tasknet wrt nexp node

	;; identifying each tasknet node "before",
	;; "after"  "parallel" and "node"
        (reset-plan-list) ;;reset the partial plan list	
	(case (node-type nexp) ;; the big case statement for each types of node
	      
	      (:plan
		    ;; this will be used for expanding the
		    ;; initial goal. {which will possibly
		    ;; be in conjunctive form}
		    (plan-node-expand nexp))		
                    (step nil)
	      
	      (:goal  	;; the node type is "goal"
		  (goal-node-expand nexp)
	      )
	      (:phantom
		  (phantom-node-expand nexp))
	      (:action
		      (action-node-expand nexp))  
	      ;; end of action analysis
	      
	      (:dummy
		     nil    ;;do nothing
	      )
	      (:planhead
		  nil   ;;do nothing
		  )		  
              (:event 
                  nil)
	) ;; this ends the big case!!!
;       (if (debug-p)
 	(if (and (debug-p) (not(member (node-type nexp) '(:dummy :plan :planhead))))
	    (progn (format t "~&after the expansion ..~%")
		   (if (or (eq (debug-p) t)
			   (member 'allnodes (debug-p)))
		       (print-allnodes))
		   (if (or (eq (debug-p) t)
			   (member 'gost (debug-p)))
			   (print-gost))
		   (if (or (eq (debug-p) t)
			   (member 'tome (debug-p)))
		       (print-tome))
		   (if (or (eq (debug-p) t)
			   (member 'plan (debug-p)))
		       (print-plan))
		   (if (or (eq (debug-p) t)
			   (member 'taskqueue (debug-p)))
		    (then
		      (format t "~&the remaining task-queue is")
		      (print-taskqueue)))
		   ))

    (setf *cycle-count* (+ *cycle-count* 1))
    (when (and *cycle-limit-p* (>= *cycle-count* *cycle-limit*)) (return))

    )				;; this ends the loop
    
    
    
    
) 	;; ends planner

;;; Fix #1: lets NONLIN handle conditions of type :unsuper (unsupervised).
;;; B.Kettler 2/6/91

(defun establish-unsupervised-conds ()
   ;;; (After taskqueue is empty,) try to establish all unsupervised
   ;;; conditions in the GOST.  (called by fn planner)
;   (print-allnodes)
;   (print-gost)
;   (print-tome)
   
   (format t "~% Attempting to establish any unsupervised conditions...~%")

   ;; process all conditions of type :unsuperv in GOST 
   (for (gost-entry :in (all-gost-entrys))
      :do
         (for (gentry :in (gost-entry-pluses gost-entry))
            :do
               ;; if condition is of type :unsuperv then establish it
               (if (equal (gentry-type gentry) :unsuperv)
                  (then 
                     ; condition "condition" must be established at
                     ; node "node" with node number = "atnode"
                     (let* ((atnode (get-gentry-node gentry))
                           (node (allnodes atnode))
                           (condition (gost-entry-condition gost-entry)))
;                        (format t "Trying to establish cond ~s.~%"
;                           condition)

                        ; mark the net wrt atnode so that q&a will work 
                        (mark node)

                        ; try to establish condition
                        (multiple-value-bind (result contributors)
                           (try-to-establish condition atnode)

                           ;; if condition was established, update its
                           ;; GOST entry (i.e. add new contributor(s))
                           (if result
                              (then 
;                                 (format t 
;                                    ":unsuperv ~s established by ~s at ~s~%" 
;                                    condition contributors atnode)

                                 (enter-gost condition :unsuperv
                                              atnode contributors)
                              ) 
                              (else ; failed to establish condition
                                 (format t
                               "Cannot establish ~s at ~s. Backtracking...~%"
                                    condition atnode)

                                 ; cannot establish condition so backtrack
                                 (backtrack)
                              ))))
                  ))))       
   (format t "Done establishing any unsupervised conditions.~%")
)
;;; end - Fix #1 mods

    
(defun end-planning ()
    (format t "~& ****The Planning is OVER****")

    (print-plan)
    (gensym 1)
    (if (debug-p)
	(then
	     (format t "~& The datastructures are")
	     (print-allnodes)
	     (print-gost)
	     (print-tome))
    )
)


(defun plan-node-expand (nexp)    
    (setf (snode-expanded nexp) *current-context*)
    (expand-node-using-schema-instance *planschema* nexp)
)


(defun goal-node-expand (nexp)    
    ;; first check if the goal can be made a phantom by calling tru-to-establish
     (multiple-value-bind ( result contributors)
	(try-to-establish  (node-todo nexp)  (node-nodenum nexp))
	(if result	;; if the goal is established...
	    
	    (then				    
		(let ((nchild (my-copy-node nexp)))
		  (setf (node-type nchild) :phantom)
		  (make-child nchild nexp)
		     (set-allnodes nchild (node-nodenum nexp))
		     ;; nchild replaces nexp in the allnodes array
		     ;; phantom node is not entered into taskqueue
		     ;; the contributors making it phantom are 
		     ;; entered into gost
		     (enter-gost  (node-todo nchild) :phantom
			  (node-nodenum nchild) contributors)
		   #|  (if (member (node-nodenum *init-ctxt*) contributors)
			 ;;if the establishment is from init-ctxt
			 (enter-tome (node-todo nchild) :assert (node-nodenum *init-ctxt*))
			 ;;enter that effect of init-ctxt into tome
			 ) |#
;                  (modify-start-times contributors nchild) 
		)
	    )  
	    (else 	;; if establishment is not possible
		;; then we need to expand this goal using
		;; schemas
		(let* ((chosen-way (select-schema-to-expand nexp)))
		      (if chosen-way
		        (expand-node-using-schema-instance
			  chosen-way
			  nexp))
		      ;; this completes the analysis for the "goal" type node
		)))
    ))
	
;;;shouldn't be called--the type would have been changed
    ;;;to :goal by the linking procedure itself..
;;;;NOT USED
(defun phantom-node-expand (nexp)
    ;; phantom nodes are entered into the task queue
    ;; by the linking procedure as a part of creative
    ;; destruction
    (multiple-value-bind  (already-true result)
	(q&a (node-todo nexp) nexp)
	(if already-true 
	    ; result contains contributors, update
	    ; gost
	    (enter-gost  (node-todo nexp)
		:phantom nexp result)
	;else change the node type and put the node back on the
	; task queue
	
	(else
	       (setf (node-type nexp) :goal)
	       (enter-taskqueue nexp :first)
	       ; put nexp in the beginning of the task queue
	       ; so that it will be considered in the next iteration
	))))
    
;; non primitive action nodes always get expanded by schemas

(defun action-node-expand (nexp)
    
    (let* ((chosen-way (select-schema-to-expand nexp)))
          (if chosen-way
	  
	    (expand-node-using-schema-instance chosen-way nexp))
	    ; at this point, chosen-way will also have bindings
	    ; schema steps in terms of  expanded node numbers 
    ))

