;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; Common Lisp NONLIN - University of Maryland at College Park 
;;;;
;;;; Version 1.2, 11/91
;;;; (email nonlin-users-request@cs.umd.edu for more info)
;;;; 
;;;; MARK.LISP: Routines for marking the network nodes. 
;;;;
;;;; History:


;; this function marks the whole network i.e. every node with respect to the 
;; node 'mnode' as before, after or parallel( note that these are the only 
;; three possibilities. It does that by first marking every node as :parallel.
;; Then it marks every successor node as :after and every predecessor node as
;; :before.
    
(defun mark (mnode)
    ;; propagate :parallel mark  to
    ;; all the nodes in the network
    (setf *netmarked* mnode)
    (setf (node-mark *planhead*) :before)
    (propagate-parallel *planhead*)
    
	;; propagate :after label to cnodes successors
	;; and their successors
	(propagate-after mnode)	
	;; propagate :before labels for cnodes predecessors
	;; and their predecessors
	(propagate-before mnode)

	(setf (node-mark mnode) :node)
	;;the node and its parent nodes get the mark node	
    
)
    
(defun propagate-parallel (node)
    ;; only this has to be changed if the plan is not in the tasknet form
    (setf (node-mark node) :parallel)
    (for (chnode :in (get-succnodes node))
	 :do
	 (propagate-parallel chnode)))
    
(defun propagate-after (node)
    (setf (node-mark node) :after)
    ;; mark the node :after
    (for (snode :in (get-succnodes node))
	 ;; and propagate :after mark to all the successors
	 ;; of the node
	 :do
	 (propagate-after snode)))    

(defun propagate-before (node)
    (setf (node-mark node) :before)
    (for (pnode :in (get-prenodes node))
	 :do
	 (propagate-before pnode)))


(defun get-succnodes (node)
  (cdar (node-succnodes node)))

(defun get-prenodes (node)
  (cdar (node-prenodes node)))
