;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; Common Lisp NONLIN - University of Maryland at College Park 
;;;;
;;;; Version 1.2, 2/92
;;;; (email nonlin-users-request@cs.umd.edu for more info)
;;;; 
;;;; INIT.LISP/INIT.LSP:  Routines to load planner files.
;;;;
;;;; History:
;;;; 02/25/92 - Removed machine-specific load conditionals
;;;; 02/05/92 - Version 1.2
;;;; 04/91    - Version 1.1
;;;; 01/91    - Version 1.0

;;;; *** NOTE ***
;;;; Replace all occurrences of "/g/joe-user" below with the path
;;;; specification for the directory containing the subdirectory "Nonlin"

(format t "~% --------------------------------------")
(format t "~% Common Lisp NONLIN Implementation V1.2")
(format t "~% Department of Computer Science")
(format t "~% University of Maryland at College Park")
(format t "~% --------------------------------------")
(format t "~% (load-l) loads source files")
(format t "~% (load-o) loads object files")
(format t "~% (compile-o) compiles source files")
(format t "~% Invoke (plan-for ...) to run planner.")
(format t "~% See the User Manual for more details.")
(format t "~% --------------------------------------")

(defvar *planner-files* nil)

;;; LIST OF NONLIN SOURCE FILES
(setq *planner-files*  '("/g/joe-user/Nonlin/util.lisp"  
			 "/g/joe-user/Nonlin/def.lisp" 
			 "/g/joe-user/Nonlin/dev.lisp"  
			 "/g/joe-user/Nonlin/unify.lisp" 
			 "/g/joe-user/Nonlin/readschema.lisp"
			 "/g/joe-user/Nonlin/tome.lisp"
                         "/g/joe-user/Nonlin/gost.lisp"
			 "/g/joe-user/Nonlin/schema.lisp" 
                         "/g/joe-user/Nonlin/link.lisp"
			 "/g/joe-user/Nonlin/plan.lisp" 
                         "/g/joe-user/Nonlin/expand.lisp"
			 "/g/joe-user/Nonlin/establish.lisp" 
                         "/g/joe-user/Nonlin/init-planner.lisp"
			 "/g/joe-user/Nonlin/init-always.lisp"
                         "/g/joe-user/Nonlin/mark.lisp"
			 "/g/joe-user/Nonlin/printplan.lisp"
			 "/g/joe-user/Nonlin/backtrack.lisp"
   		         "/g/joe-user/Nonlin/operators.lisp"
			 ))

;;; LIST OF NONLIN OBJECT FILES
(setq *planner-files-o*  '("/g/joe-user/Nonlin/util.o"  
			 "/g/joe-user/Nonlin/def.o"
			 "/g/joe-user/Nonlin/dev.o"
			 "/g/joe-user/Nonlin/readschema.o"
			 "/g/joe-user/Nonlin/tome.o"
                         "/g/joe-user/Nonlin/gost.o"
			 "/g/joe-user/Nonlin/schema.o" 
                         "/g/joe-user/Nonlin/link.o"
			 "/g/joe-user/Nonlin/plan.o" 
                         "/g/joe-user/Nonlin/expand.o"
			 "/g/joe-user/Nonlin/establish.o" 
                         "/g/joe-user/Nonlin/init-planner.o"
			 "/g/joe-user/Nonlin/init-always.o"
                         "/g/joe-user/Nonlin/mark.o"
			 "/g/joe-user/Nonlin/printplan.o"
			 "/g/joe-user/Nonlin/unify.o" 
			 "/g/joe-user/Nonlin/backtrack.o"
			 "/g/joe-user/Nonlin/operators.o"
			 ))    

(defun load-l ()
;;; Load NONLIN Source Files
  (dolist (file *planner-files*)
       (load file))
)

(defun compile-l ()
;;; Compile NONLIN Source Files
    (proclaim '(optimize (safety 2)))
    (dolist (file *planner-files*)
	    (compile-file file)))     

(defun load-o ()
;;; Load NONLIN Object Files
    (dolist (file *planner-files-o*)
	    (load file)))


(defun compile-files (&rest files)
    (for (file :in files)
	 :do
	 (compile-file file)
	 ))





