;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; Common Lisp NONLIN - University of Maryland at College Park 
;;;;
;;;; Version 1.2, 11/91
;;;; (email nonlin-users-request@cs.umd.edu for more info)
;;;; 
;;;; INIT-ALWAYS.LISP:  Routines for manipulating initial and always contexts
;;;;
;;;; History:


;;; 9/13/91 - Fixed bug in q&a-always-ctxt and q&a-initial-ctxt (both bomded on null ctxt)

(defvar *init-ctxt* nil "the node  representing input state")
(defvar *always-ctxt* nil 
    "the node representing tautologies like (clear table)")
    
;;;  these nodes don't figure in tome or gost.. instead, planhead stands
;;; proxy for them.....    

;; creates the node *init-ctxt* and stores all patterns (predicates) that 
;; are true in the initial condition

(defun store-init-ctxt (patterns)
    (setf *init-ctxt* (make-node :type :init-ctxt :nodenum -1))
    ;;init-ctxt is given the node number -1
    ;;;dynamic binding trick so that store-pat works
    (for (pat :in patterns)
	 :do (store-pat pat :place (node-ctxt *init-ctxt*)))
)
;; creates the node *always-ctxt* and stores all patterns (predicates) that 
;; are always true in the world like "(clear table)" in unlimited table size
;; blocks world domain

(defun store-always-ctxt (patterns)
    (setf *always-ctxt* (make-node :type :always-ctxt :nodenum -2))
    ;;always ctxt is given node number -2
    (for (pat :in patterns)
	 :do (store-pat pat :place (node-ctxt *always-ctxt*)))
)
    

;; given a possible non ground pattern this function returns all
;; patterns that unify with the given pattern and are true in the
;; initial condition. It also returns the binding that unify

(defun q&a-init-ctxt (pattern)
    (cond ((null (node-ctxt *init-ctxt*)) nil) ; null init context?
          (t (retrieve pattern :from-data-list (node-ctxt *init-ctxt*)
        	:with-pat t))))
    
;; given a possible non ground pattern this function returns all
;; patterns that unify with the given pattern and are always true 
;; . It also returns the binding that unify

(defun q&a-always-ctxt (pattern)
    (cond ((null (node-ctxt *always-ctxt*)) nil) ; null initial context?
          (t (retrieve pattern :from-data-list (node-ctxt *always-ctxt*)
        	:with-pat t))))
	      
;; when a condition that is true in the initial condition is 
;; deleted by some node in the network, that condition is 
;; moved by this routine from *init-ctxt* to  *planhead*.
;; It saves the information that the *init-ctxt* was modified
;; in *init-ctxt_modification-list* for backtracking. It also
;; updates the gost and tome entries with that condition 

(defun modify-init-ctxt (effect type)
   (declare (ignore type))
    (if (find effect (node-ctxt *init-ctxt*) :test #'equal )
	(then
	     (dremove effect (node-ctxt *init-ctxt*) :test 'equal)
	     (store-pat  effect  :place (node-ctxt *planhead*))
	     ;;save the information that the init-ctxt was modified.
	     (push (add-context effect) *init-ctxt-modification-list*)
	     ;;enter this effect in tome under plan-head 
             (enter-tome effect :assert (node-nodenum *planhead*))
	     ;;now change any gost and tome entry for this effect
	     ;;which have init-ctxt as the contributor
 
	     (let ((gentrys (gost-entrys effect))
		   (tentry (lookup-tome effect)))
		  (for (gentry :in gentrys)
		       :do 
		       (setf (gentry-contributors gentry)
			     (push (substitute (node-nodenum *planhead*)
				    (node-nodenum *init-ctxt*)
				    (pop (gentry-contributors gentry)))
				   (gentry-contributors gentry)))
		  )
		    #|   (setf (tome-entry-asserts tentry)
			     (mapcar #'substitute-init-ctxt 
				      (tome-entry-asserts tentry)))
		       (setf (tome-entry-deletes tentry)
			     (mapcar #'substitute-init-ctxt 
			
                                      (tome-entry-deletes tentry))) |#
	     ))))
