;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; Common Lisp NONLIN - University of Maryland at College Park 
;;;;
;;;; Version 1.2, 11/91
;;;; (email nonlin-users-request@cs.umd.edu for more info)
;;;; 
;;;; EXPAND.LISP:  Expand nodes in network
;;;;
;;;; History:
;;;; 09/22/91 bpk - added code to store parent-child hierarchy in *kids*


(defun supersedes-p (type1 type2)
    (member type2 (get type1 'subordinates))
)
(eval-when (compile load eval)
    (setf (get :precond 'subordinates) '(:use-when))   
)

;;; Given a schema-instance i.e. ground schema, this function  replaces the
;;; higher level node 'expnode' by its expansion 'sch'. It does all relocation
;;; etc.

(defun EXPAND-NODE-USING-SCHEMA-INSTANCE  ( sch expnode)
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;    
    ; we expect node to be of type node!!
    ; sch contains a copy of the  schema being used and the bindings
    ; supplied by the schema fetch.
    ; the schema contains expansions in the form of a strip,
    ; the conditions or effects the expansion are in terms of the nodenumbers
    ; in the strip 
    ; {expansion has to establish use-when cond 
    ; of schema (DOES NON-LIN HAVE USE-WHEN CONDITIONS ON SCHEMA?)}
    ; it should put prec, succ links between expansion nodes also
    ; But, in this implementation, we read in expansions of schemas 
    ; as small flexible strips.  the ordering info is  inherent in the 
    ; expansion.  so we do not need to do any ordering. Null expansions
    ;;can be taken care of by checking if the node is marked primitive
    ;;in which case we won't add it to the taskqueue.
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    (if (and (or (eq (debug-p) t) (member 'schema (debug-p)))
	     (not (member (node-type expnode) '(:plan :dummy :planhead))))
	(print-schema sch))
    (let* ((expnum (node-nodenum expnode))
	   ; we are assuming that sch contains a COPY
	   ; of the actual schema so it is okay to
	   ; screw around with their strip nodes
	   (anodes (schema-strip sch))
	   (size  (schema-size sch))
           lastnode
           last
           firstnode
           first
           (current-striplen *striplen*)
           ; *striplen* value will change during this
	   ; routine...so we remember it now
           (sname (schema-name sch))
	  )

          (if (> size 0) (then         ;; bug fix - 4/91 bpk 
          ;;if size is zero, expansion is null, we have to 
	  ;;just add effects and get out
	  (setf lastnode  (aref anodes (- size 1)))
	  (setf last (- size 1))
	  (setf firstnode (aref anodes 0))
	  ;(first 0)	   ; anodes array goes from 0 to size-1
	
	  (flet ( (relocate (nodes )
		      ; a local function to relocate nodes right
		      ; it uses "last","expnum" and "*striplen*"  as free variables
		      ; it adds current-striplen to all nodes of the expansion
		      ; except last node, which is placed at expnum
		      (if (not (or (null nodes) (consp nodes)))
			  (cond ((eq nodes last) expnum)
				(t (+ nodes current-striplen)))
			  
			  (for (n :in nodes) 
			       :save
			       (cond ((eq n last) expnum)
				     (t (+ n current-striplen)))))))
		
		(do ((index 0 (1+ index)))
		    ((> index (1- size)))
		  ;;so that the expansion will get put in depth-first properly..
		  ;;implements interlevel depth first and intra-level breadth
		  ;;first

 		    (let ((newnode (aref anodes index))
		     	  (newplace (relocate index)))
			  ;this sets the nodes new place appropriately
			  (set-allnodes newnode  newplace)
			  ; put the node in the Allnodes
			  (make-child newnode expnode)
			      
			  ; the parent child links placed
			  ; these are in the form of structures
			       
			  ; relocate and add context to the the successor and 
			  ; predecessor nodes of newnode.

		    	  (if (node-succnodes newnode)
     		   	   (setf (node-succnodes newnode)
           	           (list (add-context (relocate (node-succnodes newnode)))))
                          )
		  	  (if (node-prenodes newnode)
     		   	   (setf (node-prenodes newnode)
           	     	   (list (add-context (relocate (node-prenodes newnode)))))
 		          )

		          (unless (eql (node-type newnode) :primitive)
			       ; Thus, new node is queued in the task queue
			       ; only if it is non-primitive--this can
			       ; result in null expansions
		             (enter-taskqueue newnode)
			      ;;breadth-first
			   )
			       
			       
		      )
		) ;end of do loop for relocation. we have taken care of 
		  ;relocation properly
	      ; make the predecessor nodes of the expanded node the predecessor
	      ; node of the first node i.e. firstnode of the expansion i.e
	      ; schema. 

              (store-children expnode sname)

	      (if (get-prenodes expnode)
   	       (then
 		(for (node :in (get-prenodes expnode))
		     :do
		     (let ((succnodes (remove-list expnode (get-succnodes node))))
			   (push (add-context (append1 succnodes 
				(node-nodenum firstnode))) (node-succnodes node))))
  		;little hack, reset the prenodes of firstnode properly
         	(setf (node-prenodes firstnode) (list (add-context 
			(get-prenodes expnode)))) 
		)
               )
		    
	       ; make the successor nodes of 'expnode' the successor nodes of
	       ; lastnode of the schema.
		    
	       (if (get-succnodes expnode)

		(setf (node-succnodes lastnode)
		      (list (add-context (get-succnodes expnode))))
	       )
	       ; the back of the expansion is connected in
               ;copy all the conditions of expnode to the firstnode
	       (for (econd :in (node-expanconds expnode))
	    	    :do		     
		    (let ((econd-copy (my-copy-scondition econd)))
		    (setf (scondition-atnode econd-copy) (node-nodenum firstnode))
		    ;;change the atnode to firstnode...
		    (pushnew econd-copy (node-expanconds firstnode))
                    )
	       )

		; relocate all the conditions in the schema 'sch' and make
	        ; appropriate gost entries.

		(for (scondition :in (schema-conditions sch))
		     :do
		     (let* ( (cond-pat (scondition-pattern scondition))
			     (cond-type (scondition-type scondition))
			     (old-cond (find cond-pat (node-expanconds firstnode)
					     :key #'scondition-pattern
					     :test #'equal))
			     ;;at this step old-cond will be non-null if there
			     ;;was a condition of the same pattern at the parent
			     ;;node--
			     (atnode (relocate (scondition-atnode scondition)))
			     ;;atnode is the node into which this condition 
 			     ;;should go
			     (relocated-contributors
				(relocate (scondition-contributors scondition)))
			     
			   )
			   (if (and old-cond (supersedes-p (scondition-type old-cond)
						 cond-type))
			       ;if a similar condition exists in the parent node
			       ;;AND its type supersedes the type of the current
			       ;;condition, then, we take this as the current 
			       ;;condition and change gost entry such that the 
			       ;atnode is now relocated atnode of the scondition
			       (then
				    (dremove old-cond (node-expanconds firstnode))
			       ;;the condition is removed from expnode,such is
			       ;;that it is not tagged on to first node again..
				    (setf (scondition-atnode old-cond) atnode)
				    ;;old-cond now is properly changed
				    (pushnew old-cond (node-expanconds atnode) :test #'equal)
				    (for (gentry :in (gost-entrys cond-pat))
					 ; get the gost entrees that have this condition
					 ; and 2. change the node entry to the atnode
					 :when (eql (get-gentry-node gentry) 
						    (node-nodenum expnode))
					 :do 
					 (push (add-context (node-nodenum atnode))
				 		(gentry-node gentry))
				    )
				    ;;the condition is properly entered into GOST
			       )
			       (else 
				     ;;either there is no old condition or
				     ;;the old condition does not supersede scondition
				     (setf (scondition-contributors scondition)
					   relocated-contributors)
				     (setf (scondition-atnode scondition)
					   atnode)
				     (enter-gost cond-pat cond-type
					 atnode relocated-contributors)
				     (pushnew (copy-scondition scondition)
					 (node-expanconds atnode) :test #'equal)
				     ;;the condition is added to node
			       ))
		     ))
		 (for (fcond :in (node-expanconds firstnode))
  		      :do
		      (for (gentry :in (gost-entrys (scondition-pattern fcond)))
			      ; get the gost entrees that have this condition
			      ; and 2. change the node entry and node type to
			      ; firstnode and firstnode->type
		           :when (eql (get-gentry-node gentry) 
			              (node-nodenum expnode))
		           :do 
		           (push (add-context (node-nodenum firstnode))
			         (gentry-node gentry))
		       )
			 ;;gost also knows now that the condition is on firstnode..
		 )
		; relocate all effects in schema 'sch'

		(for (seffect :in (schema-effects sch))
		     :do
		     (setf (seffect-atnode seffect)
			   (relocate (seffect-atnode seffect)))		     
		     ;;now, sch contains the relocated seffects
		     
		)
		; the last two statements take care of
		; conditions and effects		
		
#|
 		(for (eff-pat :in (node-ctxt expnode))
 		     ;;lets have the patterns only in context--for uniformity
 		     ;;with init ctxt
 		     :do		     
 		     ;;(store-pat eff-pat :place (node-ctxt expnode)))
 		(pushnew eff-pat (node-ctxt expnode)))
               (for (seffect :in (schema-effects sch))
		    :do
		    (pushnew seffect (node-ctxt (seffect-atnode seffect))))
|#
	  ) 			; end flet
			 )	; end then
          (else
             (for (seffect :in (schema-effects sch))
                :do
                (setf (seffect-atnode seffect) expnum))
	  )) 			; end if

 	  ; effects go into context

	  (setf (node-expansion expnode) sch)
	  (add-effects (schema-effects sch))
	  ;;add effects of the expansion to tome and node ctxt

          ;; DEVISOR mods:
          ;; after node expansion, propagate window compressions
          ;;   from first node in expansion to other (colinear) nodes
          (when *devisor-mods* 
             (if (not
                (propagate-window-compressions (allnodes expnum) nil))
                (backtrack)) ; backtrack if unsuccessful
          )

	  (return-from expand-node-using-schema-instance sch)
    )     				;  end let
)			

(defun add-effects (seffects)
  ;add all the effects which are not in always-true to the TOME
  (for (seffect :in seffects)
    :do
    (if (not (q&a-always-ctxt (seffect-pattern seffect)))
       (enter-tome (seffect-pattern seffect) (seffect-type seffect)
	 	   (seffect-atnode seffect)))
  )
  ;Now try to remove all the interactions produced by the added effects. If they
  ;can not be removed then delete all the effects from TOME and backtrack.

  (let ((suggested-net '(nil)))
   ;at the end suggested-net contains all possible linearizations.
   (for (seffect :in seffects)
    :do
    (let* ((seffect-node (seffect-atnode seffect))
	   (seffect-pat  (seffect-pattern seffect))
	   (seffect-type  (seffect-type seffect))
	   conflict-node-set
	   (conflict-condition (if (eql seffect-type :assert)
				   ;;;this calculates the
				   ;;;condition of opposite
				   ;;;polarity to that of
				   ;;;effect
				   (negate-pat seffect-pat)
				   seffect-pat))
	   (effect-condition (negate-pat conflict-condition))
	  )
	 
         (if (not (q&a-always-ctxt seffect-pat))
          (then	 
	   (setf conflict-node-set  (tome-conflicts  seffect-pat seffect-type))
	   ;; if conflict-set is not null, there are interactions
	   (if (and (not (null conflict-node-set)) (not (fail-p suggested-net)))
	      (setf suggested-net
               (resolve-interaction :conflict-nodes conflict-node-set
	   		            :offender seffect-node
			            :offender-effect effect-condition
				    :extra-links suggested-net))))
	 ))
    )
    (if (fail-p suggested-net)
       ; interactions can not be removed and therefore backtrack
       (then
	  (backtrack))
       (else
	(if (not-empty suggested-net)
         (then
	  ;save the alternative linearizations if any in context history
	  (push (add-context (make-backtrack-entry :type :expand
			     :alternatives (cdr suggested-net))) *context-list*)
   	  ;create a new context
   	  (create-new-context)
          (linearize (car suggested-net))))
	 (for (seffect :in seffects)
	      :do
;	      (pushnew (seffect-pattern seffect) (node-ctxt (seffect-atnode seffect))))
	      (pushnew seffect (node-ctxt (seffect-atnode seffect))))
	))
    ))
(defun remove-list (node list)
 (cond ((null list) nil)
       ((or (equal node (car list)) (equal (node-nodenum node) (car list)))
        (remove-list node (cdr list)))
       (t (cons (car list) (remove-list node (cdr list))))))
  

(defun store-children (expnode sname)
;;; store info about the parent-child hierarchy in global variable *kids*
   (let ((parent-id (snode-id expnode))
         (parent-type (node-type expnode))
         (parent-todo (node-todo expnode))
         (children (node-children expnode))
         kid-list
        )
      (cond ((null children) 
         (setf *kids* (cons (list parent-id parent-type parent-todo sname '()) *kids*)))
      (t
         (dolist (kid children) 
            (setf kid-list
              (cons (list (snode-id kid) (node-type kid) (node-todo kid)) kid-list)))
         (setf *kids* (cons (list parent-id parent-type parent-todo sname kid-list) *kids*))
      ))
))

         