;;;-----------------------------------------------------
;;;
;;;  Datastructures.lisp
;;;  Nick Short
;;;  6/92
;;;
;;;  This file contains the data structures necessary
;;;  for doing the task allocation in disttaskalloc.lisp.
;;;  It is used for both search techniques in the disttaskalloc.lisp
;;;  or, namely, the depth first and best first.
;;;
;;;-----------------------------------------------------

;;;  For m tasks and n processors
(defstruct (constraints (:conc-name cnode-) 
			(:print-function print-constraints))
  ;;; task list
  (Tasks nil)     ;;; enumerated from 0 to m - 1
 
  ;;; Processor List
  (Processors nil) ;;; enumerated from 0 to n - 1;is a processor structure 

  ;;; constraints
  (P nil :type (array bit (* *)))   ;;; m x n bit array
  (E nil :type (array bit (* *)))   ;;; m x m bit array for task exclusion
  (C nil :type array)   ;;; m x m  array for number of data transfer bytes. 
  (D nil :type  array)  ;;; n x n array for  interprocessor comm. costs
  (Q nil :type array)   ;;; m x n cost of processing task-i on process-j
  )

(defstruct (processor (:conc-name pnode-) (:print-function print-processor))
  ipname
  processor-speed      ;;; e.g., MIPS, MFLOPS, etc.
  available-storage    ;;; typically disk space available
)  
  
(defstruct (task (:conc-name tnode- ) (:print-function print-task))
  tname
  Memory-requirement  ;;; the amount of memory required for task-i.
)

;;; -----------------------------------------
;;;  print functions for structures
;;;  

(defun print-constraints (node stream depth)
  (let ((*print-gensym* nil)
	(*print-array* t)
	(tasks (cnode-tasks node))
	(processors (cnode-processors node))
	(P (cnode-P node))
	(E (cnode-E node))
	(C (cnode-C node))
	(D (cnode-D node))
	(Q (cnode-Q node)))
    (format stream "{")
    (format stream "<m = ~S tasks, n = ~S processors>~%"
	    (length tasks) (length processors))
    (if tasks (format stream "~{~S~}" tasks))
    (format stream "~%--------------------------~%")
    (if processors (format stream "~{~S~}" processors))
    (if P (progn 
	    (format stream  "Preference matrix (m x n)~%")
	    (pprint P)))
    (if E 
	(progn 
	  (format stream  "~%Exclusion matrix (m x m)~%")
	  (pprint  E)))
    (if C 
	(progn (format stream  "~%Data exchange between tasks (m x m)~%")
	       (pprint C)))
    (if D (progn 
	    (format stream  "~%Network data rates (n  x n)~%")
	    (pprint D)))
    (if Q (progn
	    (format stream "~%Execution times for tasks (m x n)~%")
	    (pprint Q)))))
      


(defun print-processor (node stream depth)
  (let ((*print-gensym* nil)
	(ipname (pnode-ipname node))
	(speed (pnode-processor-speed node))
	(storage (pnode-available-storage node)))
    (format stream "Processor: (Name = ~S,Speed = ~S, Storage = ~S)~%"
	    ipname speed storage)))

(defun print-task (node stream depth)
    (let ((*print-gensym* nil)
	  (tname (tnode-tname node))
	  (tmem (tnode-Memory-requirement node)))
      (format stream "Task ~S uses ~S storage~%" tname tmem)))
      

