
; ---------------------------  trace.s  ---------------------------------

;>>>
;>>> tracing and printing functions
;>>>

(define ^p t)  	 ;> flags for tracing parser fcns, demons, set1
(define ^po t) 	 ;> flags for printing resulting parser output
(define ^c t)  	 ;> flags for demon comment messages
(define ^bob t)  ;> flags for bob comment messages; more or less prints out
		 ;>	a message upon entering every major function.  
		 ;>	rather verbose.

;> set! evaluating first arg; used for tracing
(define (set1 a b)
    (set-top-level-value! a b)
    (out ^p 2 "~a <-- ~a~%" a b)
    b)

;> prints out the comment field of a demon
(define (print-comment body d-atm)
  (let ((comment (kdr (assq 'comment body))))
       (and ^c comment
	    (let ((test (kdr (assq 'test comment)))
		  (act  (kdr (assq 'act comment))))
		 (out ^c 2
		      "===================== ~a ====================~%" d-atm)
		 (out ^c 2 "T: ")
		 (cond (test 
			(out ^c 0 "~a~%" (kar test))
			(walk (lambda (string) 
				      (out ^c 2 "~a~%" string)) 
			      (kdr test)))
		       (else (newline)))
		 (out ^c 2 "A: ")
		 (cond (act 
			(out ^c 0 "~a~%" (kar act))
			(walk (lambda (string) 
				      (out ^c 2 "~a~%" string)) 
			      (kdr act)))
		       (else (newline)))
		 (out ^c 2
		      "==================================================~%"
		      )))))

;> standard tracing command for this program.  whether or not the msg is 
;> 	printed to the screen is determined by the status of the flag, #t 
;>	or #f.  num is the number of tab characters to print before the
;>	msg. 
(define (out flag num . msg)
  (cond (flag 
	 (write-chars #\tab num)
	 (apply fformat (cons (current-output-port) msg)))
	(else nil)))

