
; -------------------------  toplevel.s  --------------------------

;>>>>> 
;>>>>> mcdypar top level
;>>>>> 

(define (parse sentence)
  (letrec ((loop
	    (lambda ()
		    (cond (*go-on* (word-tasks)
				   (demon-tasks)
				   (loop))
			  (else (fin))))))
	  (set! *s* sentence)
	  (set! *go-on* T)
	  (loop)))
 
;> global variable definitions are in the file vardefs.ss

;>>>
;>>> parse result output functions
;>>>

;> fin:  print out the top level con structures in working memory
;>
(define (fin)
  (let ((toplevel-cons
	 (do ((con *wm* (get con 'bef))
	      (topcons nil (if (and (not (get con 'inside))
				    (not (get con 'ignor)))
			       (push topcons con)
			       topcons)))
	     ((null? con) topcons)
	     (out ^bob 0 "<<< fin con: ~a topcons: ~a~%" con topcons))))
       (pretty toplevel-cons)
       (set! *em* (append *em* toplevel-cons))
       (newline)
       '--------------------------------------------------------------))

;> pretty:  print out final output of parser
;>
(define (pretty l)
  (out ^po 0 "~%~%~%Result of parse:~%~%")
  (letrec ((printcon 
	    (lambda (con)
		    (if ^po 
			(begin (pretty-print (expand-cd con))
			       (newline) (newline))
			(newline)))))
	  (walk printcon l))
  l)

