
; ----------------------------  t2chez.s  ----------------------------

;; -----------------------------------------------
;; T-in-Scheme compatibility package	
;; 	(from Slade, _The T Programming Language_)
;; -----------------------------------------------

;; in T, (car '()) and (cdr '()) return ()
(define (kar l) (if l (car l) nil))
(define (kdr l) (if l (cdr l) nil))

(define ->integer	truncate)
(define (float? x) (and (real? x) 
			(not (integer? x))))
(define add1		1+)
(define subtract1	-1+)
(define list? 		pair?)
(define alikev?		equal?)
(define nth		list-ref)
(define nthcdr		list-tail)
(define last		last-pair)
(define (lastcdr list) (kdr (last list)))
(define (sublist l start count)
  (cond ((positive? start) (sublist (nthcdr l start) 0 count))
	((zero? count) nil)
	(else (cons (kar l)
		    (sublist (kdr l) 0 (- count 1))))))
(define memq?		memq)
(define walk		for-each)

;; Note: this version of "push" and "pop" from T doesn't handle cases like
;;
;;		(push (cdr bob) 'nice)
;;		(pop (cdadr bob))
;;
(extend-syntax (push)
  ((push list item)
   (set! list (cons item list))))

(extend-syntax (pop)
  ((pop list)
   (let ((return (kar list)))
	(set! list (kdr list))
	return)))

;;
(define (generate-symbol prefix)
  (let ((new-string (symbol->string (gensym))))
       (string->symbol 
	(string-append (symbol->string prefix)
		       (substring new-string 1 (string-length new-string))))))

;; fformat: this version of format writes to the current-output-port instead 
;;		of returning the string, as in the chez scheme version;  
;;		fformat returns "#t" instead.  However, this version does not 
;;		do all the things that the T format function does.
;;
(define fformat
  (lambda (output-port format-string . objects)
	  (let ((ip (open-input-string format-string)))
	       (let ((op output-port))
		    (let f ((c (read-char ip))
			    (ls objects))
			 (cond ((eof-object? c) #t)
			       ((char=? c #\~)
				(case (read-char ip)
				      (#\s
				       (write (car ls) op)
				       (f (read-char ip) (cdr ls)))
				      (#\a 
				       (display (car ls) op)
				       (f (read-char ip) (cdr ls)))
				      (#\c
				       (write-char (car ls) op)
				       (f (read-char ip) (cdr ls)))
				      (#\%
				       (newline op)
				       (f (read-char ip) ls))
				      (#\~
				       (write-char #\~ op)
				       (f (read-char ip) ls))))
			       (else 
				(write-char c op)
				(f (read-char ip) ls))))))))

;; PCScheme only
;;
(define (delq object lst)
  (delete! '()
           (map (lambda (x)
                  (if (not (eq? x object))
                      x))
                lst)))

