
; ----------------------  spawn_dm.s  --------------------------------

;>>>
;>>> functions to spawn demons
;>>>

;>form is; (SPAWN con dform)
;>where con is an atom, and dform is a named demon:
;>			(name arg-1 ... arg-n)
;> spawn does the following:
;>	a. replaces the args in a dform with their values
;>	b. pushes each d-atom onto a d-agenda under a specified con
;> NOTE: spawn should be called from user defined demons.
;>       spawn-dforms is called at word definition time.

(syntax (spawn con dform)
        (begin 
	  (out ^bob 0 "<<< spawn con: ~a dform: ~a~%" `(quote ,con)
						      `,(quote dform))
          (spawn-dform con `,(quote dform))))

;> adds in the implicit mycon and mygap parameters when the demon to be
;> 	spawned ocurrs after a "<==" in a word definition in the lexicon
;>
(define (spawn-dforms con dforms gap)
  (out ^bob 0 "<<< spawn-dforms con: ~a dforms: ~a gap: ~a~%" con dforms gap)
  (if (atom? (kar dforms)) (set! dforms (list dforms)))
  (walk (lambda (dform)
		(let ((head (kar dform))
		      (args (cond (gap (append (list (list 'quote con) 
						     (list 'quote gap))
					       (kdr dform))) ;--> to be evaled
				  (else
				   (append (list (list 'quote con))
					   (kdr dform))))))
		     (spawn-name con head args)))
	dforms))
  
;> auxilliary function for "spawn-dform"
;>
(define (quote-args arglist) 
  (if (null? arglist) nil 
      (cons (list 'quote (demon-eval (kar arglist))) 
	    (quote-args (kdr arglist)))))

;> like spawn-dforms except mycon and mygap assumed already
;> inserted in body.  this function is called from SPAWN
;>
(define (spawn-dform con dform)
  (out ^bob 0 "<<< spawn-dform con ~a dform ~a~%" con dform)
  (let ((head (kar dform))
	(body (kdr dform)))
       (cond
	((get head 'demon) (spawn-name con head (quote-args body)))
	(else 
	 (out ^p 2 "dform not spawned since name ~a undefined~%" head)))))

;> eval args and form their vals into a new dform with name at head
;> then put d-atom into a d-agenda on the con
;>
(define (spawn-name con head args)
  (out ^bob 0 "<<< spawn-name con ~a head ~a args ~a~%" con head args)
  (cond
   ((null? (get head 'demon))
    (out ^p 2 "~a not spawned since undefined~%" head))
   (else 
    (let ((new-args 
	   (map (lambda (arg) (eval arg))
		args)))
	 (let ((d-atom (generate-symbol 'dem)))
	      (set-top-level-value! d-atom (cons head new-args))
	      (out ^p 1 "Spawning: ~a = ~a~%" d-atom (eval d-atom))
	      (print-comment (get head 'demon) d-atom)
	      (d-agendize con d-atom))))))

;> the agendas are currently just lists;
;> push the demon onto the agenda
;>
(define (d-agendize con d-atom)
    (put con 'd-agenda (cons d-atom 
				 (get con 'd-agenda))))


