
; ---------------------------- set.s  ----------------------------------
;>>> 
;>>> variations on set!
;>>> 

;; set-indirect!:  same as set! function, except it (1) evaluates the first
;;	argument to enable indirect reference and (2) takes an environment
;;	variable.
;;
(syntax (set-indirect! exp value env)
	(cond (env (eval `(set! (access ,exp env) (quote ,value)))
                   value)
              (else (eval `(set! ,exp (quote ,value)))
                    value)))

;; set-top-level-value!:  the name of this function as I've defined it 
;;    here is a bit misleading;  in Chez-Scheme, this function sets the
;;    value of a variable in the top-level environment; but the important
;;    part (for my purposes) is the fact that it evaluates its first
;;    argument -- "set!" does not do this, since it is a special form.
;;    This extra evaluation allows indirect referencing of variables, and
;;    is only this feature that I have implemented here.
;;
(define (set-top-level-value! exp value) 
  (set-indirect! exp value user-initial-environment))

