
; -------------------------  lexikon.s  ---------------------------

;>>>
;>>> word definition function
;>>>

;> template for word:
;>    (WORD name
;>       DEF	config
;>       DEMONS	dforms
;>       M1	config
;>           ...
;>       Mn	config )
;> 
;> NOTE: If the word is unambiguous its config should be put in
;>       the def field. If it is ambiguous, the configs associated
;>       with the various meanings should be placed in fields
;>       m1 - mn with the def field remaining blank.

(define (word lst)
  (let* ((name (pop lst))
	 (adddef (lambda (indic val)
			 (if (eq? indic 'value)
			     (set-top-level-value! name val)
			     (put name indic val)))))
	(put name 'word t)
	(do ((indic (pop lst) (pop lst))
	     (val (pop lst) (pop lst)))
	    ((null? lst) (adddef indic val) name)
	    (adddef indic val))))

;>>>
;>>> words
;>>>

(word '(john
	def 	(human 	name (john)
			gender	(male))
	demons	(save-character)))

(word '(picked
	demons	((pick-up?) (decide?))
	m1	(grasp actor h <== (exp 'human 'bef)
		       object x <== (exp 'phys-obj 'aft)
		       instr (move actor h
				   object (fingers)
				   to x))
	m2	(mbuild actor * <== (exp 'human 'bef)
			mobj (poss actor * <== (exp 'human 'bef)
				   object * <== (exp '(human phys-obj) 
						     'aft)))))

(word '(up
	demons 	(ignor)))

(word '(the
	demons 	(ignor)))

(word '(ball
	def	(phys-obj class (game-obj)
			  name (ball))
	demons	(save-obj)))

(word '(and
	def	(*conj*)
	demons 	(ignor)))

(word '(dropped
	def	(ptrans actor * <== (exp 'human 'bef)
			object thg <== (exp 'phys-obj 'aft)
			to * <== (prep '(in into on) '(human phys-obj) 'aft)
			instr (propel actor (gravity)
				      object thg))))

(word '(it
	def 	()
	demons 	(find-obj-ref)))

(word '(in
	def 	(prep is (in))
	demons	(ins-aft '(phys-obj setting) 'prepobj)))

(word '(box
	def	(phys-obj class	(container)
			  name 	(box))))

