
; ------------------------  init.s  ---------------------------------

;>>>>>
;>>>>> initialization file
;>>>>>

;>>> convenient general utility functions

;; lets you use the vi editor from PCScheme 
;; 	(put the filename in quotes)
;; 
(define (vi filename)
  (dos-call "" (string-append "vi " filename)))

;; this function prints out all the variable bindings used by
;;    demons 
;;
(define (demon-bind) (environment-bindings demon-env))

(define (load-with-echo filename)
  (load filename)
  (display "==> ")
  (display filename)
  (newline))

;; writes a the character "char" n times
;;
(define (write-chars char n)
  (do ((i n (subtract1 i)))
      ((zero? i) #t)
      (write-char char)))

;; writes n spaces
;;
(define (write-spaces n) (write-chars #\space n))

;; writes a tab
(define (tab) 
  (write-char #\tab)
  #t)

;>>> load other files
(load-with-echo "extend.s")
(load-with-echo "t2chez.s")
(load-with-echo "chez2pcs.s")
(load-with-echo "set.s")
(load-with-echo "dem.s")
(load-with-echo "vardefs.s")
(load-with-echo "toplevel.s")
(load-with-echo "wd_tsks.s")
(load-with-echo "exec_dms.s")
(load-with-echo "spawn_dm.s")
(load-with-echo "dm_defs.s")
(load-with-echo "lexikon.s")
(load-with-echo "utilitee.s")
(load-with-echo "trace.s")


(define example '(john picked up the ball and dropped it in the box))

;; the *wm* variable must be cleared before every separate run
;;
(define (run sentence)
  (set! *wm* nil)
  (parse sentence))

