
;---------------------------- dm_defs.s ----------------------------

;>>>
;>>> demon definition function
;>>>
(define (demon lst)
  (let ((name (kar lst)))
       (put name 'demon (kdr lst))
       name))
;>>>
;>>> general parsing and memory construction demons
;>>>
(demon '(exp
	 (params mycon mygap classes dir)
	 (comment (test "Search in the given DIRection for a CON in one of"
			"   the given CLASSES until a boundary is reached")
		  (act  "Bind the CON to the given GAP"))
	 (kill (demon-eval mygap))
	 (test (let ((stop-at-conj 
		      (lambda (c)
			      (or (and (class? (con-head c) '*conj*)
				       (if (class? 'human classes) 
					   *local-char*))
				  (class? (con-head c) 'boundary)))))
		    (search (lambda (con)
				    (and (not (eq? con mycon))
					 (class? (con-head con) classes)))
			    mycon stop-at-conj dir)))
	 (+act (link mycon mygap test))))

(demon '(save-character
	 (params mycon)
	 (comment (act "Bind the MYCON to the MOST-RECENT-CHARACTER; if there"
		       "   is no LOCAL-CHARACTER bind the MYCON to it also"))
	 (+act (set! *most-recent-char* mycon)
	       (and (null? *local-char*)
		    (set! *local-char* mycon))
               (spawn mycon (print-comment mycon mycon)))))

;> the "print-comment" demon is not included in the original example
;> from the _In-Depth Understanding_ book;  I have added it here for 
;> the sole purpose of demonstrating how demons can spawn other demons;
;> this demon is spawned from the "save-character" demon, and it really 
;> doesn't do a hell of a lot.
;>
(demon '(print-comment
          (params mycon)
          (+act (out t 1 "new character: ~a~%" (demon-eval mycon)))))

;> Disambiguation for "pick up"
;> Note:  doesn't consider case of "John picked a girl up at a bar."
(demon '(pick-up?
	 (params mycon)
	 (comment (test "If the next word is UP ...")
		  (act  "Set the MYCON to the grasp configuration"))
	 (kill (demon-eval mycon))
	 (test (eq? *next-w* 'up))
	 (+act (con-set mycon (get 'picked 'm1)))))

;> Disambiguation for "pick" to mean "choose" in the sense of "deciding"
(demon '(decide?
	 (params mycon)
	 (comment (test "Search for a person or a physical object after the"
			"   MYCON")
		  (act  "Set the MYCON to the decision configuration"))
	 (kill (demon-eval mycon))
	 (test (search (lambda (con)
			       (and (not (eq? con mycon))
				    (class? (con-head con) '(human phys-obj))))
		       mycon nil 'aft))
	 (+act (con-set mycon (get 'picked 'm2)))))

;> Put an IGNOR property on the concept (to indicate that it has been
;>	processed and can be ignored)
(demon '(ignor
	 (params mycon)
	 (+act (put mycon 'ignor t))))

;> Saves objects in a global variable for pronoun reference
(demon '(save-obj
	 (params mycon)
	 (comment (act "Bind the MYCON to the MOST-RECENT-OBJECT."))
	 (+act (set! *most-recent-obj* mycon))))

;> In the trace, prepositions are treated like modifiers, e.g. "with Mary"
;>  	causes the concept for "Mary" to be 'modified' by "PREP-OBJ prep."
;>	Demons sensitive to prepositions can then search for a CLASS of 
;>	object modifiers by prepositions.
;>	(This is not the only way to do it, of course)
;>
(demon '(prep
	 (params mycon mygap preps classes dir)
	 (comment (test "Search for a CON with one of the given CLASSES"
			"   and preceded by one of the given PREPOSITIONS")
		  (act  "The CON is bound to the given GAP"))
	 (kill (demon-eval mygap))
	 (test (prep-search mycon preps classes dir))
	 (+act (link mycon mygap test))))

;> (all search functions should be defined in terms of the McDypar function
;>	SEARCH)
(define (prep-search mycon preps classes dir)
  (search (lambda (c)
		  (and (not (eq? c mycon))
		       (class? (con-head c) classes)
		       (cond ((atom? preps)
			      (eq? (path '(prepobj is *) c)
				   preps))
			     (else (member-eq (path '(prepobj is *) c)
					      preps)))))
	  mycon nil dir))

(demon '(find-obj-ref
	(params mycon)
	(comment (act "Set the MYCON to the most recently mentioned object"))
	(+act (set1 mycon *most-recent-obj*))))

;> This demon performs modifications on other concepts in WM by adding a new
;>	SLOT GAP pair to it
(demon '(ins-aft
	 (params mycon classes slot)
	 (comment (test "Search for a CON with one of the given CLASSES")
		  (act  "Insert the given SLOT with the MYCON as its"
			"   GAP into the CON"))
	 (test (search (lambda (con)
			       (and (not (eq? con mycon))
				    (class? (con-head con) classes)))
		       mycon nil 'aft))
	 (+act (set1 test (append (demon-eval test) (list slot mycon)))
	       (put mycon 'inside (list test slot)))))
