;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package: ADVISOR -*-
;;; -----------------------------------------------------------------------
;;; File:         np-head.l
;;; Description:  Constituents which can serve as head of NPs 
;;; Author:       Michael Elhadad
;;; Created:      16 Jul 1992
;;; Modified:     
;;; Package:      ADVISOR
;;; -----------------------------------------------------------------------

;;; (in-package "ADVISOR")

(def-conj measure 
  %mm%
  (fset (cat pattern quantity synt-function number unit))
  (pattern (quantity unit))
  (quantity ((alt (((cat cardinal))
		   ((cat ordinal))
		   ((cat fraction))))))
  (unit ((alt (((cat noun))
	       ((cat noun-compound))))))
  (synt-funct ((alt (head classifier))))
  ;; Compute number
  (alt measure-number (:index number)
    (((quantity ((cat cardinal)
		 (value given)
		 (control (and (numberp #@{^ value})
			       (/= #@{^ value} 1)))))
      (number plural))
     ((number singular))))
  ;; Measure used as a classifier does not put an s on unit
  (alt measure-synt-function (:index synt-function)
    (((synt-funct head)
      (unit ((number {^2 number}))))
     ((synt-funct classifier)
      (unit ((number singular)))))))




;; Recursively embedded noun compounds
;; Example: "The pleasant (((house property) tax) office) furniture)" 
;; (Quirk p.919)
(def-conj noun-compound
  %nc%
  (fset (cat pattern number classifier head synt-function))
  (pattern (classifier head))
  (classifier ((synt-funct classifier)
	       (alt (((cat noun))
		     ((cat verb) 
		      (ending ((alt (present-participle past-participle)))))
		     ((cat adj))
		     ((cat ap))
		     ((cat measure))
		     ((cat list))
		     ((cat noun-compound))))))
  (head ((cat noun)
	 (number {^2 number})))
  %nc%
  )


;; ------------------------------------------------------------
(provide "np-head")
;; ------------------------------------------------------------

