;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:FUG3 -*-
;;; ------------------------------------------------------------
;;; File        : IR1.L
;;; Description : Simple inputs to test GR1.
;;; Author      : Michael Elhadad
;;; Created     : 20-Jun-88
;;; Modified    : 18 May 90
;;; Language    : Common Lisp
;;; Package     : FUG3
;;; ------------------------------------------------------------

(format t 
  "Sample examples to use with grammar GR1.~%")

(defun ir11 ()
  (format t "Example ir11: Mary is liked by john.~%")
  (setq ir11
	'((cat s) 
	  (voice passive)
	  (prot ((n === john))) 
	  (verb ((v === like))) 
	  (goal ((n === mary))))))


(defun ir12 ()
  (format t "Example ir12: <fails>~%")
  (setq ir12
	'((cat s)
	  (prot ((n === john) (number sing)))
	  (verb ((v === like) (number plural)))
	  (goal ((n === mary) (number sing))))))


(defun ir13 ()
  ;; Add an irregular verb to lexicon
  (store-verbs '( ("sell" "sells" "sold" "selling" "sold")) )
  (format t "Example ir13: Cars are sold by John.~%")
  (setq ir13
	'((cat s)
	  (voice passive)
	  (prot ((n === "John")))
	  (verb ((v === sell)))
	  (goal ((n === car) (number plural))))))


(defun ir14 ()
  (format t "Example ir14: The meal is eaten by the man.~%")
  (setq ir14
	'((cat s)
	  (voice passive)
	  (prot ((n === man) (proper no)))
	  (verb ((v === eat)))
	  (goal ((n === meal) (proper no))))))


(ir11) (ir12) (ir13) (ir14)




