;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:FUG3 -*-
;;; ------------------------------------------------------------
;;; File        : GR2.L
;;; Description : Simple grammar using Pattern Unification for choice
;;;               of voice (passive/active) based on focus.
;;; Author      : McKeown, Paris, Kwee, Elhadad
;;; Created     : 1982
;;; Modified    : 18 May 90
;;; Language    : Common Lisp
;;; Package     : FUG3
;;; ------------------------------------------------------------


;; No type declaration in effect.
(eval-when (load eval)
  (clear-bk-class)
  (reset-typed-features))

(defun gr2 ()
  (setq *u-grammar*
'((alt all
   (
    ;; 01 CAT S : sentence -------------------------------------------
    ((cat s)
     (pattern ((* focus) dots))
     (alt s
      (
       ;; VERB VOICE ACTIVE (DEFAULT OR EXPLICIT) ----------------------
       ;; There MUST be a protagonist  

       ((verb ((voice active)))
	(prot given)
	(prot ((cat np)))
	(pattern (prot verb dots))
	(verb
	 ((cat verb-group)
	  (number {^ ^ prot number})))
	;; Is there a goal?  ............................................
	(alt
	 (
	  ((goal none))
	  ((goal given)
	   (goal ((cat np)))
	   (pattern (dots goal)))))
	;; ..............................................................
	)

       ;; VERB-VOICE PASSIVE (DEFAULT OR EXPLICIT)  --------------------
       ;; There may not be a protagonist. 

       ((alt passive
	 (
	  ((verb ((voice passive)))
	   (prot none))
	  ((verb ((voice passive)))
	   (prot given)
	   (prot ((cat np)))
	   (by-obj ((cat pp) (prep ((lex "by"))) (np {^ ^ prot})))
	   (pattern (dots verb by-obj dots)))))
	(verb ((cat verb-group)))	
	;; ..............................................................
	(alt goal
	 (
	  ((goal none)
	   (pattern (dots verb dots))
	   (verb ((number singular))))
	  ((goal given)
	   (goal ((cat np)))
	   (pattern (goal verb dots))
	   (verb ((number {^ ^ goal number}))))))
	;; ..............................................................
	)
       ;; --------------------------------------------------------------
       )))
    ;; 02 CAT SLIST : for coordinated main clauses-------------------
    ((cat slist))

    ;; 03 CAT VERB-GROUP
    ((cat verb-group)
     (alt verb-group
      (
       ((voice active)
	(pattern (v dots))
	(v ((cat verb) (lex given) (number {^ ^ number}))))
       ((voice passive)
	(pattern (v1 v dots))
	(v1 ((cat verb) (lex "be") (number {^ ^ number})))
	(v ((cat verb) (lex given) (ending past-participle))))))
     (alt pp
      (
       ((pp none)) 
       ((pp given)
	(pp ((cat pp)))
	(pattern (dots pp)))))
     )

    ;; 04 CAT NP : for noun phrase ----------------------------------------
    ((cat np)
     (alt np
      (
       ((article none)
	(pattern (dots nnp dots)))
       ((article given)
	(article ((cat article) (lex given)))
	(pattern (dots article nnp dots)))))
     (nnp ((cat nnp) (number {^ ^ number}))))
    ;; 05 CAT NPLIST : for coordinated noun phrases -----------------
    ((cat nplist))

    ;; 06 CAT NNP : Noun phrases, WITHOUT article  ------------------
    ((cat nnp)
     (alt nnp
      (
       ((adj none)
	(pp none)
	(tail none)
	(pattern (n))
	(n ((cat noun) (number {^ ^ number}) (lex given))))
       ((alt
	 (
	  ((adj given)
	   (adj ((cat adj) (lex given)))
	   (pattern (adj nnp)))
	  ((pp given) 
	   (pp ((cat pp)))
	   (pattern (nnp pp)))))
	(nnp ((cat nnp) (number {^ ^ number}))))
       )))

    ;; 07 CAT S-BAR : for subordinate clauses  ----------------------
    ((cat s-bar))

    ;; 08 CAT PP : for prepositional phrases ------------------------
    ((cat pp)
     (pattern (prep np))
     (prep ((cat prep) (lex given)))
     (np ((cat np)))
     )

    ;; 09 CAT PPLIST : for coordinated prepositional phrases -------
    ((cat pplist))
    ;; 10 CAT PARENTHETICAL -----------------------------------------
    ((cat parenthetical))
    ;; 11 CAT GAP ---------------------------------------------------
    ((cat gap))
    ;; 12 CAT VERB --------------------------------------------------
    ((cat verb))
    ;; 13 CAT NOUN --------------------------------------------------
    ((cat noun))
    ;; 14 CAT ADJ  --------------------------------------------------
    ((cat adj))
    ;; 15 CAT ARTICLE------------------------------------------------
    ((cat article))
    ;; 16 CAT PREP --------------------------------------------------
    ((cat prep)))))))


(gr2)
