.TH WHEEL HUM (rev3.7)
.ds ]W UC Berkeley
.SH NAME
wheel \- roll through text a word cluster at a time
.SH SYNOPSIS
.nf
\fBwheel\fP  [ \fB+n  \-m  \-d\fIF\fR  \- ]  filename ...
+n: print clusters of n words (default 2)
\-m: do not map upper case to lower case
\-d: define punctuation set according to file F
\- : read standard input instead of files
.fi
.SH DESCRIPTION
To analyze syntactic clusters, you can roll
\fIwheel\fP through your text, several words at a time.
The second word of the initial cluster will become
the first word of the following cluster, and so forth.
By default, each output line contains a two-word cluster,
but with the + option, you can specify any cluster size up to 20.
The \-m option prevents mapping of words to lower case,
and the \-d option can be used to specify non-standard punctuation.
.PP
After extracting all the word clusters in your text,
they can be sorted and counted to find repeated patterns.
Here is an example of a command line to accomplish this:
.nf
 % wheel +3 text | sort | uniq \-c
.fi
Of course, \fIsort\fP can be applied to any field desired;
``sort +2'' refers to the third word on each line.
It would be good to analyze syntactic clusters
of two, three, four, and possibly more words a piece.
British scholars use the cumbersome term ``collocation''
to mean word cluster.
.SH "SEE ALSO"
dissolve(hum), freq(hum), sort(1), uniq(1)
.SH AUTHOR
Bill Tuthill
.SH BUGS
