.TH REVCONC HUM (rev3.7)
.ds ]W UC Berkeley
.SH NAME
revconc \- reverse concordance module
.SH SYNOPSIS
revconc  [ filename ... ]
.SH DESCRIPTION
\fIRevconc\fP reverses the first word on each line,
which in a concordance is, conveniently, the keyword.
This program is intended to be a module to create a reverse concordance.
Words will be alphabetized from the end to the beginning,
rather than from the beginning to the end, as is usual.
The results can be used to examine word endings and inflections.
.PP
It should be used between a series of pipes including
\fIkwic\fP or \fIkwal\fP, \fIsort\fP, and \fIformat\fP.
Here is a suggested command sequence:
.nf
 % kwic filename(s) | revconc | sort | revconc | format
.fi
It must be used twice,
or else the word will appear backwards
in the final version.
The first invocation of \fIrevconc\fP reverses
the keyword, so that \fIsort\fP operates from the back to the front,
while the second invocation restores normal order to the word.
.PP
Many published concordances contain a Reverse List of Graphic Forms;
\fIrevconc\fP can be used for this purpose, but the Unix utility \fIrev\fP
would probably be faster.
Here is a suggested command sequence
for making a Reverse List of Graphic Forms:
.nf
 % prep filename(s) | rev | sort \-u | rev
.fi
The results can be put into columns with the Unix utility \fIpr\fP.
.SH "SEE ALSO"
format(hum), kwal(hum), kwic(hum), pr(1), rev(1), sort(1)
.SH AUTHOR
Bill Tuthill
.SH BUGS
It is not possible to make a reverse concordance using context, 
rather than line number, as the secondary sort field.
