.TH PAIR HUM (rev3.7)
.ds ]W UC Berkeley
.SH NAME
pair \- set two files side by side (or merge lines)
.SH SYNOPSIS
.nf
\fBpair\fP  [ \fB\-m\fP ]  file1  [ \- ]  file2  [ +\fIlen1\fP  [ +\fIlen2\fP ] ]
\-m: merge (intercalate) files line by line
\- : read standard input instead of files
len1 and len2 denote screen width of file1 and file2
.fi
.SH DESCRIPTION
\fIPair\fP is a program for looking at two parallel texts,
in order to compare and contrast them.
By default, \fIpair\fP sets them side by side,
but with the \-m option, it shuffles them together.
This utility is useful for examining manuscript variations.
It will accept standard input rather than a file,
if a dash is used in place of the filename.
Output can be redirected if desired.
.PP
By default, \fIpair\fP prints two 40-character wide columns of text,
which gives equal space to each text, and fills up the screen.
The third and fourth arguments can be used to change
the column width for the first and second files, respectively.
For example, if your first file is composed of numbers
but your second file contains text with occasional long lines,
specify something like:
.nf
 %  pair  file1  file2  +10  +70
.fi
If you have long lines and would rather have
lines from each text on separate lines, use the \-m option.
.PP
\fIPair\fP can be used for comparing textual variants.
It is especially useful for making two texts parallel
before analyzing the variants with \fIdiff\fP or \fIdiff3\fP.
\fIDiff\fP compares two files, while \fIdiff3\fP compares three at a time.
The results from these programs will be more usable
if the texts are parallel before they are analyzed.
.SH "SEE ALSO"
diff(1), diff3(1), pr(1)
.SH AUTHOR
Bill Tuthill
.SH BUGS
When output is redirected and input is being taken from the terminal,
it is impossible to tell what is coming from the input file.
