.TH FORMAT HUM (rev3.7)
.ds ]W UC Berkeley
.SH NAME
format \- format and count keywords in concordance
.SH SYNOPSIS
.nf
\fBformat\fP  [ \fB\-mck\fP ]  [ filename ... ]  [ \- ]
\-m: keywords not mapped from lower to upper case
\-c: suppress counting of keywords (will speed it up)
\-k: suppress printing of separate keyword
\- : read standard input instead of files
.fi
.SH DESCRIPTION
.I Format
is generally the last program used in making a concordance.
Once the concordance has been compiled and sorted,
using \fIkwic\fP or \fIkwal\fP and \fIsort,\fP
the keywords can be formatted into capitalized headings
followed by a frequency count.
\fIFormat\fP depends on sorted input to make its frequency counts.
.PP
If for some reason you do not want an upper case keyword heading,
you can preserve the lower case keywords by using the \-m option.
Keyword counting can also be suppressed by using the \-c option;
this will speed up the \fIformat\fP program somewhat.
To completely suppress printing of a separate keyword,
use the \-k option; this will produce only
the identification field and the context.
.PP
Here is a typical program sequence for a concordance,
suitable for sending to the lineprinter:
.nf
 % kwic \-c100 filename(s) | sort | format | lpr
.fi
The \-c100 argument to \fIkwic\fP creates a long context
suitable for the lineprinter.
.SH FILES
\fIFormat\fP creates a temporary file, /tmp/Fmt?????,
where it stores all the contexts of a single keyword,
while counting the frequency of that keyword.
This tempfile is removed in case of interrupt.
.SH "SEE ALSO"
kwal(hum), kwic(hum), sort(1)
.SH AUTHOR
Bill Tuthill
.SH BUGS
The \-k option silently overrides the \-m and \-c options.
